/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.service.zoho;

import com.fasterxml.jackson.databind.JsonNode;
import eu.europeana.corelib.definitions.edm.entity.Address;
import eu.europeana.corelib.definitions.edm.entity.Organization;
import eu.europeana.corelib.solr.entity.AddressImpl;
import eu.europeana.corelib.solr.entity.OrganizationImpl;
import eu.europeana.enrichment.api.external.model.zoho.ZohoOrganization;
import eu.europeana.enrichment.service.EntityConverterUtils;
import eu.europeana.enrichment.service.dao.ZohoV2AccessDao;
import eu.europeana.enrichment.service.exception.ZohoAccessException;
import eu.europeana.enrichment.service.zoho.model.DeletedZohoOrganizationAdapter;
import eu.europeana.enrichment.service.zoho.model.ZohoOrganizationAdapter;
import eu.europeana.metis.authentication.dao.ZohoAccessClientDao;
import eu.europeana.metis.authentication.dao.ZohoApiFields;
import eu.europeana.metis.exception.GenericMetisException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ZohoAccessService {
    public static final String URL_ORGANIZATION_PREFFIX = "http://data.europeana.eu/organization/";
    private static final String UNDEFINED_LANGUAGE_KEY = "def";
    private static final int LANGUAGE_CODE_LENGTH = 2;
    private final ZohoAccessClientDao zohoAccessClientDao;
    private final ZohoV2AccessDao zohoV2AccessDao;
    private EntityConverterUtils entityConverterUtils = new EntityConverterUtils();

    @Autowired
    public ZohoAccessService(ZohoAccessClientDao zohoAccessClientDao, ZohoV2AccessDao zohoV2AccessDao) {
        this.zohoAccessClientDao = zohoAccessClientDao;
        this.zohoV2AccessDao = zohoV2AccessDao;
    }

    public ZohoOrganization getOrganization(String organizationId) throws ZohoAccessException {
        JsonNode jsonRecordsResponse;
        try {
            jsonRecordsResponse = this.zohoAccessClientDao.getOrganizationById(organizationId);
        }
        catch (GenericMetisException e) {
            throw new ZohoAccessException("Cannot get organization by id: " + organizationId, e);
        }
        JsonNode accountsNode = this.findRecordsByType(jsonRecordsResponse, "Accounts");
        JsonNode jsonRecord = accountsNode.findValue("FL");
        return new ZohoOrganizationAdapter(jsonRecord);
    }

    public ZohoOrganization getOrganizationFromFile(File contentFile) throws ZohoAccessException {
        JsonNode jsonRecordsResponse;
        try {
            jsonRecordsResponse = this.zohoAccessClientDao.getOrganizationFromFile(contentFile);
        }
        catch (IOException e) {
            throw new ZohoAccessException("Cannot get organization from file. ", e);
        }
        catch (GenericMetisException e) {
            throw new ZohoAccessException("Cannot extract organization from file. ", e);
        }
        JsonNode accountsNode = this.findRecordsByType(jsonRecordsResponse, "Accounts");
        JsonNode jsonRecord = accountsNode.findValue("FL");
        return new ZohoOrganizationAdapter(jsonRecord);
    }

    JsonNode findRecordsByType(JsonNode jsonLeadsResponse, String type) {
        if (jsonLeadsResponse.get("response").get("result") == null) {
            return null;
        }
        return jsonLeadsResponse.get("response").get("result").get(type).get("row");
    }

    public Organization toEdmOrganization(ZohoOrganization zohoOrganization) {
        OrganizationImpl org = new OrganizationImpl();
        org.setAbout(URL_ORGANIZATION_PREFFIX + zohoOrganization.getZohoId());
        org.setDcIdentifier(this.getEntityConverterUtils().createMapWithLists(UNDEFINED_LANGUAGE_KEY, zohoOrganization.getZohoId()));
        String isoLanguage = this.toIsoLanguage(zohoOrganization.getLanguageForOrganizationName());
        org.setPrefLabel(this.getEntityConverterUtils().createMapWithLists(isoLanguage, zohoOrganization.getOrganizationName()));
        org.setAltLabel(this.getEntityConverterUtils().createMapWithLists(zohoOrganization.getAlternativeLanguage(), zohoOrganization.getAlternativeOrganizationName()));
        org.setEdmAcronym(this.getEntityConverterUtils().createLanguageMapOfStringList(zohoOrganization.getLangAcronym(), zohoOrganization.getAcronym()));
        org.setFoafLogo(zohoOrganization.getLogo());
        org.setFoafHomepage(zohoOrganization.getWebsite());
        if (zohoOrganization.getRole() != null) {
            String[] role = zohoOrganization.getRole().split(";");
            org.setEdmEuropeanaRole(this.getEntityConverterUtils().createLanguageMapOfStringList(Locale.ENGLISH.getLanguage(), Arrays.asList(role)));
        }
        org.setEdmOrganizationDomain(this.getEntityConverterUtils().createMap(Locale.ENGLISH.getLanguage(), zohoOrganization.getDomain()));
        org.setEdmOrganizationSector(this.getEntityConverterUtils().createMap(Locale.ENGLISH.getLanguage(), zohoOrganization.getSector()));
        org.setEdmOrganizationScope(this.getEntityConverterUtils().createMap(Locale.ENGLISH.getLanguage(), zohoOrganization.getScope()));
        org.setEdmGeorgraphicLevel(this.getEntityConverterUtils().createMap(Locale.ENGLISH.getLanguage(), zohoOrganization.getGeographicLevel()));
        String organizationCountry = this.toEdmCountry(zohoOrganization.getOrganizationCountry());
        org.setEdmCountry(this.getEntityConverterUtils().createMap(Locale.ENGLISH.getLanguage(), organizationCountry));
        if (zohoOrganization.getSameAs() != null && !zohoOrganization.getSameAs().isEmpty()) {
            org.setOwlSameAs(zohoOrganization.getSameAs().toArray(new String[0]));
        }
        AddressImpl address = new AddressImpl();
        address.setAbout(org.getAbout() + "#address");
        address.setVcardStreetAddress(zohoOrganization.getStreet());
        address.setVcardLocality(zohoOrganization.getCity());
        address.setVcardCountryName(zohoOrganization.getCountry());
        address.setVcardPostalCode(zohoOrganization.getZipCode());
        address.setVcardPostOfficeBox(zohoOrganization.getPostBox());
        org.setAddress((Address)address);
        return org;
    }

    String toEdmCountry(String organizationCountry) {
        if (StringUtils.isBlank((CharSequence)organizationCountry)) {
            return null;
        }
        String isoCode = null;
        int commaSeparatorPos = organizationCountry.indexOf(44);
        int bracketSeparatorPos = organizationCountry.indexOf(40);
        if (commaSeparatorPos > 0) {
            isoCode = organizationCountry.substring(commaSeparatorPos + 1).trim();
        } else if (bracketSeparatorPos > 0) {
            isoCode = organizationCountry.substring(0, bracketSeparatorPos).trim();
        }
        return isoCode;
    }

    String toIsoLanguage(String language) {
        if (StringUtils.isBlank((CharSequence)language)) {
            return UNDEFINED_LANGUAGE_KEY;
        }
        return language.substring(0, 2).toLowerCase(Locale.US);
    }

    public List<ZohoOrganization> getOrganizations(int start, int rows, Date lastModified) throws ZohoAccessException {
        return this.getOrganizations(start, rows, lastModified, null);
    }

    public List<ZohoOrganization> getOrganizations(int start, int rows, Date lastModified, Map<String, String> searchCriteria) throws ZohoAccessException {
        JsonNode jsonRecordsResponse;
        if (start < 1) {
            throw new ZohoAccessException("Invalid start index. Index must be >= 1", new IllegalArgumentException("start: " + start));
        }
        String lastModifiedTime = null;
        if (lastModified != null) {
            lastModifiedTime = this.getDateFormatter().format(lastModified);
        }
        try {
            jsonRecordsResponse = searchCriteria == null || searchCriteria.isEmpty() ? this.zohoAccessClientDao.getOrganizations(start, rows, lastModifiedTime) : this.zohoAccessClientDao.searchOrganizations(start, rows, lastModifiedTime, searchCriteria);
        }
        catch (GenericMetisException e) {
            throw new ZohoAccessException("Cannot get organization list from: " + start + " rows :" + rows, e);
        }
        return this.getOrganizationsListFromJsonNode(jsonRecordsResponse);
    }

    public List<String> getDeletedOrganizations(int startPage) throws ZohoAccessException {
        JsonNode jsonRecordsResponse;
        if (startPage < 1) {
            throw new ZohoAccessException("Invalid start page index. Index must be >= 1", new IllegalArgumentException("start page: " + startPage));
        }
        try {
            jsonRecordsResponse = this.zohoV2AccessDao.getDeletedOrganizations(startPage);
        }
        catch (GenericMetisException e) {
            throw new ZohoAccessException("Cannot get deleted organization list from: " + startPage, e);
        }
        List<DeletedZohoOrganizationAdapter> deletedOrganizationsList = this.getDeletedOrganizationsListFromJsonNode(jsonRecordsResponse);
        return this.extractIdsFromDeletedZohoOrganizations(deletedOrganizationsList);
    }

    private List<String> extractIdsFromDeletedZohoOrganizations(List<DeletedZohoOrganizationAdapter> deletedOrganizationsList) {
        ArrayList<String> idList = new ArrayList<String>(deletedOrganizationsList.size());
        for (DeletedZohoOrganizationAdapter deletedOrganization : deletedOrganizationsList) {
            idList.add(URL_ORGANIZATION_PREFFIX + deletedOrganization.getZohoId());
        }
        return idList;
    }

    protected List<ZohoOrganization> getOrganizationsListFromJsonNode(JsonNode jsonRecordsResponse) throws ZohoAccessException {
        boolean oneResult;
        JsonNode accountsNode = this.findRecordsByType(jsonRecordsResponse, "Accounts");
        ArrayList<ZohoOrganization> res = new ArrayList<ZohoOrganization>();
        if (accountsNode == null) {
            return res;
        }
        boolean bl = oneResult = accountsNode.get(0) == null;
        if (oneResult) {
            this.addAccountToOrgList(accountsNode, res);
            return res;
        }
        for (JsonNode accountNode : accountsNode) {
            this.addAccountToOrgList(accountNode, res);
        }
        return res;
    }

    protected List<DeletedZohoOrganizationAdapter> getDeletedOrganizationsListFromJsonNode(JsonNode jsonRecordsResponse) {
        boolean oneResult;
        JsonNode accountsNode = jsonRecordsResponse.get("data");
        ArrayList<DeletedZohoOrganizationAdapter> organizationList = new ArrayList<DeletedZohoOrganizationAdapter>();
        if (accountsNode == null) {
            return organizationList;
        }
        boolean bl = oneResult = accountsNode.get(0) == null;
        if (oneResult) {
            organizationList.add(new DeletedZohoOrganizationAdapter(accountsNode));
            return organizationList;
        }
        organizationList = new ArrayList(accountsNode.size());
        for (JsonNode accountNode : accountsNode) {
            organizationList.add(new DeletedZohoOrganizationAdapter(accountNode));
        }
        return organizationList;
    }

    private void addAccountToOrgList(JsonNode accountNode, List<ZohoOrganization> res) throws ZohoAccessException {
        JsonNode organizationNode = accountNode.get("FL");
        ZohoOrganizationAdapter zoa = new ZohoOrganizationAdapter(organizationNode);
        res.add(zoa);
    }

    Map<String, List<String>> createMapOfStringList(String key, String value) {
        if (value == null) {
            return null;
        }
        return this.createMapOfStringList(key, this.createList(value));
    }

    Map<String, String> createMap(String key, String value) {
        if (value == null) {
            return null;
        }
        return Collections.singletonMap(key, value);
    }

    List<String> createList(String value) {
        if (value == null) {
            return null;
        }
        return Collections.singletonList(value);
    }

    Map<String, List<String>> createMapOfStringList(String key, List<String> value) {
        return Collections.singletonMap(key, value);
    }

    Map<String, List<String>> createLanguageMapOfStringList(List<String> languages, List<String> values) {
        if (languages == null) {
            return null;
        }
        HashMap<String, List<String>> resMap = new HashMap<String, List<String>>(languages.size());
        for (int i = 0; i < languages.size(); ++i) {
            resMap.put(this.toIsoLanguage(languages.get(i)), this.createList(values.get(i)));
        }
        return resMap;
    }

    Map<String, List<String>> createLanguageMapOfStringList(String language, String value) {
        if (value == null) {
            return null;
        }
        return Collections.singletonMap(this.toIsoLanguage(language), this.createList(value));
    }

    Map<String, List<String>> createLanguageMapOfStringList(String language, List<String> value) {
        if (value == null) {
            return null;
        }
        return Collections.singletonMap(this.toIsoLanguage(language), value);
    }

    public FastDateFormat getDateFormatter() {
        return ZohoApiFields.getZohoTimeFormatter();
    }

    public EntityConverterUtils getEntityConverterUtils() {
        return this.entityConverterUtils;
    }
}

