/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.service.dao;

import eu.europeana.enrichment.api.external.model.WikidataOrganization;
import eu.europeana.enrichment.service.exception.WikidataAccessException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.input.CharSequenceReader;
import org.apache.commons.io.output.StringBuilderWriter;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFWriter;
import org.apache.jena.sparql.engine.http.QueryEngineHTTP;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WikidataAccessDao {
    public static final String WIKIDATA_ORGANIZATION_XSL_FILE = "/wkd2org.xsl";
    private static final String SPARQL = "https://query.wikidata.org/sparql";
    private static final int SIZE = 0x100000;
    private static final Logger LOGGER = LoggerFactory.getLogger(WikidataAccessDao.class);
    private Transformer transformer;

    private WikidataAccessDao(InputStreamCreator inputStreamSupplier) throws WikidataAccessException {
        try (InputStream inputStream = inputStreamSupplier.create();){
            this.init(inputStream);
        }
        catch (IOException e) {
            throw new WikidataAccessException("Unexpected exception while reading the wikidata XSLT file.", e);
        }
    }

    public WikidataAccessDao(File templateFile) throws WikidataAccessException {
        this(() -> Files.newInputStream(templateFile.toPath(), new OpenOption[0]));
    }

    public WikidataAccessDao(InputStream xslTemplate) throws WikidataAccessException {
        this(() -> xslTemplate);
    }

    public WikidataAccessDao() throws WikidataAccessException {
        this(() -> WikidataAccessDao.class.getResourceAsStream(WIKIDATA_ORGANIZATION_XSL_FILE));
    }

    public final void init(InputStream xslTemplate) throws WikidataAccessException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            StreamSource xslt = new StreamSource(xslTemplate);
            this.transformer = transformerFactory.newTransformer(xslt);
            this.transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        }
        catch (TransformerConfigurationException e) {
            throw new WikidataAccessException("Transformer could not be initialized.", e);
        }
    }

    public StringBuilder getEntity(String uri) throws WikidataAccessException, IOException {
        StringBuilder res = new StringBuilder();
        StreamResult wikidataRes = new StreamResult((Writer)new StringBuilderWriter(res));
        this.translate(uri, wikidataRes);
        return res;
    }

    public WikidataOrganization parse(File xmlFile) throws JAXBException, IOException {
        String xml = FileUtils.readFileToString((File)xmlFile, (String)"UTF-8");
        return this.parse(xml);
    }

    public WikidataOrganization parse(String xml) throws JAXBException, IOException {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{WikidataOrganization.class});
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        ByteArrayInputStream stream = new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8));
        return (WikidataOrganization)unmarshaller.unmarshal((InputStream)stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Model getModelFromSPARQL(String uri) {
        String sDescribe = "DESCRIBE <" + uri + ">";
        Model m = ModelFactory.createDefaultModel();
        try (QueryEngineHTTP endpoint = new QueryEngineHTTP(SPARQL, sDescribe);){
            Model model = endpoint.execDescribe(m);
            return model;
        }
        return m;
    }

    private synchronized void transform(Model m, Transformer t, StreamResult res) throws WikidataAccessException {
        StringBuilder sb = new StringBuilder(0x100000);
        try (StringBuilderWriter sbw = new StringBuilderWriter(sb);){
            RDFWriter writer = m.getWriter("RDF/XML");
            writer.setProperty("tab", (Object)"0");
            writer.setProperty("allowBadURIs", (Object)"true");
            writer.setProperty("relativeURIs", (Object)"");
            writer.write(m, (Writer)sbw, "RDF/XML");
            t.transform(new StreamSource((Reader)new CharSequenceReader((CharSequence)sb)), res);
            sb.setLength(0);
        }
        catch (TransformerException e) {
            throw new WikidataAccessException("Error by transforming of Wikidata in RDF/XML.", e);
        }
    }

    public WikidataOrganization parseWikidataOrganization(File inputFile) throws IOException, JAXBException {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{WikidataOrganization.class});
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        WikidataOrganization result = (WikidataOrganization)unmarshaller.unmarshal(inputFile);
        return result;
    }

    public void translate(String uri, StreamResult res) throws WikidataAccessException {
        this.transformer.setParameter("rdf_about", uri);
        this.transformer.setParameter("deref", Boolean.TRUE);
        this.transformer.setParameter("address", Boolean.FALSE);
        this.transform(this.getModelFromSPARQL(uri), this.transformer, res);
    }

    @FunctionalInterface
    private static interface InputStreamCreator {
        public InputStream create() throws IOException;
    }
}

