/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.service;

import eu.europeana.corelib.solr.entity.AgentImpl;
import eu.europeana.corelib.solr.entity.ConceptImpl;
import eu.europeana.corelib.solr.entity.PlaceImpl;
import eu.europeana.corelib.solr.entity.TimespanImpl;
import eu.europeana.enrichment.api.external.EntityWrapper;
import eu.europeana.enrichment.api.external.model.Agent;
import eu.europeana.enrichment.api.external.model.Concept;
import eu.europeana.enrichment.api.external.model.EnrichmentBase;
import eu.europeana.enrichment.api.external.model.EnrichmentResultList;
import eu.europeana.enrichment.api.external.model.Label;
import eu.europeana.enrichment.api.external.model.LabelResource;
import eu.europeana.enrichment.api.external.model.Part;
import eu.europeana.enrichment.api.external.model.Place;
import eu.europeana.enrichment.api.external.model.Resource;
import eu.europeana.enrichment.api.external.model.Timespan;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.stereotype.Service;

@Service
public class Converter {
    public EnrichmentResultList convert(List<EntityWrapper> wrapperList) throws IOException {
        EnrichmentResultList list = new EnrichmentResultList();
        for (EntityWrapper wrapper : wrapperList) {
            list.getResult().add(this.convert(wrapper));
        }
        return list;
    }

    public EnrichmentBase convert(EntityWrapper wrapper) throws IOException {
        Agent result;
        switch (wrapper.getEntityClass()) {
            case AGENT: {
                result = this.convertAgent(wrapper.getContextualEntity());
                break;
            }
            case CONCEPT: {
                result = this.convertConcept(wrapper.getContextualEntity());
                break;
            }
            case PLACE: {
                result = this.convertPlace(wrapper.getContextualEntity());
                break;
            }
            case TIMESPAN: {
                result = this.convertTimespan(wrapper.getContextualEntity());
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    private Timespan convertTimespan(String contextualEntity) throws IOException {
        TimespanImpl ts = (TimespanImpl)new ObjectMapper().readValue(contextualEntity, TimespanImpl.class);
        Timespan output = new Timespan();
        output.setAbout(ts.getAbout());
        output.setPrefLabelList(this.convert(ts.getPrefLabel()));
        output.setAltLabelList(this.convert(ts.getAltLabel()));
        output.setBeginList(this.convert(ts.getBegin()));
        output.setEndList(this.convert(ts.getEnd()));
        output.setHasPartsList(this.convertPart(ts.getDctermsHasPart()));
        output.setHiddenLabel(this.convert(ts.getHiddenLabel()));
        output.setIsPartOfList(this.convertPart(ts.getIsPartOf()));
        output.setNotes(this.convert(ts.getNote()));
        output.setSameAs(this.convertToPartsList(ts.getOwlSameAs()));
        return output;
    }

    private Concept convertConcept(String contextualEntity) throws IOException {
        ConceptImpl concept = (ConceptImpl)new ObjectMapper().readValue(contextualEntity, ConceptImpl.class);
        Concept output = new Concept();
        output.setAbout(concept.getAbout());
        output.setPrefLabelList(this.convert(concept.getPrefLabel()));
        output.setAltLabelList(this.convert(concept.getAltLabel()));
        output.setHiddenLabel(this.convert(concept.getHiddenLabel()));
        output.setNotation(this.convert(concept.getNotation()));
        output.setNotes(this.convert(concept.getNote()));
        output.setBroader(this.convertToResourceList(concept.getBroader()));
        output.setBroadMatch(this.convertToResourceList(concept.getBroadMatch()));
        output.setCloseMatch(this.convertToResourceList(concept.getCloseMatch()));
        output.setExactMatch(this.convertToResourceList(concept.getExactMatch()));
        output.setInScheme(this.convertToResourceList(concept.getInScheme()));
        output.setNarrower(this.convertToResourceList(concept.getNarrower()));
        output.setNarrowMatch(this.convertToResourceList(concept.getNarrowMatch()));
        output.setRelated(this.convertToResourceList(concept.getRelated()));
        output.setRelatedMatch(this.convertToResourceList(concept.getRelatedMatch()));
        return output;
    }

    private Place convertPlace(String contextualEntity) throws IOException {
        PlaceImpl place = (PlaceImpl)new ObjectMapper().readValue(contextualEntity, PlaceImpl.class);
        Place output = new Place();
        output.setAbout(place.getAbout());
        output.setPrefLabelList(this.convert(place.getPrefLabel()));
        output.setAltLabelList(this.convert(place.getAltLabel()));
        output.setHasPartsList(this.convertPart(place.getDcTermsHasPart()));
        output.setIsPartOfList(this.convertPart(place.getIsPartOf()));
        output.setNotes(this.convert(place.getNote()));
        output.setSameAs(this.convertToPartsList(place.getOwlSameAs()));
        if (place.getLatitude() != null && place.getLatitude().floatValue() != 0.0f && place.getLongitude() != null && place.getLongitude().floatValue() != 0.0f) {
            output.setLat(place.getLatitude().toString());
            output.setLon(place.getLongitude().toString());
        }
        if (place.getAltitude() != null && place.getAltitude().floatValue() != 0.0f) {
            output.setAlt(place.getAltitude().toString());
        }
        return output;
    }

    private Agent convertAgent(String contextualEntity) throws IOException {
        AgentImpl agent = (AgentImpl)new ObjectMapper().readValue(contextualEntity, AgentImpl.class);
        Agent output = new Agent();
        output.setAbout(agent.getAbout());
        output.setPrefLabelList(this.convert(agent.getPrefLabel()));
        output.setAltLabelList(this.convert(agent.getAltLabel()));
        output.setHiddenLabel(this.convert(agent.getHiddenLabel()));
        output.setFoafName(this.convert(agent.getFoafName()));
        output.setNotes(this.convert(agent.getNote()));
        output.setBeginList(this.convert(agent.getBegin()));
        output.setEndList(this.convert(agent.getEnd()));
        output.setIdentifier(this.convert(agent.getDcIdentifier()));
        output.setHasMet(this.convert(agent.getEdmHasMet()));
        output.setBiographicaInformation(this.convert(agent.getRdaGr2BiographicalInformation()));
        output.setDateOfBirth(this.convert(agent.getRdaGr2DateOfBirth()));
        output.setDateOfDeath(this.convert(agent.getRdaGr2DateOfDeath()));
        output.setDateOfEstablishment(this.convert(agent.getRdaGr2DateOfEstablishment()));
        output.setDateOfTermination(this.convert(agent.getRdaGr2DateOfTermination()));
        output.setGender(this.convert(agent.getRdaGr2Gender()));
        output.setDate(this.convertResourceOrLiteral(agent.getDcDate()));
        output.setProfessionOrOccupation(this.convertResourceOrLiteral(agent.getRdaGr2ProfessionOrOccupation()));
        output.setWasPresentAt(this.convertToResourceList(agent.getEdmWasPresentAt()));
        output.setSameAs(this.convertToPartsList(agent.getOwlSameAs()));
        return output;
    }

    private List<Label> convert(Map<String, List<String>> map) {
        ArrayList<Label> labels = new ArrayList<Label>();
        if (map == null) {
            return labels;
        }
        map.forEach((key, entry) -> entry.stream().map(value -> new Label(key, value)).forEach(labels::add));
        return labels;
    }

    private List<Part> convertPart(Map<String, List<String>> map) {
        ArrayList<Part> parts = new ArrayList<Part>();
        if (map == null) {
            return parts;
        }
        map.forEach((key, entry) -> entry.stream().map(value -> new Part(key)).forEach(parts::add));
        return parts;
    }

    private List<LabelResource> convertResourceOrLiteral(Map<String, List<String>> map) {
        ArrayList<LabelResource> parts = new ArrayList<LabelResource>();
        if (map == null) {
            return parts;
        }
        map.forEach((key, entry) -> entry.stream().map(value -> this.isUri((String)key) ? new LabelResource(key) : new LabelResource(key, value)).forEach(parts::add));
        return parts;
    }

    private List<Resource> convertToResourceList(String[] resources) {
        if (resources == null) {
            return new ArrayList<Resource>();
        }
        return Arrays.stream(resources).map(Resource::new).collect(Collectors.toList());
    }

    private List<Part> convertToPartsList(String[] resources) {
        if (resources == null) {
            return new ArrayList<Part>();
        }
        return Arrays.stream(resources).map(Part::new).collect(Collectors.toList());
    }

    private boolean isUri(String str) {
        return str.startsWith("http://");
    }
}

