/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.rest;

import eu.europeana.enrichment.api.external.EnrichmentReference;
import eu.europeana.enrichment.api.external.EnrichmentSearch;
import eu.europeana.enrichment.api.external.ReferenceValue;
import eu.europeana.enrichment.api.external.model.EnrichmentBase;
import eu.europeana.enrichment.api.external.model.EnrichmentResultBaseWrapper;
import eu.europeana.enrichment.api.external.model.EnrichmentResultList;
import eu.europeana.enrichment.service.EnrichmentService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="/")
@Controller
public class EnrichmentController {
    private final EnrichmentService enrichmentService;

    @Autowired
    public EnrichmentController(EnrichmentService enrichmentService) {
        this.enrichmentService = enrichmentService;
    }

    @PostMapping(value={"/enrich/entity/search"}, consumes={"application/json", "application/xml"}, produces={"application/json", "application/xml"})
    @ResponseBody
    @ApiOperation(value="Get an enrichment by providing a list of SearchValue", response=EnrichmentResultList.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Error processing the result")})
    public EnrichmentResultList search(@ApiParam(value="SearchTerms") @RequestBody EnrichmentSearch enrichmentSearch) {
        return new EnrichmentResultList(this.enrichmentService.enrichByEnrichmentSearchValues(enrichmentSearch.getSearchValues()));
    }

    @GetMapping(value={"/enrich/entity/equivalence"}, produces={"application/json", "application/xml"})
    @ApiOperation(value="Get an enrichment providing a URI that matches an entity about or owlSameAs", response=EnrichmentBase.class)
    @ResponseBody
    @ApiResponses(value={@ApiResponse(code=400, message="Error processing the result")})
    public EnrichmentBase equivalence(@ApiParam(value="uri") @RequestParam(value="uri") String uri) {
        List result = this.enrichmentService.enrichByEquivalenceValues(new ReferenceValue(uri, Collections.emptySet()));
        return result.stream().findFirst().orElse(null);
    }

    @PostMapping(value={"/enrich/entity/equivalence"}, consumes={"application/json", "application/xml"}, produces={"application/json", "application/xml"})
    @ApiOperation(value="Get an enrichment providing a EnrichmentReference where each reference could match an entity's about or owlSameAs", response=EnrichmentResultList.class)
    @ResponseBody
    @ApiResponses(value={@ApiResponse(code=400, message="Error processing the result")})
    public EnrichmentResultList equivalence(@RequestBody EnrichmentReference enrichmentReference) {
        List enrichmentBaseWrappers = enrichmentReference.getReferenceValues().stream().map(arg_0 -> ((EnrichmentService)this.enrichmentService).enrichByEquivalenceValues(arg_0)).map(EnrichmentResultBaseWrapper::new).collect(Collectors.toList());
        return new EnrichmentResultList(enrichmentBaseWrappers);
    }

    @PostMapping(value={"/enrich/entity/id"}, consumes={"application/json"}, produces={"application/json", "application/xml"})
    @ApiOperation(value="Get an enrichment providing a list of URIs where each of them could match an entity's about", response=EnrichmentResultList.class)
    @ResponseBody
    @ApiResponses(value={@ApiResponse(code=400, message="Error processing the result")})
    public EnrichmentResultList entityId(@RequestBody List<String> uris) {
        List enrichmentBaseWrappers = uris.stream().map(arg_0 -> ((EnrichmentService)this.enrichmentService).enrichById(arg_0)).map(result -> Optional.ofNullable(result).map(List::of).orElseGet(Collections::emptyList)).map(EnrichmentResultBaseWrapper::new).collect(Collectors.toList());
        return new EnrichmentResultList(enrichmentBaseWrappers);
    }
}

