/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.rest.config;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationModule;
import eu.europeana.corelib.web.socks.SocksProxy;
import eu.europeana.enrichment.service.Converter;
import eu.europeana.enrichment.service.Enricher;
import eu.europeana.enrichment.service.RedisInternalEnricher;
import eu.europeana.enrichment.utils.EnrichmentEntityDao;
import eu.europeana.enrichment.utils.RedisProvider;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@ComponentScan(basePackages={"eu.europeana.enrichment.rest", "eu.europeana.enrichment.rest.exception"})
@PropertySource(value={"classpath:enrichment.properties"})
@EnableWebMvc
@EnableSwagger2
public class Application
implements WebMvcConfigurer,
InitializingBean {
    @Value(value="${socks.proxy.enabled}")
    private boolean socksProxyEnabled;
    @Value(value="${socks.proxy.host}")
    private String socksProxyHost;
    @Value(value="${socks.proxy.port}")
    private String socksProxyPort;
    @Value(value="${socks.proxy.username}")
    private String socksProxyUsername;
    @Value(value="${socks.proxy.password}")
    private String socksProxyPassword;
    @Value(value="${redis.host}")
    private String redisHost;
    @Value(value="${redis.port}")
    private int redisPort;
    @Value(value="${redis.password}")
    private String redisPassword;
    @Value(value="${enrichment.mongoDb}")
    private String enrichmentMongo;
    @Value(value="${enrichment.mongoPort:27017}")
    private int enrichmentMongoPort;
    @Value(value="${enrichment.proxy.url}")
    private String enrichmentProxyUrl;
    private RedisProvider redisProvider;

    public void afterPropertiesSet() {
        if (this.socksProxyEnabled) {
            new SocksProxy(this.socksProxyHost, this.socksProxyPort, this.socksProxyUsername, this.socksProxyPassword).init();
        }
        if (this.redisProvider == null) {
            this.redisProvider = new RedisProvider(this.redisHost, this.redisPort, this.redisPassword);
        }
    }

    public void addViewControllers(ViewControllerRegistry registry) {
        registry.addRedirectViewController("/", "swagger-ui.html");
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"swagger-ui.html"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/"});
        registry.addResourceHandler(new String[]{"/webjars/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/webjars/"});
    }

    @Bean
    @DependsOn(value={"redisInternalEnricher"})
    Enricher enricher() {
        return new Enricher(this.getRedisInternalEnricher());
    }

    @Bean
    EnrichmentEntityDao getEntityDao() {
        return new EnrichmentEntityDao(this.enrichmentMongo, this.enrichmentMongoPort);
    }

    @Bean
    Converter converter() {
        return new Converter();
    }

    @Bean
    RedisProvider getRedisProvider() {
        return this.redisProvider;
    }

    @Bean(name={"redisInternalEnricher"})
    RedisInternalEnricher getRedisInternalEnricher() {
        return new RedisInternalEnricher(this.getEntityDao(), this.getRedisProvider());
    }

    @Bean
    public Jackson2ObjectMapperBuilder objectMapperBuilder() {
        Jackson2ObjectMapperBuilder builder = new Jackson2ObjectMapperBuilder();
        JaxbAnnotationModule module = new JaxbAnnotationModule();
        builder.modules(new Module[]{module});
        return builder;
    }

    @Bean
    public static PropertySourcesPlaceholderConfigurer propertySourcesPlaceholderConfigurer() {
        return new PropertySourcesPlaceholderConfigurer();
    }

    @Bean
    public Docket api() {
        return new Docket(DocumentationType.SWAGGER_2).useDefaultResponseMessages(false).select().apis(RequestHandlerSelectors.any()).paths(PathSelectors.regex((String)"/.*")).build().apiInfo(this.apiInfo());
    }

    private ApiInfo apiInfo() {
        Contact contact = new Contact("Europeana", "http:\\www.europeana.eu", "development@europeana.eu");
        return new ApiInfo("Enrichment REST API", "Enrichment REST API for Europeana", "v1", "API TOS", contact, "EUPL Licence v1.1", "");
    }
}

