/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.rest;

import eu.europeana.enrichment.api.external.EntityWrapper;
import eu.europeana.enrichment.api.external.InputValueList;
import eu.europeana.enrichment.api.external.model.EnrichmentBase;
import eu.europeana.enrichment.api.external.model.EnrichmentResultList;
import eu.europeana.enrichment.rest.exception.EnrichmentException;
import eu.europeana.enrichment.service.Converter;
import eu.europeana.enrichment.service.Enricher;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="/")
@Controller
public class EnrichmentController {
    private final Converter converter;
    private final Enricher enricher;

    @Autowired
    public EnrichmentController(Enricher enricher, Converter converter) {
        this.converter = converter;
        this.enricher = enricher;
    }

    @GetMapping(value={"/getByUri"}, produces={"application/json", "application/xml"})
    @ApiOperation(value="Retrieve an entity by rdf:about or owl:sameAs/skos:exactMatch", response=EnrichmentBase.class)
    @ResponseBody
    @ApiResponses(value={@ApiResponse(code=400, message="Error processing the result")})
    public EnrichmentBase getByUri(@ApiParam(value="uri") @RequestParam(value="uri") String uri) throws EnrichmentException {
        EntityWrapper wrapper = this.enricher.getByUri(uri);
        if (wrapper == null) {
            return null;
        }
        try {
            return this.converter.convert(wrapper);
        }
        catch (IOException e) {
            throw new EnrichmentException("Error converting object to EnrichmentBase", (Throwable)e);
        }
    }

    @PostMapping(value={"/getByUri"}, consumes={"application/json"}, produces={"application/json", "application/xml"})
    @ApiOperation(value="Retrieve entities by rdf:about or owl:sameAs/skos:exactMatch", response=EnrichmentResultList.class)
    @ResponseBody
    @ApiResponses(value={@ApiResponse(code=400, message="Error processing the result")})
    public EnrichmentResultList getByUri(@RequestBody List<String> uriList) throws EnrichmentException {
        List wrapperList = uriList.stream().map(arg_0 -> ((Enricher)this.enricher).getByUri(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        try {
            return this.converter.convert(wrapperList);
        }
        catch (IOException e) {
            throw new EnrichmentException("Error converting object to EnrichmentBase", (Throwable)e);
        }
    }

    @PostMapping(value={"/getById"}, consumes={"application/json"}, produces={"application/json", "application/xml"})
    @ApiOperation(value="Retrieve entities by rdf:about", response=EnrichmentResultList.class)
    @ResponseBody
    @ApiResponses(value={@ApiResponse(code=400, message="Error processing the result")})
    public EnrichmentResultList getById(@RequestBody List<String> idList) throws EnrichmentException {
        List wrapperList = idList.stream().map(arg_0 -> ((Enricher)this.enricher).getById(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        try {
            return this.converter.convert(wrapperList);
        }
        catch (IOException e) {
            throw new EnrichmentException("Error converting object to EnrichmentBase", (Throwable)e);
        }
    }

    @PostMapping(value={"/enrich"}, consumes={"application/json", "application/xml"}, produces={"application/json", "application/xml"})
    @ResponseBody
    @ApiOperation(value="Enrich a series of field value pairs", response=EnrichmentResultList.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Error processing the result")})
    public EnrichmentResultList enrich(@ApiParam(value="input") @RequestBody InputValueList input) throws EnrichmentException {
        try {
            List wrapperList = this.enricher.tagExternal(input.getInputValues());
            return this.converter.convert(wrapperList);
        }
        catch (IOException e) {
            throw new EnrichmentException("Error converting object.", (Throwable)e);
        }
    }
}

