/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.rest;

import eu.europeana.enrichment.api.external.EntityWrapper;
import eu.europeana.enrichment.api.external.InputValueList;
import eu.europeana.enrichment.api.external.UriList;
import eu.europeana.enrichment.api.external.model.EnrichmentBase;
import eu.europeana.enrichment.api.external.model.EnrichmentResultList;
import eu.europeana.enrichment.rest.exception.EnrichmentException;
import eu.europeana.enrichment.service.Converter;
import eu.europeana.enrichment.service.Enricher;
import eu.europeana.enrichment.service.EntityRemover;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Api(value="/")
@Controller
public class EnrichmentController {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnrichmentController.class);
    private final Converter converter;
    private final Enricher enricher;
    private final EntityRemover remover;

    @Autowired
    public EnrichmentController(Enricher enricher, EntityRemover remover, Converter converter) {
        this.converter = converter;
        this.enricher = enricher;
        this.remover = remover;
    }

    @ResponseStatus(value=HttpStatus.OK)
    @RequestMapping(value={"/delete"}, method={RequestMethod.DELETE})
    @ApiOperation(value="Delete a list of URIs")
    @ApiResponses(value={@ApiResponse(code=400, message="Error processing the result")})
    public void delete(@RequestBody UriList values) {
        this.remover.remove(values.getUris());
    }

    @RequestMapping(value={"/getByUri"}, method={RequestMethod.GET}, produces={"application/json", "application/xml"})
    @ApiOperation(value="Retrieve an entity by URI or its sameAs", response=EnrichmentBase.class)
    @ResponseBody
    @ApiResponses(value={@ApiResponse(code=400, message="Error processing the result")})
    public EnrichmentBase getByUri(@ApiParam(value="uri") @RequestParam(value="uri") String uri) throws EnrichmentException {
        EntityWrapper wrapper = this.enricher.getByUri(uri);
        if (wrapper == null) {
            return null;
        }
        try {
            return this.converter.convert(wrapper);
        }
        catch (IOException e) {
            LOGGER.error("Error converting object to EnrichmentBase", (Throwable)e);
            throw new EnrichmentException("Error converting object to EnrichmentBase", (Throwable)e);
        }
    }

    @RequestMapping(value={"/enrich"}, method={RequestMethod.POST}, consumes={"application/json", "application/xml"}, produces={"application/json", "application/xml"})
    @ResponseBody
    @ApiOperation(value="Enrich a series of field value pairs", response=EnrichmentResultList.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Error processing the result")})
    public EnrichmentResultList enrich(@ApiParam(value="input") @RequestBody InputValueList input) throws EnrichmentException {
        try {
            List wrapperList = this.enricher.tagExternal(input.getInputValues());
            return this.converter.convert(wrapperList);
        }
        catch (IOException e) {
            LOGGER.error("Error converting object.", (Throwable)e);
            throw new EnrichmentException("Error converting object.", (Throwable)e);
        }
    }
}

