/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.rest.client;

import eu.europeana.enrichment.rest.client.EnrichmentWorker;
import eu.europeana.enrichment.rest.client.dereference.Dereferencer;
import eu.europeana.enrichment.rest.client.enrichment.Enricher;
import eu.europeana.enrichment.rest.client.exceptions.DereferenceException;
import eu.europeana.enrichment.rest.client.exceptions.EnrichmentException;
import eu.europeana.metis.schema.convert.RdfConversionUtils;
import eu.europeana.metis.schema.convert.SerializationException;
import eu.europeana.metis.schema.jibx.RDF;
import java.io.InputStream;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnrichmentWorkerImpl
implements EnrichmentWorker {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnrichmentWorkerImpl.class);
    private final Enricher enricher;
    private final Dereferencer dereferencer;
    private final Set<EnrichmentWorker.Mode> supportedModes;

    public EnrichmentWorkerImpl(Dereferencer dereferencer, Enricher enricher) {
        this.enricher = enricher;
        this.dereferencer = dereferencer;
        this.supportedModes = EnumSet.noneOf(EnrichmentWorker.Mode.class);
        if (dereferencer != null) {
            this.supportedModes.add(EnrichmentWorker.Mode.DEREFERENCE);
        }
        if (enricher != null) {
            this.supportedModes.add(EnrichmentWorker.Mode.ENRICHMENT);
        }
    }

    @Override
    public Set<EnrichmentWorker.Mode> getSupportedModes() {
        return Collections.unmodifiableSet(this.supportedModes);
    }

    @Override
    public byte[] process(InputStream inputStream) throws EnrichmentException, DereferenceException, SerializationException {
        return this.process(inputStream, EnumSet.allOf(EnrichmentWorker.Mode.class));
    }

    @Override
    public byte[] process(InputStream inputStream, Set<EnrichmentWorker.Mode> modes) throws SerializationException, EnrichmentException, DereferenceException {
        if (inputStream == null) {
            throw new IllegalArgumentException("The input stream cannot be null.");
        }
        try {
            RDF inputRdf = this.convertInputStreamToRdf(inputStream);
            RDF resultRdf = this.process(inputRdf, modes);
            return this.convertRdfToBytes(resultRdf);
        }
        catch (EnrichmentException e) {
            throw new EnrichmentException("Something went wrong with the enrichment from the RDF file.", e);
        }
        catch (DereferenceException e) {
            throw new DereferenceException("Something went wrong with the dereference from the RDF file.", e);
        }
    }

    @Override
    public String process(String inputString) throws EnrichmentException, DereferenceException, SerializationException {
        return this.process(inputString, EnumSet.allOf(EnrichmentWorker.Mode.class));
    }

    @Override
    public String process(String inputString, Set<EnrichmentWorker.Mode> modes) throws SerializationException, EnrichmentException, DereferenceException {
        if (inputString == null) {
            throw new IllegalArgumentException("Input RDF string cannot be null.");
        }
        try {
            RDF inputRdf = this.convertStringToRdf(inputString);
            RDF resultRdf = this.process(inputRdf, modes);
            return this.convertRdfToString(resultRdf);
        }
        catch (EnrichmentException e) {
            throw new EnrichmentException("Something went wrong with the enrichment from the RDF file.", e);
        }
        catch (DereferenceException e) {
            throw new DereferenceException("Something went wrong with the dereference from the RDF file.", e);
        }
    }

    @Override
    public RDF process(RDF inputRdf) throws EnrichmentException, DereferenceException {
        return this.process(inputRdf, EnumSet.allOf(EnrichmentWorker.Mode.class));
    }

    @Override
    public RDF process(RDF rdf, Set<EnrichmentWorker.Mode> modes) throws EnrichmentException, DereferenceException {
        if (rdf == null) {
            throw new IllegalArgumentException("Input RDF cannot be null.");
        }
        if (modes == null) {
            throw new IllegalArgumentException("Set of Modes cannot be null.");
        }
        if (!this.getSupportedModes().containsAll(modes)) {
            throw new IllegalArgumentException("The requested mode(s) is not supported by this instance.");
        }
        LOGGER.info("Received RDF for enrichment/dereferencing. Mode: {}", modes);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Processing RDF:\n{}", (Object)this.convertRdfToStringForLogging(rdf));
        }
        if (modes.contains((Object)EnrichmentWorker.Mode.DEREFERENCE)) {
            LOGGER.debug("Performing dereferencing...");
            this.dereferencer.dereference(rdf);
            LOGGER.debug("Dereferencing completed.");
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("RDF after dereferencing:\n{}", (Object)this.convertRdfToStringForLogging(rdf));
            }
        }
        if (modes.contains((Object)EnrichmentWorker.Mode.ENRICHMENT)) {
            LOGGER.debug("Performing enrichment...");
            this.enricher.enrichment(rdf);
            LOGGER.debug("Enrichment completed.");
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("RDF after enrichment:\n{}", (Object)this.convertRdfToStringForLogging(rdf));
            }
        }
        LOGGER.debug("Processing complete.");
        return rdf;
    }

    @Override
    public void cleanupPreviousEnrichmentEntities(RDF rdf) {
        this.enricher.cleanupPreviousEnrichmentEntities(rdf);
    }

    private String convertRdfToStringForLogging(RDF rdf) {
        try {
            return this.convertRdfToString(rdf);
        }
        catch (SerializationException e) {
            LOGGER.warn("Exception occurred while rendering an RDF document as a String.", (Throwable)e);
            return "[COULD NOT RENDER RDF]";
        }
    }

    String convertRdfToString(RDF rdf) throws SerializationException {
        return RdfConversionUtils.convertRdfToString((RDF)rdf);
    }

    byte[] convertRdfToBytes(RDF rdf) throws SerializationException {
        return RdfConversionUtils.convertRdfToBytes((RDF)rdf);
    }

    RDF convertStringToRdf(String xml) throws SerializationException {
        return RdfConversionUtils.convertStringToRdf((String)xml);
    }

    RDF convertInputStreamToRdf(InputStream xml) throws SerializationException {
        return RdfConversionUtils.convertInputStreamToRdf((InputStream)xml);
    }
}

