/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.rest.client.dereference;

import eu.europeana.enrichment.api.external.model.EnrichmentBase;
import eu.europeana.enrichment.api.external.model.EnrichmentResultBaseWrapper;
import eu.europeana.enrichment.api.external.model.EnrichmentResultList;
import eu.europeana.enrichment.api.internal.EntityResolver;
import eu.europeana.enrichment.api.internal.ReferenceTerm;
import eu.europeana.enrichment.api.internal.ReferenceTermImpl;
import eu.europeana.enrichment.rest.client.dereference.DereferenceClient;
import eu.europeana.enrichment.rest.client.dereference.Dereferencer;
import eu.europeana.enrichment.rest.client.exceptions.DereferenceException;
import eu.europeana.enrichment.utils.DereferenceUtils;
import eu.europeana.enrichment.utils.EntityMergeEngine;
import eu.europeana.metis.network.ExternalRequestUtil;
import eu.europeana.metis.schema.jibx.RDF;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.client.HttpClientErrorException;

public class DereferencerImpl
implements Dereferencer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DereferencerImpl.class);
    private final EntityMergeEngine entityMergeEngine;
    private final EntityResolver remoteEntityResolver;
    private final DereferenceClient dereferenceClient;

    public DereferencerImpl(EntityMergeEngine entityMergeEngine, EntityResolver remoteEntityResolver, DereferenceClient dereferenceClient) {
        this.entityMergeEngine = entityMergeEngine;
        this.remoteEntityResolver = remoteEntityResolver;
        this.dereferenceClient = dereferenceClient;
    }

    @Override
    public void dereference(RDF rdf) throws DereferenceException {
        LOGGER.debug(" Extracting fields from RDF for dereferencing...");
        Set<String> resourceIds = this.extractReferencesForDereferencing(rdf);
        LOGGER.debug("Using extracted fields to gather enrichment-via-dereferencing information...");
        List<EnrichmentBase> dereferenceInformation = this.dereferenceEntities(resourceIds);
        LOGGER.debug("Merging Dereference Information...");
        this.entityMergeEngine.mergeReferenceEntities(rdf, dereferenceInformation);
        LOGGER.debug("Dereference completed.");
    }

    @Override
    public List<EnrichmentBase> dereferenceEntities(Set<String> resourceIds) throws DereferenceException {
        if (resourceIds.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<ReferenceTerm> referenceTermSet = new HashSet<ReferenceTerm>(resourceIds.size());
        for (String id : resourceIds) {
            try {
                ReferenceTermImpl referenceTerm = new ReferenceTermImpl(new URL(id), new HashSet());
                referenceTermSet.add((ReferenceTerm)referenceTerm);
            }
            catch (MalformedURLException e) {
                LOGGER.debug("Invalid enrichment reference found: {}", (Object)id);
            }
        }
        ArrayList<EnrichmentBase> result = new ArrayList<EnrichmentBase>(this.dereferenceOwnEntities(referenceTermSet));
        Set foundOwnEntityIds = result.stream().map(EnrichmentBase::getAbout).collect(Collectors.toSet());
        for (ReferenceTerm resourceId : referenceTermSet) {
            if (foundOwnEntityIds.contains(resourceId.getReference().toString())) continue;
            result.addAll(this.dereferenceExternalEntity(resourceId.getReference().toString()));
        }
        return result;
    }

    private List<EnrichmentBase> dereferenceOwnEntities(Set<ReferenceTerm> resourceIds) throws DereferenceException {
        if (this.remoteEntityResolver == null) {
            return Collections.emptyList();
        }
        try {
            return new ArrayList<EnrichmentBase>(((Map)ExternalRequestUtil.retryableExternalRequestForNetworkExceptions(() -> this.remoteEntityResolver.resolveById(resourceIds))).values());
        }
        catch (Exception e) {
            throw new DereferenceException("Exception occurred while trying to perform dereferencing.", e);
        }
    }

    private List<EnrichmentBase> dereferenceExternalEntity(String resourceId) throws DereferenceException {
        EnrichmentResultList result;
        if (this.dereferenceClient == null) {
            return Collections.emptyList();
        }
        try {
            LOGGER.debug("== Processing {}", (Object)resourceId);
            result = (EnrichmentResultList)ExternalRequestUtil.retryableExternalRequestForNetworkExceptions(() -> this.dereferenceClient.dereference(resourceId));
        }
        catch (HttpClientErrorException.BadRequest e) {
            LOGGER.warn("ResourceId {}, failed", (Object)resourceId, (Object)e);
            result = null;
        }
        catch (Exception e) {
            throw new DereferenceException("Exception occurred while trying to perform dereferencing.", e);
        }
        return Optional.ofNullable(result).map(EnrichmentResultList::getEnrichmentBaseResultWrapperList).orElseGet(Collections::emptyList).stream().map(EnrichmentResultBaseWrapper::getEnrichmentBaseList).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    public Set<String> extractReferencesForDereferencing(RDF rdf) {
        return DereferenceUtils.extractReferencesForDereferencing(rdf);
    }
}

