/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.rest.client.dereference;

import eu.europeana.enrichment.rest.client.ConnectionProvider;
import eu.europeana.enrichment.rest.client.dereference.DereferenceClient;
import eu.europeana.enrichment.rest.client.dereference.Dereferencer;
import eu.europeana.enrichment.rest.client.dereference.DereferencerImpl;
import eu.europeana.enrichment.rest.client.enrichment.RemoteEntityResolver;
import eu.europeana.enrichment.rest.client.exceptions.DereferenceException;
import eu.europeana.enrichment.utils.EntityMergeEngine;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DereferencerProvider
extends ConnectionProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(DereferencerProvider.class);
    private String dereferenceUrl;
    private String enrichmentUrl;

    public void setDereferenceUrl(String dereferenceUrl) {
        this.dereferenceUrl = dereferenceUrl;
    }

    public void setEnrichmentUrl(String enrichmentUrl) {
        this.enrichmentUrl = enrichmentUrl;
    }

    public Dereferencer create() throws DereferenceException {
        RemoteEntityResolver remoteEntityResolver;
        if (StringUtils.isBlank((CharSequence)this.dereferenceUrl) && StringUtils.isBlank((CharSequence)this.enrichmentUrl)) {
            throw new IllegalStateException("Dereferencing must be enabled.");
        }
        DereferenceClient dereferenceClient = StringUtils.isNotBlank((CharSequence)this.dereferenceUrl) ? new DereferenceClient(this.createRestTemplate(), this.dereferenceUrl) : null;
        if (StringUtils.isNotBlank((CharSequence)this.enrichmentUrl)) {
            try {
                remoteEntityResolver = new RemoteEntityResolver(new URL(this.enrichmentUrl), this.batchSizeEnrichment, this.createRestTemplate());
            }
            catch (MalformedURLException e) {
                LOGGER.debug("There was a problem with the input values");
                throw new DereferenceException("Problems while building a new Dereferencer", e);
            }
        } else {
            remoteEntityResolver = null;
        }
        return new DereferencerImpl(new EntityMergeEngine(), remoteEntityResolver, dereferenceClient);
    }
}

