/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.rest.client.enrichment;

import eu.europeana.enrichment.api.exceptions.UnknownException;
import eu.europeana.enrichment.api.external.EnrichmentReference;
import eu.europeana.enrichment.api.external.EnrichmentSearch;
import eu.europeana.enrichment.api.external.ReferenceValue;
import eu.europeana.enrichment.api.external.SearchValue;
import eu.europeana.enrichment.api.external.model.EnrichmentBase;
import eu.europeana.enrichment.api.external.model.EnrichmentResultBaseWrapper;
import eu.europeana.enrichment.api.external.model.EnrichmentResultList;
import eu.europeana.enrichment.api.internal.EntityResolver;
import eu.europeana.enrichment.api.internal.ReferenceTerm;
import eu.europeana.enrichment.api.internal.SearchTerm;
import eu.europeana.enrichment.utils.EntityType;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class RemoteEntityResolver
implements EntityResolver {
    private final int batchSize;
    private final RestTemplate template;
    private final URL enrichmentServiceUrl;

    public RemoteEntityResolver(URL enrichmentServiceUrl, int batchSize, RestTemplate template) {
        this.enrichmentServiceUrl = enrichmentServiceUrl;
        this.template = template;
        this.batchSize = batchSize;
    }

    public <T extends SearchTerm> Map<T, List<EnrichmentBase>> resolveByText(Set<T> searchTerms) {
        Function<List, EnrichmentSearch> inputFunction = partition -> {
            List searchValues = partition.stream().map(term -> new SearchValue(term.getTextValue(), term.getLanguage(), (EntityType[])term.getCandidateTypes().toArray(EntityType[]::new))).collect(Collectors.toList());
            EnrichmentSearch enrichmentSearch = new EnrichmentSearch();
            enrichmentSearch.setSearchValues(searchValues);
            return enrichmentSearch;
        };
        return this.performInBatches("/enrich/entity/search", searchTerms, inputFunction, Function.identity());
    }

    public <T extends ReferenceTerm> Map<T, EnrichmentBase> resolveById(Set<T> referenceTerms) {
        return this.performInBatches("/enrich/entity/id", referenceTerms, partition -> (String[])partition.stream().map(ReferenceTerm::getReference).map(URL::toString).toArray(String[]::new), resultItem -> resultItem.stream().findFirst().orElse(null));
    }

    public <T extends ReferenceTerm> Map<T, List<EnrichmentBase>> resolveByUri(Set<T> referenceTerms) {
        Function<List, EnrichmentReference> inputFunction = partition -> {
            List referenceValues = partition.stream().map(ReferenceTerm::getReference).map(URL::toString).map(uri -> new ReferenceValue(uri, Collections.emptySet())).collect(Collectors.toList());
            EnrichmentReference enrichmentReference = new EnrichmentReference();
            enrichmentReference.setReferenceValues(referenceValues);
            return enrichmentReference;
        };
        return this.performInBatches("/enrich/entity/equivalence", referenceTerms, inputFunction, Function.identity());
    }

    private <I, B, R> Map<I, R> performInBatches(String endpointPath, Set<I> inputValues, Function<List<I>, B> bodyCreator, Function<List<EnrichmentBase>, R> resultParser) {
        URI uri;
        try {
            URI parentUri = this.enrichmentServiceUrl.toURI();
            uri = new URI(parentUri.getScheme(), parentUri.getUserInfo(), parentUri.getHost(), parentUri.getPort(), parentUri.getPath() + "/" + endpointPath, parentUri.getQuery(), parentUri.getFragment()).normalize();
        }
        catch (URISyntaxException e) {
            throw new UnknownException("URL syntax issue with service url: " + this.enrichmentServiceUrl + ".", (Throwable)e);
        }
        ArrayList partitions = new ArrayList();
        partitions.add(new ArrayList());
        inputValues.forEach(item -> {
            ArrayList<Object> currentPartition = (ArrayList<Object>)partitions.get(partitions.size() - 1);
            if (currentPartition.size() >= this.batchSize) {
                currentPartition = new ArrayList<Object>();
                partitions.add(currentPartition);
            }
            currentPartition.add(item);
        });
        HashMap result = new HashMap();
        for (List list2 : partitions) {
            EnrichmentResultList enrichmentResultList = this.executeRequest(uri, bodyCreator, list2);
            for (int i = 0; i < list2.size(); ++i) {
                Object inputItem = list2.get(i);
                Optional.ofNullable((EnrichmentResultBaseWrapper)enrichmentResultList.getEnrichmentBaseResultWrapperList().get(i)).map(EnrichmentResultBaseWrapper::getEnrichmentBaseList).filter(list -> !list.isEmpty()).map(resultParser).ifPresent(resultItem -> result.put(inputItem, resultItem));
            }
        }
        return result;
    }

    private <I, B> EnrichmentResultList executeRequest(URI uri, Function<List<I>, B> bodyCreator, List<I> partition) {
        EnrichmentResultList enrichmentResultList;
        B body = bodyCreator.apply(partition);
        HttpHeaders headers = new HttpHeaders();
        if (body != null) {
            headers.setContentType(MediaType.APPLICATION_JSON);
        }
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_XML));
        HttpEntity httpEntity = new HttpEntity(body, (MultiValueMap)headers);
        try {
            enrichmentResultList = (EnrichmentResultList)this.template.postForObject(uri, (Object)httpEntity, EnrichmentResultList.class);
        }
        catch (RestClientException e) {
            throw new UnknownException("Enrichment client POST call failed: " + uri + ".", (Throwable)e);
        }
        if (enrichmentResultList == null) {
            throw new UnknownException("Empty body from server (" + uri + ").");
        }
        if (enrichmentResultList.getEnrichmentBaseResultWrapperList().size() != partition.size()) {
            throw new UnknownException("Server returned unexpected number of results (" + uri + ").");
        }
        return enrichmentResultList;
    }
}

