/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.rest.client;

import java.util.Arrays;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.converter.xml.Jaxb2RootElementHttpMessageConverter;
import org.springframework.web.client.RestTemplate;

public class ConnectionProvider {
    public static final int DEFAULT_CONNECT_TIMEOUT = 10000;
    public static final int DEFAULT_RESPONSE_TIMEOUT = 60000;
    public static final int DEFAULT_BATCH_SIZE_ENRICHMENT = 20;
    private int connectTimeout = 10000;
    private int responseTimeout = 60000;
    protected int batchSizeEnrichment = 20;

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setResponseTimeout(int responseTimeout) {
        this.responseTimeout = responseTimeout;
    }

    public void setBatchSizeEnrichment(int batchSizeEnrichment) {
        if (batchSizeEnrichment < 1) {
            throw new IllegalArgumentException("Batch size cannot be 0 or negative.");
        }
        this.batchSizeEnrichment = batchSizeEnrichment;
    }

    protected RestTemplate createRestTemplate() {
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory();
        requestFactory.setConnectTimeout(Math.max(this.connectTimeout, 0));
        requestFactory.setReadTimeout(Math.max(this.responseTimeout, 0));
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)requestFactory);
        restTemplate.setMessageConverters(Arrays.asList(new Jaxb2RootElementHttpMessageConverter(), new MappingJackson2HttpMessageConverter()));
        return restTemplate;
    }
}

