/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.utils;

import eu.europeana.enrichment.api.internal.FieldType;
import eu.europeana.metis.schema.jibx.EuropeanaType;
import eu.europeana.metis.schema.jibx.ProxyType;
import eu.europeana.metis.schema.jibx.RDF;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public final class RdfProxyUtils {
    private RdfProxyUtils() {
    }

    public static void appendLinkToEuropeanaProxy(RDF rdf, String link, Set<FieldType> linkTypes) {
        Map<FieldType, Set<String>> allProxyLinksPerType = RdfProxyUtils.getAllProxyLinksPerType(rdf);
        ProxyType europeanaProxy = RdfProxyUtils.getEuropeanaProxy(rdf);
        for (FieldType linkType : linkTypes) {
            boolean alreadyExists = Optional.ofNullable(allProxyLinksPerType.get(linkType)).orElseGet(Collections::emptySet).contains(link);
            if (alreadyExists) continue;
            List choices = Optional.ofNullable(europeanaProxy.getChoiceList()).orElseGet(ArrayList::new);
            choices.add(linkType.createChoice(link));
            europeanaProxy.setChoiceList(choices);
        }
        RdfProxyUtils.replaceProxy(rdf, europeanaProxy);
    }

    private static Map<FieldType, Set<String>> getAllProxyLinksPerType(RDF rdf) {
        List allChoices = Optional.ofNullable(rdf.getProxyList()).stream().flatMap(Collection::stream).filter(Objects::nonNull).map(EuropeanaType::getChoiceList).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
        EnumMap<FieldType, Set<String>> result = new EnumMap<FieldType, Set<String>>(FieldType.class);
        for (FieldType linkType : FieldType.values()) {
            Set links = allChoices.stream().map(arg_0 -> ((FieldType)linkType).getResourceIfRightChoice(arg_0)).filter(Objects::nonNull).collect(Collectors.toSet());
            if (links.isEmpty()) continue;
            result.put(linkType, links);
        }
        return result;
    }

    public static List<ProxyType> getProviderProxies(RDF rdf) {
        return Optional.ofNullable(rdf.getProxyList()).stream().flatMap(Collection::stream).filter(Objects::nonNull).filter(proxy -> !RdfProxyUtils.isEuropeanaProxy(proxy)).collect(Collectors.toList());
    }

    private static boolean isEuropeanaProxy(ProxyType proxy) {
        return proxy.getEuropeanaProxy() != null && proxy.getEuropeanaProxy().isEuropeanaProxy();
    }

    public static ProxyType getEuropeanaProxy(RDF rdf) {
        return Optional.ofNullable(rdf.getProxyList()).stream().flatMap(Collection::stream).filter(Objects::nonNull).filter(RdfProxyUtils::isEuropeanaProxy).findAny().orElseThrow(() -> new IllegalArgumentException("Could not find Europeana proxy."));
    }

    private static void replaceProxy(RDF rdf, ProxyType europeanaProxy) {
        ArrayList<ProxyType> proxyTypeList = new ArrayList<ProxyType>();
        proxyTypeList.add(europeanaProxy);
        for (ProxyType proxyType : rdf.getProxyList()) {
            if (StringUtils.equals((CharSequence)proxyType.getAbout(), (CharSequence)europeanaProxy.getAbout())) continue;
            proxyTypeList.add(proxyType);
        }
        rdf.setProxyList(proxyTypeList);
    }
}

