/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.rest.client.enrichment;

import eu.europeana.enrichment.api.internal.FieldType;
import eu.europeana.enrichment.api.internal.RecordParser;
import eu.europeana.enrichment.api.internal.ReferenceTermContext;
import eu.europeana.enrichment.api.internal.SearchTermContext;
import eu.europeana.enrichment.utils.RdfProxyUtils;
import eu.europeana.metis.schema.jibx.AboutType;
import eu.europeana.metis.schema.jibx.AgentType;
import eu.europeana.metis.schema.jibx.Concept;
import eu.europeana.metis.schema.jibx.PlaceType;
import eu.europeana.metis.schema.jibx.ProxyType;
import eu.europeana.metis.schema.jibx.RDF;
import eu.europeana.metis.schema.jibx.ResourceType;
import eu.europeana.metis.schema.jibx.TimeSpanType;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetisRecordParser
implements RecordParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetisRecordParser.class);

    public Set<SearchTermContext> parseSearchTerms(RDF rdf) {
        List<ProxyType> providerProxies = RdfProxyUtils.getProviderProxies(rdf);
        HashMap result = new HashMap();
        for (FieldType field : FieldType.values()) {
            providerProxies.stream().map(arg_0 -> ((FieldType)field).extractFieldValuesForEnrichment(arg_0)).flatMap(Collection::stream).forEach(value -> result.computeIfAbsent(value, key -> new HashSet()).add(field));
        }
        return result.entrySet().stream().map(entry -> new SearchTermContext(((FieldType.FieldValue)entry.getKey()).getValue(), ((FieldType.FieldValue)entry.getKey()).getLanguage(), (Set)entry.getValue())).collect(Collectors.toSet());
    }

    public Set<ReferenceTermContext> parseReferences(RDF rdf) {
        List proxies = Optional.ofNullable(rdf.getProxyList()).stream().flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
        HashMap<String, Set> directReferences = new HashMap<String, Set>();
        for (FieldType field : FieldType.values()) {
            Set directLinks = proxies.stream().map(arg_0 -> ((FieldType)field).extractFieldLinksForEnrichment(arg_0)).flatMap(Collection::stream).collect(Collectors.toSet());
            for (String directLink : directLinks) {
                directReferences.computeIfAbsent(directLink, key -> EnumSet.noneOf(FieldType.class)).add(field);
            }
        }
        HashMap indirectReferences = new HashMap();
        Consumer<AboutType> contextualTypeProcessor = contextualClass -> {
            Set linkTypes = (Set)directReferences.get(contextualClass.getAbout());
            if (linkTypes != null) {
                for (String sameAsLink : MetisRecordParser.getSameAsLinks(contextualClass)) {
                    indirectReferences.computeIfAbsent(sameAsLink, key -> EnumSet.noneOf(FieldType.class)).addAll(linkTypes);
                }
            }
        };
        Optional.ofNullable(rdf.getAgentList()).orElseGet(Collections::emptyList).forEach(contextualTypeProcessor);
        Optional.ofNullable(rdf.getConceptList()).orElseGet(Collections::emptyList).forEach(contextualTypeProcessor);
        Optional.ofNullable(rdf.getPlaceList()).orElseGet(Collections::emptyList).forEach(contextualTypeProcessor);
        Optional.ofNullable(rdf.getTimeSpanList()).orElseGet(Collections::emptyList).forEach(contextualTypeProcessor);
        Map resultMap = MetisRecordParser.mergeMapInto(directReferences, indirectReferences);
        resultMap.remove(null);
        HashSet<ReferenceTermContext> result = new HashSet<ReferenceTermContext>();
        for (Map.Entry entry : resultMap.entrySet()) {
            try {
                ReferenceTermContext value = new ReferenceTermContext(new URL((String)entry.getKey()), entry.getValue());
                result.add(value);
            }
            catch (MalformedURLException e) {
                LOGGER.debug("Invalid enrichment reference found: {}", entry.getKey());
            }
        }
        return result;
    }

    private static Set<String> getSameAsLinks(AboutType contextualClass) {
        List<Object> result = contextualClass instanceof AgentType ? ((AgentType)contextualClass).getSameAList() : (contextualClass instanceof Concept ? Optional.ofNullable(((Concept)contextualClass).getChoiceList()).stream().flatMap(Collection::stream).filter(Objects::nonNull).filter(Concept.Choice::ifExactMatch).map(Concept.Choice::getExactMatch).filter(Objects::nonNull).collect(Collectors.toList()) : (contextualClass instanceof PlaceType ? ((PlaceType)contextualClass).getSameAList() : (contextualClass instanceof TimeSpanType ? ((TimeSpanType)contextualClass).getSameAList() : null)));
        return Optional.ofNullable(result).orElseGet(Collections::emptyList).stream().filter(Objects::nonNull).map(ResourceType::getResource).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
    }

    private static <T, S> Map<T, Set<S>> mergeMapInto(Map<T, Set<S>> map1, Map<T, Set<S>> map2) {
        map2.forEach((key, values) -> map1.merge((Object)key, (Set)values, (values1, values2) -> {
            values1.addAll(values2);
            return values1;
        }));
        return map1;
    }
}

