/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.rest.client.enrichment;

import eu.europeana.enrichment.api.internal.EntityResolver;
import eu.europeana.enrichment.api.internal.RecordParser;
import eu.europeana.enrichment.rest.client.ConnectionProvider;
import eu.europeana.enrichment.rest.client.enrichment.Enricher;
import eu.europeana.enrichment.rest.client.enrichment.EnricherImpl;
import eu.europeana.enrichment.rest.client.enrichment.MetisRecordParser;
import eu.europeana.enrichment.rest.client.enrichment.RemoteEntityResolver;
import eu.europeana.enrichment.rest.client.exceptions.EnrichmentException;
import eu.europeana.enrichment.utils.EntityMergeEngine;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnricherProvider
extends ConnectionProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnricherProvider.class);
    private RecordParser recordParser;
    private EntityResolverCreator entityResolverCreator;
    private String enrichmentUrl;

    public void setRecordParser(RecordParser recordParser) {
        this.recordParser = recordParser;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.setEntityResolverCreator(() -> entityResolver);
    }

    public void setEntityResolverCreator(EntityResolverCreator entityResolverCreator) {
        this.entityResolverCreator = entityResolverCreator;
    }

    public void setEnrichmentUrl(String enrichmentUrl) {
        this.enrichmentUrl = enrichmentUrl;
    }

    public Enricher create() throws EnrichmentException {
        EntityResolver entityResolver;
        if (this.entityResolverCreator != null) {
            entityResolver = this.entityResolverCreator.createEntityResolver();
            if (entityResolver == null) {
                throw new EnrichmentException("Entity resolver creator returned a null object.", null);
            }
        } else if (StringUtils.isNotBlank((CharSequence)this.enrichmentUrl)) {
            try {
                entityResolver = new RemoteEntityResolver(new URL(this.enrichmentUrl), this.batchSizeEnrichment, this.createRestTemplate());
            }
            catch (MalformedURLException e) {
                LOGGER.debug("There was a problem creating entity resolver");
                throw new EnrichmentException("There was a problem while creating new Enricher", e);
            }
        } else {
            throw new EnrichmentException("We must have either a non-null entity resolver creator, or a non-blank enrichment URL.", null);
        }
        return new EnricherImpl(this.recordParser == null ? new MetisRecordParser() : this.recordParser, entityResolver, new EntityMergeEngine());
    }

    @FunctionalInterface
    public static interface EntityResolverCreator {
        public EntityResolver createEntityResolver() throws EnrichmentException;
    }
}

