/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.rest.client.dereference;

import eu.europeana.enrichment.api.external.model.EnrichmentResultList;
import eu.europeana.metis.dereference.Vocabulary;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class DereferenceClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(DereferenceClient.class);
    private final String hostUrl;
    private final RestTemplate restTemplate;

    public DereferenceClient(RestTemplate restTemplate, String hostUrl) {
        this.restTemplate = restTemplate;
        this.hostUrl = hostUrl;
    }

    public List<Vocabulary> getAllVocabularies() {
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        Vocabulary[] result = (Vocabulary[])this.restTemplate.exchange(this.hostUrl + "/vocabularies", HttpMethod.GET, entity, Vocabulary[].class, new Object[0]).getBody();
        return Optional.ofNullable(result).map(Arrays::asList).orElseGet(Collections::emptyList);
    }

    public EnrichmentResultList dereference(String resourceId) {
        URI dereferenceUrl;
        String resourceString;
        try {
            resourceString = URLEncoder.encode(resourceId, StandardCharsets.UTF_8.name()).replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
        if (!resourceString.startsWith("http") && !resourceString.startsWith("https")) {
            return null;
        }
        String dereferenceUrlString = this.hostUrl + "/dereference?uri=" + resourceString;
        try {
            dereferenceUrl = new URI(this.hostUrl + "/dereference?uri=" + resourceString);
        }
        catch (URISyntaxException e) {
            LOGGER.warn("URL [{}] is not valid.", (Object)dereferenceUrlString, (Object)e);
            return null;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_XML));
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        return (EnrichmentResultList)this.restTemplate.exchange(dereferenceUrl, HttpMethod.GET, entity, EnrichmentResultList.class).getBody();
    }
}

