/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.utils;

import eu.europeana.corelib.definitions.jibx.AboutType;
import eu.europeana.corelib.definitions.jibx.AgentType;
import eu.europeana.corelib.definitions.jibx.Alt;
import eu.europeana.corelib.definitions.jibx.AltLabel;
import eu.europeana.corelib.definitions.jibx.Begin;
import eu.europeana.corelib.definitions.jibx.BiographicalInformation;
import eu.europeana.corelib.definitions.jibx.BroadMatch;
import eu.europeana.corelib.definitions.jibx.Broader;
import eu.europeana.corelib.definitions.jibx.CloseMatch;
import eu.europeana.corelib.definitions.jibx.Concept;
import eu.europeana.corelib.definitions.jibx.Date;
import eu.europeana.corelib.definitions.jibx.DateOfBirth;
import eu.europeana.corelib.definitions.jibx.DateOfDeath;
import eu.europeana.corelib.definitions.jibx.DateOfEstablishment;
import eu.europeana.corelib.definitions.jibx.DateOfTermination;
import eu.europeana.corelib.definitions.jibx.End;
import eu.europeana.corelib.definitions.jibx.ExactMatch;
import eu.europeana.corelib.definitions.jibx.Gender;
import eu.europeana.corelib.definitions.jibx.HasMet;
import eu.europeana.corelib.definitions.jibx.HasPart;
import eu.europeana.corelib.definitions.jibx.Identifier;
import eu.europeana.corelib.definitions.jibx.InScheme;
import eu.europeana.corelib.definitions.jibx.IsPartOf;
import eu.europeana.corelib.definitions.jibx.IsRelatedTo;
import eu.europeana.corelib.definitions.jibx.Lat;
import eu.europeana.corelib.definitions.jibx.NarrowMatch;
import eu.europeana.corelib.definitions.jibx.Narrower;
import eu.europeana.corelib.definitions.jibx.Notation;
import eu.europeana.corelib.definitions.jibx.Note;
import eu.europeana.corelib.definitions.jibx.PlaceOfBirth;
import eu.europeana.corelib.definitions.jibx.PlaceOfDeath;
import eu.europeana.corelib.definitions.jibx.PlaceType;
import eu.europeana.corelib.definitions.jibx.PrefLabel;
import eu.europeana.corelib.definitions.jibx.ProfessionOrOccupation;
import eu.europeana.corelib.definitions.jibx.RDF;
import eu.europeana.corelib.definitions.jibx.Related;
import eu.europeana.corelib.definitions.jibx.RelatedMatch;
import eu.europeana.corelib.definitions.jibx.SameAs;
import eu.europeana.corelib.definitions.jibx.TimeSpanType;
import eu.europeana.corelib.definitions.jibx._Long;
import eu.europeana.enrichment.api.external.model.Agent;
import eu.europeana.enrichment.api.external.model.Concept;
import eu.europeana.enrichment.api.external.model.EnrichmentBase;
import eu.europeana.enrichment.api.external.model.EnrichmentBaseWrapper;
import eu.europeana.enrichment.api.external.model.Label;
import eu.europeana.enrichment.api.external.model.Part;
import eu.europeana.enrichment.api.external.model.Place;
import eu.europeana.enrichment.api.external.model.Timespan;
import eu.europeana.enrichment.api.external.model.WebResource;
import eu.europeana.enrichment.utils.EnrichmentFields;
import eu.europeana.enrichment.utils.ItemExtractorUtils;
import eu.europeana.enrichment.utils.RdfProxyUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public class EntityMergeEngine {
    private static PlaceType convertPlace(Place place) {
        PlaceType placeType = new PlaceType();
        ItemExtractorUtils.setAbout((EnrichmentBase)place, (AboutType)placeType);
        if (place.getAlt() != null) {
            Alt alt = new Alt();
            alt.setAlt(Float.valueOf(place.getAlt()));
            placeType.setAlt(alt);
        }
        placeType.setAltLabelList(ItemExtractorUtils.extractLabels(place.getAltLabelList(), AltLabel::new));
        placeType.setHasPartList(ItemExtractorUtils.extractParts(place.getHasPartsList(), HasPart::new));
        placeType.setIsPartOfList(ItemExtractorUtils.extractParts(place.getIsPartOfList(), IsPartOf::new));
        if (place.getLat() != null) {
            Lat lat = new Lat();
            lat.setLat(Float.valueOf(place.getLat()));
            placeType.setLat(lat);
        }
        if (place.getLon() != null) {
            _Long longitude = new _Long();
            longitude.setLong(Float.valueOf(place.getLon()));
            placeType.setLong(longitude);
        }
        placeType.setNoteList(ItemExtractorUtils.extractLabels(place.getNotes(), Note::new));
        placeType.setPrefLabelList(ItemExtractorUtils.extractLabels(place.getPrefLabelList(), PrefLabel::new));
        placeType.setSameAList(ItemExtractorUtils.extractAsResources(place.getSameAs(), SameAs::new, Part::getResource));
        return placeType;
    }

    private static AgentType convertAgent(Agent agent) {
        AgentType agentType = new AgentType();
        ItemExtractorUtils.setAbout((EnrichmentBase)agent, (AboutType)agentType);
        agentType.setAltLabelList(ItemExtractorUtils.extractLabels(agent.getAltLabelList(), AltLabel::new));
        agentType.setBegin(ItemExtractorUtils.extractFirstLabel(agent.getBeginList(), Begin::new));
        agentType.setBiographicalInformationList(ItemExtractorUtils.extractLabelsToResourceOrLiteralList(agent.getBiographicaInformation(), BiographicalInformation::new));
        agentType.setProfessionOrOccupationList(ItemExtractorUtils.extractLabelResources(agent.getProfessionOrOccupation(), ProfessionOrOccupation::new));
        agentType.setDateList(ItemExtractorUtils.extractLabelResources(agent.getDate(), Date::new));
        agentType.setPlaceOfBirthList(ItemExtractorUtils.extractLabelResources(agent.getPlaceOfBirth(), PlaceOfBirth::new));
        agentType.setPlaceOfDeathList(ItemExtractorUtils.extractLabelResources(agent.getPlaceOfDeath(), PlaceOfDeath::new));
        agentType.setDateOfBirth(ItemExtractorUtils.extractFirstLabel(agent.getDateOfBirth(), DateOfBirth::new));
        agentType.setDateOfDeath(ItemExtractorUtils.extractFirstLabel(agent.getDateOfDeath(), DateOfDeath::new));
        agentType.setDateOfEstablishment(ItemExtractorUtils.extractFirstLabel(agent.getDateOfEstablishment(), DateOfEstablishment::new));
        agentType.setDateOfTermination(ItemExtractorUtils.extractFirstLabel(agent.getDateOfTermination(), DateOfTermination::new));
        agentType.setEnd(ItemExtractorUtils.extractFirstLabel(agent.getEndList(), End::new));
        agentType.setGender(ItemExtractorUtils.extractFirstLabel(agent.getGender(), Gender::new));
        agentType.setHasMetList(ItemExtractorUtils.extractAsResources(agent.getHasMet(), HasMet::new, Label::getValue));
        agentType.setIdentifierList(ItemExtractorUtils.extractLabels(agent.getIdentifier(), Identifier::new));
        agentType.setIsRelatedToList(ItemExtractorUtils.extractLabelResources(agent.getIsRelatedTo(), IsRelatedTo::new));
        agentType.setNoteList(ItemExtractorUtils.extractLabels(agent.getNotes(), Note::new));
        agentType.setPrefLabelList(ItemExtractorUtils.extractLabels(agent.getPrefLabelList(), PrefLabel::new));
        agentType.setProfessionOrOccupationList(ItemExtractorUtils.extractLabelResources(agent.getProfessionOrOccupation(), ProfessionOrOccupation::new));
        agentType.setSameAList(ItemExtractorUtils.extractAsResources(agent.getSameAs(), SameAs::new, Part::getResource));
        return agentType;
    }

    private static eu.europeana.corelib.definitions.jibx.Concept convertConcept(Concept baseConcept) {
        eu.europeana.corelib.definitions.jibx.Concept concept = new eu.europeana.corelib.definitions.jibx.Concept();
        ItemExtractorUtils.setAbout((EnrichmentBase)baseConcept, (AboutType)concept);
        ArrayList<Concept.Choice> choices = new ArrayList<Concept.Choice>();
        List<AltLabel> altLabels = ItemExtractorUtils.extractLabels(baseConcept.getAltLabelList(), AltLabel::new);
        ItemExtractorUtils.toChoices(altLabels, Concept.Choice::setAltLabel, choices);
        List<BroadMatch> broadMatches = ItemExtractorUtils.extractResources(baseConcept.getBroadMatch(), BroadMatch::new);
        ItemExtractorUtils.toChoices(broadMatches, Concept.Choice::setBroadMatch, choices);
        List<Broader> broaders = ItemExtractorUtils.extractResources(baseConcept.getBroader(), Broader::new);
        ItemExtractorUtils.toChoices(broaders, Concept.Choice::setBroader, choices);
        List<CloseMatch> closeMatches = ItemExtractorUtils.extractResources(baseConcept.getCloseMatch(), CloseMatch::new);
        ItemExtractorUtils.toChoices(closeMatches, Concept.Choice::setCloseMatch, choices);
        List<ExactMatch> exactMatches = ItemExtractorUtils.extractResources(baseConcept.getExactMatch(), ExactMatch::new);
        ItemExtractorUtils.toChoices(exactMatches, Concept.Choice::setExactMatch, choices);
        List<InScheme> inSchemes = ItemExtractorUtils.extractResources(baseConcept.getInScheme(), InScheme::new);
        ItemExtractorUtils.toChoices(inSchemes, Concept.Choice::setInScheme, choices);
        List<Narrower> narrowers = ItemExtractorUtils.extractResources(baseConcept.getNarrower(), Narrower::new);
        ItemExtractorUtils.toChoices(narrowers, Concept.Choice::setNarrower, choices);
        List<NarrowMatch> narrowMatches = ItemExtractorUtils.extractResources(baseConcept.getNarrowMatch(), NarrowMatch::new);
        ItemExtractorUtils.toChoices(narrowMatches, Concept.Choice::setNarrowMatch, choices);
        List<Notation> notations = ItemExtractorUtils.extractLabels(baseConcept.getNotation(), Notation::new);
        ItemExtractorUtils.toChoices(notations, Concept.Choice::setNotation, choices);
        List<Note> notes = ItemExtractorUtils.extractLabels(baseConcept.getNotes(), Note::new);
        ItemExtractorUtils.toChoices(notes, Concept.Choice::setNote, choices);
        List<PrefLabel> prefLabels = ItemExtractorUtils.extractLabels(baseConcept.getPrefLabelList(), PrefLabel::new);
        ItemExtractorUtils.toChoices(prefLabels, Concept.Choice::setPrefLabel, choices);
        List<Related> relateds = ItemExtractorUtils.extractResources(baseConcept.getRelated(), Related::new);
        ItemExtractorUtils.toChoices(relateds, Concept.Choice::setRelated, choices);
        List<RelatedMatch> relatedMatches = ItemExtractorUtils.extractResources(baseConcept.getRelatedMatch(), RelatedMatch::new);
        ItemExtractorUtils.toChoices(relatedMatches, Concept.Choice::setRelatedMatch, choices);
        concept.setChoiceList(choices);
        return concept;
    }

    private static TimeSpanType convertTimeSpan(Timespan timespan) {
        TimeSpanType timeSpanType = new TimeSpanType();
        ItemExtractorUtils.setAbout((EnrichmentBase)timespan, (AboutType)timeSpanType);
        timeSpanType.setAltLabelList(ItemExtractorUtils.extractLabels(timespan.getAltLabelList(), AltLabel::new));
        timeSpanType.setBegin(ItemExtractorUtils.extractFirstLabel(timespan.getBeginList(), Begin::new));
        timeSpanType.setEnd(ItemExtractorUtils.extractFirstLabel(timespan.getEndList(), End::new));
        timeSpanType.setHasPartList(ItemExtractorUtils.extractParts(timespan.getHasPartsList(), HasPart::new));
        timeSpanType.setIsPartOfList(ItemExtractorUtils.extractParts(timespan.getIsPartOfList(), IsPartOf::new));
        timeSpanType.setNoteList(ItemExtractorUtils.extractLabels(timespan.getNotes(), Note::new));
        timeSpanType.setPrefLabelList(ItemExtractorUtils.extractLabels(timespan.getPrefLabelList(), PrefLabel::new));
        timeSpanType.setSameAList(ItemExtractorUtils.extractAsResources(timespan.getSameAs(), SameAs::new, Part::getResource));
        return timeSpanType;
    }

    private static <I extends EnrichmentBase, T extends AboutType> T convertAndAddEntity(I inputEntity, Function<I, T> converter, Supplier<List<T>> listGetter, Consumer<List<T>> listSetter) {
        AboutType existingEntity = Optional.ofNullable(listGetter.get()).map(Collection::stream).orElseGet(Stream::empty).filter(candidate -> inputEntity.getAbout().equals(candidate.getAbout())).findAny().orElse(null);
        if (existingEntity != null) {
            return (T)existingEntity;
        }
        AboutType convertedEntity = (AboutType)converter.apply(inputEntity);
        if (listGetter.get() == null) {
            listSetter.accept(new ArrayList());
        }
        listGetter.get().add(convertedEntity);
        return (T)convertedEntity;
    }

    private static void convertAndAddEntity(RDF rdf, EnrichmentBase enrichmentBase, Set<EnrichmentFields> proxyLinkTypes) {
        PlaceType entity;
        if (enrichmentBase instanceof Place) {
            entity = EntityMergeEngine.convertAndAddEntity((Place)enrichmentBase, EntityMergeEngine::convertPlace, () -> ((RDF)rdf).getPlaceList(), arg_0 -> ((RDF)rdf).setPlaceList(arg_0));
        } else if (enrichmentBase instanceof Agent) {
            entity = EntityMergeEngine.convertAndAddEntity((Agent)enrichmentBase, EntityMergeEngine::convertAgent, () -> ((RDF)rdf).getAgentList(), arg_0 -> ((RDF)rdf).setAgentList(arg_0));
        } else if (enrichmentBase instanceof Concept) {
            entity = EntityMergeEngine.convertAndAddEntity((Concept)enrichmentBase, EntityMergeEngine::convertConcept, () -> ((RDF)rdf).getConceptList(), arg_0 -> ((RDF)rdf).setConceptList(arg_0));
        } else if (enrichmentBase instanceof Timespan) {
            entity = EntityMergeEngine.convertAndAddEntity((Timespan)enrichmentBase, EntityMergeEngine::convertTimeSpan, () -> ((RDF)rdf).getTimeSpanList(), arg_0 -> ((RDF)rdf).setTimeSpanList(arg_0));
        } else {
            throw new IllegalArgumentException("Unknown entity type: " + enrichmentBase.getClass());
        }
        if (!CollectionUtils.isEmpty(proxyLinkTypes)) {
            RdfProxyUtils.appendLinkToEuropeanaProxy(rdf, entity.getAbout(), proxyLinkTypes);
        }
    }

    public void mergeEntities(RDF rdf, List<EnrichmentBaseWrapper> enrichmentBaseWrapperList) {
        for (EnrichmentBaseWrapper enrichmentBaseWrapper : enrichmentBaseWrapperList) {
            Set proxyLinkTypes = Optional.ofNullable(enrichmentBaseWrapper.getRdfFieldName()).filter(StringUtils::isNotBlank).map(EnrichmentFields::valueOf).map(Collections::singleton).orElse(null);
            EntityMergeEngine.convertAndAddEntity(rdf, enrichmentBaseWrapper.getEnrichmentBase(), proxyLinkTypes);
        }
    }

    public void mergeEntities(RDF rdf, List<EnrichmentBase> contextualEntities, Map<String, Set<EnrichmentFields>> proxyLinkTypes) {
        for (EnrichmentBase entity : contextualEntities) {
            Set<String> links = EntityMergeEngine.getSameAsLinks(entity);
            links.add(entity.getAbout());
            Set<EnrichmentFields> fields = links.stream().map(proxyLinkTypes::get).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toSet());
            EntityMergeEngine.convertAndAddEntity(rdf, entity, fields);
        }
    }

    private static Set<String> getSameAsLinks(EnrichmentBase contextualClass) {
        List result = contextualClass instanceof Agent ? ((Agent)contextualClass).getSameAs() : (contextualClass instanceof Concept ? ((Concept)contextualClass).getExactMatch() : (contextualClass instanceof Place ? ((Place)contextualClass).getSameAs() : (contextualClass instanceof Timespan ? ((Timespan)contextualClass).getSameAs() : null)));
        return Optional.ofNullable(result).orElseGet(Collections::emptyList).stream().filter(Objects::nonNull).map(WebResource::getResourceUri).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
    }
}

