/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.rest.client;

import eu.europeana.enrichment.api.exceptions.UnknownException;
import eu.europeana.enrichment.api.external.InputValueList;
import eu.europeana.enrichment.api.external.model.EnrichmentBase;
import eu.europeana.enrichment.api.external.model.EnrichmentBaseWrapper;
import eu.europeana.enrichment.api.external.model.EnrichmentResultList;
import eu.europeana.enrichment.rest.client.TemporaryResponseConverter;
import eu.europeana.enrichment.utils.InputValue;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.xml.bind.JAXBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class EnrichmentClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnrichmentClient.class);
    private final String endpoint;
    private final RestTemplate template;
    private final int batchSize;

    EnrichmentClient(RestTemplate template, String endpoint, int batchSize) {
        this.template = template;
        this.endpoint = endpoint;
        this.batchSize = batchSize;
    }

    public EnrichmentResultList enrich(List<InputValue> values) {
        InputValueList inList = new InputValueList();
        inList.setInputValues(values);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_XML));
        HttpEntity request = new HttpEntity((Object)inList, (MultiValueMap)headers);
        String url = this.endpoint + "/enrich/input_value_list";
        try {
            return TemporaryResponseConverter.convert((ResponseEntity<byte[]>)this.template.exchange(url, HttpMethod.POST, request, byte[].class, new Object[0]));
        }
        catch (JAXBException | RestClientException e) {
            LOGGER.warn("Enrichment client POST call failed: {}.", (Object)url, (Object)e);
            throw new UnknownException("Enrichment client call failed.", e);
        }
    }

    public EnrichmentBase getByUri(String uri) {
        String encodedUri;
        try {
            encodedUri = URLEncoder.encode(uri, StandardCharsets.UTF_8.name()).replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)(this.endpoint + "/enrich/code_uri_or_owl_same_as")).queryParam("uri", new Object[]{encodedUri});
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_XML);
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_XML));
        HttpEntity request = new HttpEntity((MultiValueMap)headers);
        URI fullUri = builder.build(true).toUri();
        try {
            return TemporaryResponseConverter.convert((ResponseEntity<byte[]>)this.template.exchange(fullUri, HttpMethod.GET, request, byte[].class), EnrichmentBase.class, () -> null);
        }
        catch (JAXBException | RestClientException e) {
            LOGGER.warn("Enrichment client GET call failed: {}.", (Object)fullUri, (Object)e);
            throw new UnknownException("Enrichment client call failed.", e);
        }
    }

    public List<EnrichmentBaseWrapper> getByUri(Collection<String> uriList) {
        return this.performInBatches(input -> {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.setAccept(Collections.singletonList(MediaType.APPLICATION_XML));
            HttpEntity request = new HttpEntity(input, (MultiValueMap)headers);
            String url = this.endpoint + "/enrich/code_uri_or_owl_same_as";
            try {
                return TemporaryResponseConverter.convert((ResponseEntity<byte[]>)this.template.exchange(url, HttpMethod.POST, request, byte[].class, new Object[0]));
            }
            catch (JAXBException | RestClientException e) {
                LOGGER.warn("Enrichment client POST call failed: {}.", (Object)url, (Object)e);
                throw new UnknownException("Enrichment client call failed.", e);
            }
        }, uriList);
    }

    public List<EnrichmentBaseWrapper> getById(Collection<String> uriList) {
        return this.performInBatches(input -> {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.setAccept(Collections.singletonList(MediaType.APPLICATION_XML));
            HttpEntity request = new HttpEntity(input, (MultiValueMap)headers);
            String url = this.endpoint + "/enrich/code_uri";
            try {
                return TemporaryResponseConverter.convert((ResponseEntity<byte[]>)this.template.exchange(url, HttpMethod.POST, request, byte[].class, new Object[0]));
            }
            catch (JAXBException | RestClientException e) {
                LOGGER.warn("Enrichment client POST call failed: {}.", (Object)url, (Object)e);
                throw new UnknownException("Enrichment client call failed.", e);
            }
        }, uriList);
    }

    private List<EnrichmentBaseWrapper> performInBatches(Function<List<String>, EnrichmentResultList> operation, Collection<String> input) {
        ArrayList partitions = new ArrayList();
        partitions.add(new ArrayList());
        input.forEach(item -> {
            ArrayList<String> currentPartition = (ArrayList<String>)partitions.get(partitions.size() - 1);
            if (currentPartition.size() >= this.batchSize) {
                currentPartition = new ArrayList<String>();
                partitions.add(currentPartition);
            }
            currentPartition.add((String)item);
        });
        ArrayList<EnrichmentBaseWrapper> result = new ArrayList<EnrichmentBaseWrapper>();
        partitions.stream().map(operation).filter(Objects::nonNull).map(EnrichmentResultList::getEnrichmentBaseWrapperList).filter(Objects::nonNull).flatMap(Collection::stream).forEach(result::add);
        return result;
    }
}

