/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.utils;

import eu.europeana.enrichment.api.external.model.Agent;
import eu.europeana.enrichment.api.external.model.Concept;
import eu.europeana.enrichment.api.external.model.EnrichmentBase;
import eu.europeana.enrichment.api.external.model.Organization;
import eu.europeana.enrichment.api.external.model.Place;
import eu.europeana.enrichment.api.external.model.TimeSpan;
import eu.europeana.enrichment.api.internal.AggregationFieldType;
import eu.europeana.enrichment.api.internal.FieldType;
import eu.europeana.enrichment.api.internal.ProxyFieldType;
import eu.europeana.enrichment.api.internal.ReferenceTerm;
import eu.europeana.enrichment.api.internal.TermContext;
import eu.europeana.enrichment.rest.client.dereference.DereferencedEntities;
import eu.europeana.enrichment.utils.EntityConverterUtils;
import eu.europeana.enrichment.utils.EntityType;
import eu.europeana.enrichment.utils.RdfEntityUtils;
import eu.europeana.metis.schema.jibx.AboutType;
import eu.europeana.metis.schema.jibx.RDF;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class EntityMergeEngine {
    private static final Map<EntityType, Class<? extends EnrichmentBase>> ENTITY_TYPE_MAP = Map.of(EntityType.AGENT, Agent.class, EntityType.CONCEPT, Concept.class, EntityType.PLACE, Place.class, EntityType.TIMESPAN, TimeSpan.class, EntityType.ORGANIZATION, Organization.class);

    private static <I extends EnrichmentBase, T extends AboutType> T convertAndAddEntity(I inputEntity, Function<I, T> converter, Supplier<List<T>> listGetter, Consumer<List<T>> listSetter) {
        AboutType existingEntity = Optional.ofNullable(listGetter.get()).stream().flatMap(Collection::stream).filter(candidate -> inputEntity.getAbout().equals(candidate.getAbout())).findAny().orElse(null);
        if (existingEntity != null) {
            return (T)existingEntity;
        }
        AboutType convertedEntity = (AboutType)converter.apply(inputEntity);
        if (listGetter.get() == null) {
            listSetter.accept(new ArrayList());
        }
        listGetter.get().add(convertedEntity);
        return (T)convertedEntity;
    }

    public static AboutType convertAndAddEntity(RDF rdf, EnrichmentBase enrichmentBase) {
        EnrichmentBase enrichmentBase2 = enrichmentBase;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Place.class, Agent.class, Concept.class, TimeSpan.class, Organization.class}, (Object)enrichmentBase2, n)) {
            case 0 -> {
                Place place = (Place)enrichmentBase2;
                yield EntityMergeEngine.convertAndAddEntity(place, EntityConverterUtils::convertPlace, () -> ((RDF)rdf).getPlaceList(), arg_0 -> ((RDF)rdf).setPlaceList(arg_0));
            }
            case 1 -> {
                Agent agent = (Agent)enrichmentBase2;
                yield EntityMergeEngine.convertAndAddEntity(agent, EntityConverterUtils::convertAgent, () -> ((RDF)rdf).getAgentList(), arg_0 -> ((RDF)rdf).setAgentList(arg_0));
            }
            case 2 -> {
                Concept concept = (Concept)enrichmentBase2;
                yield EntityMergeEngine.convertAndAddEntity(concept, EntityConverterUtils::convertConcept, () -> ((RDF)rdf).getConceptList(), arg_0 -> ((RDF)rdf).setConceptList(arg_0));
            }
            case 3 -> {
                TimeSpan timeSpan = (TimeSpan)enrichmentBase2;
                yield EntityMergeEngine.convertAndAddEntity(timeSpan, EntityConverterUtils::convertTimeSpan, () -> ((RDF)rdf).getTimeSpanList(), arg_0 -> ((RDF)rdf).setTimeSpanList(arg_0));
            }
            case 4 -> {
                Organization organization = (Organization)enrichmentBase2;
                yield EntityMergeEngine.convertAndAddEntity(organization, EntityConverterUtils::convertOrganization, () -> ((RDF)rdf).getOrganizationList(), arg_0 -> ((RDF)rdf).setOrganizationList(arg_0));
            }
            case -1 -> throw new IllegalArgumentException("Unknown entity type: null.");
            default -> throw new IllegalArgumentException("Unknown entity type: " + String.valueOf(enrichmentBase.getClass()));
        };
    }

    private static Pair<Set<ProxyFieldType>, Set<AggregationFieldType>> filterFieldTypesForLinking(EnrichmentBase entity, Set<FieldType<?>> fields) {
        List<EntityType> entityTypes = ENTITY_TYPE_MAP.entrySet().stream().filter(entry -> ((Class)entry.getValue()).isAssignableFrom(entity.getClass())).map(Map.Entry::getKey).distinct().toList();
        if (entityTypes.size() != 1) {
            throw new IllegalArgumentException("Unknown entity type: " + String.valueOf(entity.getClass()));
        }
        Set result = fields.stream().filter(field -> field.getEntityType() == entityTypes.getFirst()).collect(Collectors.toSet());
        return ImmutablePair.of(result.stream().filter(ProxyFieldType.class::isInstance).map(ProxyFieldType.class::cast).collect(Collectors.toSet()), result.stream().filter(AggregationFieldType.class::isInstance).map(AggregationFieldType.class::cast).collect(Collectors.toSet()));
    }

    public void mergeEntities(RDF rdf, List<EnrichmentBase> enrichmentBaseList, TermContext termContext) {
        for (EnrichmentBase base : enrichmentBaseList) {
            Pair<Set<ProxyFieldType>, Set<AggregationFieldType>> fields = EntityMergeEngine.filterFieldTypesForLinking(base, termContext.getFieldTypes());
            if (((Set)fields.getLeft()).isEmpty() && ((Set)fields.getRight()).isEmpty()) continue;
            AboutType entity = EntityMergeEngine.convertAndAddEntity(rdf, base);
            if (!((Set)fields.getLeft()).isEmpty()) {
                RdfEntityUtils.appendLinkToEuropeanaProxy(rdf, entity.getAbout(), (Set)fields.getLeft());
            }
            if (((Set)fields.getRight()).isEmpty()) continue;
            RdfEntityUtils.replaceValueOfTermInAggregation(rdf, entity.getAbout(), (Set)fields.getRight(), arg_0 -> ((TermContext)termContext).valueEquals(arg_0));
        }
    }

    public void convertAndAddAllEntities(RDF rdf, DereferencedEntities dereferencedEntities) {
        for (Map.Entry<ReferenceTerm, List<EnrichmentBase>> entry : dereferencedEntities.getReferenceTermListMap().entrySet()) {
            entry.getValue().forEach(base -> EntityMergeEngine.convertAndAddEntity(rdf, base));
        }
    }
}

