/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.rest.client.report;

import eu.europeana.enrichment.rest.client.report.Report;
import eu.europeana.enrichment.rest.client.report.Type;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class ProcessedResult<T> {
    private final T processedRecord;
    private HashSet<Report> reports;
    private final RecordStatus recordStatus;

    public ProcessedResult(T processedRecord) {
        this.processedRecord = processedRecord;
        this.reports = new HashSet();
        this.recordStatus = RecordStatus.CONTINUE;
    }

    public ProcessedResult(T processedRecord, Set<Report> reports) {
        this.processedRecord = processedRecord;
        this.reports = (HashSet)reports;
        this.recordStatus = reports.isEmpty() ? RecordStatus.CONTINUE : (reports.stream().anyMatch(reportMessage -> Objects.equals((Object)reportMessage.getMessageType(), (Object)Type.ERROR)) ? RecordStatus.STOP : RecordStatus.CONTINUE);
    }

    public ProcessedResult(ProcessedResult<T> processedResult) {
        this.processedRecord = processedResult.processedRecord;
        this.reports = processedResult.reports;
        this.recordStatus = processedResult.recordStatus;
    }

    public T getProcessedRecord() {
        return this.processedRecord;
    }

    public Set<Report> getReport() {
        return new HashSet<Report>(this.reports);
    }

    public RecordStatus getRecordStatus() {
        if (this.reports.isEmpty()) {
            return RecordStatus.CONTINUE;
        }
        if (this.reports.stream().anyMatch(reportMessage -> Objects.equals((Object)reportMessage.getMessageType(), (Object)Type.ERROR))) {
            return RecordStatus.STOP;
        }
        return RecordStatus.CONTINUE;
    }

    public static enum RecordStatus {
        CONTINUE,
        STOP;

    }
}

