/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.rest.client.enrichment;

import eu.europeana.enrichment.api.internal.AggregationFieldType;
import eu.europeana.enrichment.api.internal.FieldType;
import eu.europeana.enrichment.api.internal.FieldValue;
import eu.europeana.enrichment.api.internal.ProxyFieldType;
import eu.europeana.enrichment.api.internal.RecordParser;
import eu.europeana.enrichment.api.internal.ReferenceTermContext;
import eu.europeana.enrichment.api.internal.SearchTermContext;
import eu.europeana.enrichment.utils.RdfEntityUtils;
import eu.europeana.metis.schema.jibx.AboutType;
import eu.europeana.metis.schema.jibx.AgentType;
import eu.europeana.metis.schema.jibx.Aggregation;
import eu.europeana.metis.schema.jibx.Concept;
import eu.europeana.metis.schema.jibx.ExactMatch;
import eu.europeana.metis.schema.jibx.PlaceType;
import eu.europeana.metis.schema.jibx.ProxyType;
import eu.europeana.metis.schema.jibx.RDF;
import eu.europeana.metis.schema.jibx.ResourceType;
import eu.europeana.metis.schema.jibx.TimeSpanType;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class MetisRecordParser
implements RecordParser {
    public Set<SearchTermContext> parseSearchTerms(RDF rdf) {
        Set<SearchTermContext> resultSearchTermsSet = this.getFieldValueSet((FieldType<T>[])ProxyFieldType.values(), (List)RdfEntityUtils.getProviderProxies(rdf));
        resultSearchTermsSet.addAll(this.getFieldValueSet((FieldType<T>[])AggregationFieldType.values(), rdf.getAggregationList()));
        return resultSearchTermsSet;
    }

    private <T extends AboutType> Set<SearchTermContext> getFieldValueSet(FieldType<T>[] fieldTypes, List<T> aboutTypes) {
        HashMap fieldValueFieldTypesMap = new HashMap();
        for (FieldType fieldType : fieldTypes) {
            aboutTypes.stream().map(arg_0 -> fieldType.extractFieldValuesForEnrichment(arg_0)).flatMap(Collection::stream).forEach(value -> fieldValueFieldTypesMap.computeIfAbsent(value, key -> new HashSet()).add(fieldType));
        }
        return fieldValueFieldTypesMap.entrySet().stream().map(entry -> new SearchTermContext(((FieldValue)entry.getKey()).value(), ((FieldValue)entry.getKey()).language(), (Set)entry.getValue())).collect(Collectors.toSet());
    }

    public Set<ReferenceTermContext> parseReferences(RDF rdf) {
        HashMap directReferences = new HashMap();
        BiConsumer<Set, FieldType> directReferenceCollector = (links, field) -> links.stream().map(link -> directReferences.computeIfAbsent(link, key -> new HashSet())).forEach(fieldTypes -> fieldTypes.add(field));
        List<ProxyType> proxies = Optional.ofNullable(rdf.getProxyList()).stream().flatMap(Collection::stream).filter(Objects::nonNull).toList();
        for (ProxyFieldType field2 : ProxyFieldType.values()) {
            proxies.stream().map(arg_0 -> ((ProxyFieldType)field2).extractFieldLinksForEnrichment(arg_0)).forEach(links -> directReferenceCollector.accept((Set)links, (FieldType)field2));
        }
        Set allEntityIds = Stream.of(rdf.getAgentList(), rdf.getConceptList(), rdf.getOrganizationList(), rdf.getPlaceList(), rdf.getTimeSpanList()).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).map(AboutType::getAbout).filter(Objects::nonNull).collect(Collectors.toSet());
        List<Aggregation> aggregations = Optional.ofNullable(rdf.getAggregationList()).stream().flatMap(Collection::stream).filter(Objects::nonNull).toList();
        for (AggregationFieldType field3 : AggregationFieldType.values()) {
            aggregations.stream().map(arg_0 -> ((AggregationFieldType)field3).extractFieldLinksForEnrichment(arg_0)).peek(link -> link.removeAll(allEntityIds)).forEach(links -> directReferenceCollector.accept((Set)links, (FieldType)field3));
        }
        HashMap indirectReferences = new HashMap();
        Consumer<AboutType> contextualTypeCollector = contextualClass -> {
            Set linkTypes = Optional.ofNullable((Set)directReferences.get(contextualClass.getAbout())).orElseGet(Collections::emptySet);
            if (!linkTypes.isEmpty()) {
                for (String sameAsLink : MetisRecordParser.getSameAsLinks(contextualClass)) {
                    indirectReferences.computeIfAbsent(sameAsLink, key -> new HashSet()).addAll(linkTypes);
                }
            }
        };
        Optional.ofNullable(rdf.getAgentList()).orElseGet(Collections::emptyList).forEach(contextualTypeCollector);
        Optional.ofNullable(rdf.getConceptList()).orElseGet(Collections::emptyList).forEach(contextualTypeCollector);
        Optional.ofNullable(rdf.getPlaceList()).orElseGet(Collections::emptyList).forEach(contextualTypeCollector);
        Optional.ofNullable(rdf.getTimeSpanList()).orElseGet(Collections::emptyList).forEach(contextualTypeCollector);
        Map resultMap = MetisRecordParser.mergeMapInto(directReferences, indirectReferences);
        resultMap.remove(null);
        return resultMap.entrySet().stream().map(entry -> ReferenceTermContext.createFromString((String)((String)entry.getKey()), (Set)((Set)entry.getValue()))).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private static Set<String> getSameAsLinks(AboutType contextualClass) {
        AboutType aboutType = contextualClass;
        Objects.requireNonNull(aboutType);
        AboutType aboutType2 = aboutType;
        int n = 0;
        List<ExactMatch> result = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AgentType.class, Concept.class, PlaceType.class, TimeSpanType.class}, (Object)aboutType2, n)) {
            case 0 -> {
                AgentType agentType = (AgentType)aboutType2;
                yield agentType.getSameAList();
            }
            case 1 -> {
                Concept concept = (Concept)aboutType2;
                yield Optional.ofNullable(concept.getChoiceList()).stream().flatMap(Collection::stream).filter(Objects::nonNull).filter(Concept.Choice::ifExactMatch).map(Concept.Choice::getExactMatch).filter(Objects::nonNull).toList();
            }
            case 2 -> {
                PlaceType placeType = (PlaceType)aboutType2;
                yield placeType.getSameAList();
            }
            case 3 -> {
                TimeSpanType timeSpanType = (TimeSpanType)aboutType2;
                yield timeSpanType.getSameAList();
            }
            default -> null;
        };
        return Optional.ofNullable(result).orElseGet(Collections::emptyList).stream().filter(Objects::nonNull).map(ResourceType::getResource).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
    }

    private static <T, S> Map<T, Set<S>> mergeMapInto(Map<T, Set<S>> map1, Map<T, Set<S>> map2) {
        map2.forEach((key, values) -> map1.merge((Object)key, (Set)values, (values1, values2) -> {
            values1.addAll(values2);
            return values1;
        }));
        return map1;
    }
}

