/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.rest.client.dereference;

import eu.europeana.enrichment.rest.client.ConnectionProvider;
import eu.europeana.enrichment.rest.client.dereference.DereferenceClient;
import eu.europeana.enrichment.rest.client.dereference.Dereferencer;
import eu.europeana.enrichment.rest.client.dereference.DereferencerImpl;
import eu.europeana.enrichment.rest.client.exceptions.DereferenceException;
import eu.europeana.enrichment.utils.EntityMergeEngine;
import eu.europeana.entity.client.config.EntityClientConfiguration;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DereferencerProvider
extends ConnectionProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(DereferencerProvider.class);
    private String dereferenceUrl;
    private String entityManagementUrl;
    private String entityApiUrl;
    private String entityApiTokenEndpoint;
    private String entityApiGrantParams;

    public void setDereferenceUrl(String dereferenceUrl) {
        this.dereferenceUrl = dereferenceUrl;
    }

    public void setEnrichmentPropertiesValues(String entityManagementUrl, String entityApiUrl, String entityApiTokenEndpoint, String entityApiGrantParams) {
        this.entityManagementUrl = entityManagementUrl;
        this.entityApiUrl = entityApiUrl;
        this.entityApiTokenEndpoint = entityApiTokenEndpoint;
        this.entityApiGrantParams = entityApiGrantParams;
    }

    public Dereferencer create() throws DereferenceException {
        EntityClientConfiguration entityClientConfiguration;
        if (StringUtils.isBlank((CharSequence)this.dereferenceUrl) && !this.hasEntityApiClientProperties()) {
            throw new IllegalStateException("Dereferencing must be enabled.");
        }
        if (this.dereferenceUrl == null) {
            LOGGER.warn("Creating dereferencer for Europeana entities only.");
        } else if (!this.hasEntityApiClientProperties()) {
            LOGGER.warn("Creating dereferencer for non-Europeana entities only.");
        } else {
            LOGGER.info("Creating dereferencer for both Europeana and non-Europeana entities.");
        }
        DereferenceClient dereferenceClient = StringUtils.isNotBlank((CharSequence)this.dereferenceUrl) ? new DereferenceClient(this.createRestTemplate(), this.dereferenceUrl) : null;
        if (this.hasEntityApiClientProperties()) {
            Properties properties = DereferencerProvider.buildEntityApiClientProperties(this.entityManagementUrl, this.entityApiUrl, this.entityApiTokenEndpoint, this.entityApiGrantParams);
            entityClientConfiguration = new EntityClientConfiguration(properties);
        } else {
            entityClientConfiguration = null;
        }
        return new DereferencerImpl(new EntityMergeEngine(), entityClientConfiguration, dereferenceClient);
    }

    private boolean hasEntityApiClientProperties() {
        return StringUtils.isNotBlank((CharSequence)this.entityManagementUrl) && StringUtils.isNotBlank((CharSequence)this.entityApiUrl) && StringUtils.isNotBlank((CharSequence)this.entityApiTokenEndpoint) && StringUtils.isNotBlank((CharSequence)this.entityApiGrantParams);
    }
}

