/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.rest.client;

import eu.europeana.enrichment.rest.client.EnrichmentWorker;
import eu.europeana.enrichment.rest.client.dereference.Dereferencer;
import eu.europeana.enrichment.rest.client.enrichment.Enricher;
import eu.europeana.enrichment.rest.client.report.ProcessedResult;
import eu.europeana.enrichment.rest.client.report.Report;
import eu.europeana.metis.schema.convert.RdfConversionUtils;
import eu.europeana.metis.schema.convert.SerializationException;
import eu.europeana.metis.schema.jibx.RDF;
import java.io.InputStream;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnrichmentWorkerImpl
implements EnrichmentWorker {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnrichmentWorkerImpl.class);
    private static final RdfConversionUtils rdfConversionUtils = new RdfConversionUtils();
    private final Enricher enricher;
    private final Dereferencer dereferencer;
    private final Set<EnrichmentWorker.Mode> supportedModes;

    public EnrichmentWorkerImpl(Dereferencer dereferencer, Enricher enricher) {
        this.enricher = enricher;
        this.dereferencer = dereferencer;
        this.supportedModes = EnumSet.noneOf(EnrichmentWorker.Mode.class);
        if (dereferencer != null) {
            this.supportedModes.add(EnrichmentWorker.Mode.DEREFERENCE);
        }
        if (enricher != null) {
            this.supportedModes.add(EnrichmentWorker.Mode.ENRICHMENT);
        }
    }

    @Override
    public Set<EnrichmentWorker.Mode> getSupportedModes() {
        return Collections.unmodifiableSet(this.supportedModes);
    }

    @Override
    public ProcessedResult<byte[]> process(InputStream inputStream) {
        return this.process(inputStream, EnumSet.allOf(EnrichmentWorker.Mode.class));
    }

    @Override
    public ProcessedResult<byte[]> process(InputStream inputStream, Set<EnrichmentWorker.Mode> modes) {
        ProcessedResult<Object> result;
        HashSet<Report> reports = new HashSet<Report>();
        if (inputStream == null) {
            IllegalArgumentException e = new IllegalArgumentException("The input stream cannot be null.");
            reports.add(Report.buildEnrichmentError().withException(e).build());
            result = new ProcessedResult<Object>(null, reports);
        } else {
            try {
                RDF inputRdf = this.convertInputStreamToRdf(inputStream);
                ProcessedResult<byte[]> result2 = new ProcessedResult<byte[]>(this.convertRdfToBytes(this.process(inputRdf, modes)));
                return result2;
            }
            catch (SerializationException e) {
                reports.add(Report.buildEnrichmentError().withMessage("Error serializing rdf input").withException(e).build());
                result = new ProcessedResult<Object>(null, reports);
            }
        }
        return result;
    }

    @Override
    public ProcessedResult<String> process(String inputString) {
        return this.process(inputString, EnumSet.allOf(EnrichmentWorker.Mode.class));
    }

    @Override
    public ProcessedResult<String> process(String inputString, Set<EnrichmentWorker.Mode> modes) {
        ProcessedResult<String> result;
        HashSet<Report> reports = new HashSet<Report>();
        if (inputString == null) {
            IllegalArgumentException e = new IllegalArgumentException("Input RDF string cannot be null.");
            reports.add(Report.buildEnrichmentError().withValue(inputString).withException(e).build());
            result = new ProcessedResult<Object>(null, reports);
        } else {
            try {
                RDF inputRdf = this.convertStringToRdf(inputString);
                result = new ProcessedResult<String>(this.convertRdfToString(this.process(inputRdf, modes)));
            }
            catch (SerializationException e) {
                reports.add(Report.buildEnrichmentError().withMessage("Error serializing rdf input").withValue(inputString).withException(e).build());
                result = new ProcessedResult<Object>(null, reports);
            }
        }
        return result;
    }

    @Override
    public ProcessedResult<RDF> process(RDF inputRdf) {
        return this.process(inputRdf, EnumSet.allOf(EnrichmentWorker.Mode.class));
    }

    @Override
    public ProcessedResult<RDF> process(RDF rdf, Set<EnrichmentWorker.Mode> modes) {
        HashSet<Report> reports = new HashSet<Report>();
        if (rdf == null) {
            return EnrichmentWorkerImpl.illegalArgument("Input RDF cannot be null.", reports);
        }
        if (modes == null) {
            return EnrichmentWorkerImpl.illegalArgument("Set of Modes cannot be null.", reports);
        }
        if (!this.getSupportedModes().containsAll(modes)) {
            return EnrichmentWorkerImpl.illegalArgument("The requested mode(s) is not supported by this instance.", reports);
        }
        LOGGER.info("Received RDF for enrichment/dereferencing. Mode: {}", modes);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Processing RDF:\n{}", (Object)this.convertRdfToStringForLogging(rdf));
        }
        if (modes.contains((Object)EnrichmentWorker.Mode.DEREFERENCE)) {
            LOGGER.debug("Performing dereferencing...");
            reports.addAll(this.dereferencer.dereference(rdf));
            LOGGER.debug("Dereferencing completed.");
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("RDF after dereferencing:\n{}", (Object)this.convertRdfToStringForLogging(rdf));
            }
        }
        if (modes.contains((Object)EnrichmentWorker.Mode.ENRICHMENT)) {
            LOGGER.debug("Performing enrichment...");
            reports.addAll(this.enricher.enrichment(rdf));
            LOGGER.debug("Enrichment completed.");
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("RDF after enrichment:\n{}", (Object)this.convertRdfToStringForLogging(rdf));
            }
        }
        LOGGER.debug("Processing complete.");
        LOGGER.debug("REPORT: {}", reports);
        return new ProcessedResult<RDF>(rdf, reports);
    }

    private static ProcessedResult<RDF> illegalArgument(String s, HashSet<Report> reports) {
        IllegalArgumentException e = new IllegalArgumentException(s);
        reports.add(Report.buildEnrichmentError().withException(e).build());
        return new ProcessedResult<Object>(null, reports);
    }

    @Override
    public void cleanupPreviousEnrichmentEntities(RDF rdf) {
        this.enricher.cleanupPreviousEnrichmentEntities(rdf);
    }

    private String convertRdfToStringForLogging(RDF rdf) {
        try {
            return this.convertRdfToString(rdf);
        }
        catch (SerializationException e) {
            LOGGER.warn("Exception occurred while rendering an RDF document as a String.", (Throwable)e);
            return "[COULD NOT RENDER RDF]";
        }
    }

    String convertRdfToString(RDF rdf) throws SerializationException {
        return rdfConversionUtils.convertRdfToString(rdf);
    }

    ProcessedResult<String> convertRdfToString(ProcessedResult<RDF> rdfProcessedResult) throws SerializationException {
        return new ProcessedResult<Object>((rdfProcessedResult.getProcessedRecord() == null ? null : this.convertRdfToString(rdfProcessedResult.getProcessedRecord())), rdfProcessedResult.getReport());
    }

    ProcessedResult<byte[]> convertRdfToBytes(ProcessedResult<RDF> rdfProcessedResult) throws SerializationException {
        return new ProcessedResult<Object>((rdfProcessedResult.getProcessedRecord() == null ? null : rdfConversionUtils.convertRdfToBytes(rdfProcessedResult.getProcessedRecord())), rdfProcessedResult.getReport());
    }

    RDF convertStringToRdf(String xml) throws SerializationException {
        return rdfConversionUtils.convertStringToRdf(xml);
    }

    RDF convertInputStreamToRdf(InputStream xml) throws SerializationException {
        return rdfConversionUtils.convertInputStreamToRdf(xml);
    }
}

