/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.utils;

import eu.europeana.enrichment.api.external.model.Agent;
import eu.europeana.enrichment.api.external.model.Concept;
import eu.europeana.enrichment.api.external.model.EnrichmentBase;
import eu.europeana.enrichment.api.external.model.Organization;
import eu.europeana.enrichment.api.external.model.Place;
import eu.europeana.enrichment.api.external.model.TimeSpan;
import eu.europeana.enrichment.api.internal.AggregationFieldType;
import eu.europeana.enrichment.api.internal.FieldType;
import eu.europeana.enrichment.api.internal.ProxyFieldType;
import eu.europeana.enrichment.api.internal.ReferenceTerm;
import eu.europeana.enrichment.api.internal.ReferenceTermContext;
import eu.europeana.enrichment.api.internal.SearchTermContext;
import eu.europeana.enrichment.rest.client.dereference.DereferencedEntities;
import eu.europeana.enrichment.utils.EntityConverterUtils;
import eu.europeana.enrichment.utils.RdfEntityUtils;
import eu.europeana.metis.schema.jibx.AboutType;
import eu.europeana.metis.schema.jibx.Aggregation;
import eu.europeana.metis.schema.jibx.RDF;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class EntityMergeEngine {
    private static <I extends EnrichmentBase, T extends AboutType> T convertAndAddEntity(I inputEntity, Function<I, T> converter, Supplier<List<T>> listGetter, Consumer<List<T>> listSetter) {
        AboutType existingEntity = Optional.ofNullable(listGetter.get()).stream().flatMap(Collection::stream).filter(candidate -> inputEntity.getAbout().equals(candidate.getAbout())).findAny().orElse(null);
        if (existingEntity != null) {
            return (T)existingEntity;
        }
        AboutType convertedEntity = (AboutType)converter.apply(inputEntity);
        if (listGetter.get() == null) {
            listSetter.accept(new ArrayList());
        }
        listGetter.get().add(convertedEntity);
        return (T)convertedEntity;
    }

    public static AboutType convertAndAddEntity(RDF rdf, EnrichmentBase enrichmentBase) {
        EnrichmentBase enrichmentBase2 = enrichmentBase;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Place.class, Agent.class, Concept.class, TimeSpan.class, Organization.class}, (Object)enrichmentBase2, n)) {
            case 0 -> {
                Place place = (Place)enrichmentBase2;
                yield EntityMergeEngine.convertAndAddEntity(place, EntityConverterUtils::convertPlace, () -> ((RDF)rdf).getPlaceList(), arg_0 -> ((RDF)rdf).setPlaceList(arg_0));
            }
            case 1 -> {
                Agent agent = (Agent)enrichmentBase2;
                yield EntityMergeEngine.convertAndAddEntity(agent, EntityConverterUtils::convertAgent, () -> ((RDF)rdf).getAgentList(), arg_0 -> ((RDF)rdf).setAgentList(arg_0));
            }
            case 2 -> {
                Concept concept = (Concept)enrichmentBase2;
                yield EntityMergeEngine.convertAndAddEntity(concept, EntityConverterUtils::convertConcept, () -> ((RDF)rdf).getConceptList(), arg_0 -> ((RDF)rdf).setConceptList(arg_0));
            }
            case 3 -> {
                TimeSpan timeSpan = (TimeSpan)enrichmentBase2;
                yield EntityMergeEngine.convertAndAddEntity(timeSpan, EntityConverterUtils::convertTimeSpan, () -> ((RDF)rdf).getTimeSpanList(), arg_0 -> ((RDF)rdf).setTimeSpanList(arg_0));
            }
            case 4 -> {
                Organization organization = (Organization)enrichmentBase2;
                yield EntityMergeEngine.convertAndAddEntity(organization, EntityConverterUtils::convertOrganization, () -> ((RDF)rdf).getOrganizationList(), arg_0 -> ((RDF)rdf).setOrganizationList(arg_0));
            }
            default -> throw new IllegalArgumentException("Unknown entity type: " + String.valueOf(enrichmentBase.getClass()));
        };
    }

    public void mergeSearchEntities(RDF rdf, List<EnrichmentBase> enrichmentBaseList, SearchTermContext searchTermContext) {
        for (EnrichmentBase base : enrichmentBaseList) {
            AboutType aboutType = EntityMergeEngine.convertAndAddEntity(rdf, base);
            if (EntityMergeEngine.isProxyFieldType(searchTermContext.getFieldTypes())) {
                RdfEntityUtils.appendLinkToEuropeanaProxy(rdf, aboutType.getAbout(), searchTermContext.getFieldTypes().stream().map(ProxyFieldType.class::cast).collect(Collectors.toSet()));
                continue;
            }
            RdfEntityUtils.replaceValueWithLinkInAggregation(rdf, aboutType.getAbout(), searchTermContext);
        }
    }

    public void mergeReferenceEntities(RDF rdf, List<EnrichmentBase> enrichmentBaseList, ReferenceTermContext referenceTermContext) {
        for (EnrichmentBase base : enrichmentBaseList) {
            AboutType aboutType = EntityMergeEngine.convertAndAddEntity(rdf, base);
            if (referenceTermContext == null) continue;
            RdfEntityUtils.appendLinkToEuropeanaProxy(rdf, aboutType.getAbout(), referenceTermContext.getProxyFieldTypes().stream().map(ProxyFieldType.class::cast).collect(Collectors.toSet()));
        }
    }

    public void mergeReferenceEntitiesFromDereferencedEntities(RDF rdf, List<DereferencedEntities> dereferencedEntitiesList) {
        for (DereferencedEntities dereferencedEntities : dereferencedEntitiesList) {
            for (Map.Entry<ReferenceTerm, List<EnrichmentBase>> entry : dereferencedEntities.getReferenceTermListMap().entrySet()) {
                List<AboutType> aboutTypeList = entry.getValue().stream().map(base -> EntityMergeEngine.convertAndAddEntity(rdf, base)).toList();
                if (!dereferencedEntities.getClassType().equals(Aggregation.class)) continue;
                RdfEntityUtils.replaceResourceWithLinkInAggregation(rdf, aboutTypeList, entry.getKey());
            }
        }
    }

    private static <T extends FieldType<? extends AboutType>> boolean isProxyFieldType(Set<T> set) {
        if (set == null || set.isEmpty()) {
            throw new IllegalArgumentException("Set cannot be empty");
        }
        boolean allProxyFieldTypes = set.stream().allMatch(ProxyFieldType.class::isInstance);
        boolean allAggregationFieldTypes = set.stream().allMatch(AggregationFieldType.class::isInstance);
        if (!allProxyFieldTypes && !allAggregationFieldTypes) {
            throw new IllegalArgumentException("Invalid set");
        }
        return allProxyFieldTypes;
    }
}

