/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.utils;

import eu.europeana.enrichment.api.internal.AggregationFieldType;
import eu.europeana.enrichment.utils.RdfEntityUtils;
import eu.europeana.metis.schema.jibx.AboutType;
import eu.europeana.metis.schema.jibx.AgentType;
import eu.europeana.metis.schema.jibx.Aggregation;
import eu.europeana.metis.schema.jibx.Concept;
import eu.europeana.metis.schema.jibx.EuropeanaType;
import eu.europeana.metis.schema.jibx.PlaceType;
import eu.europeana.metis.schema.jibx.ProxyType;
import eu.europeana.metis.schema.jibx.RDF;
import eu.europeana.metis.schema.jibx.ResourceOrLiteralType;
import eu.europeana.metis.schema.jibx.ResourceType;
import eu.europeana.metis.schema.jibx.TimeSpanType;
import eu.europeana.metis.schema.jibx.WebResourceType;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public final class DereferenceUtils {
    private static final Function<ResourceType, String> RESOURCE_EXTRACTOR = DereferenceUtils::extractFromResource;
    private static final Function<ResourceOrLiteralType, String> RESOURCE_OR_LITERAL_EXTRACTOR = DereferenceUtils::extractFromResourceOrLiteral;

    private DereferenceUtils() {
    }

    public static Map<Class<? extends AboutType>, Set<String>> extractReferencesForDereferencing(RDF rdf) {
        HashMap<Class<? extends AboutType>, Set<String>> result = new HashMap<Class<? extends AboutType>, Set<String>>();
        DereferenceUtils.extractValues(rdf.getAgentList(), item -> DereferenceUtils.dereferenceAgent(item, result));
        DereferenceUtils.extractValues(rdf.getConceptList(), item -> DereferenceUtils.dereferenceConcept(item, result));
        DereferenceUtils.extractValues(rdf.getPlaceList(), item -> DereferenceUtils.dereferencePlace(item, result));
        DereferenceUtils.extractValues(rdf.getTimeSpanList(), item -> DereferenceUtils.dereferenceTimespan(item, result));
        DereferenceUtils.extractValues(rdf.getWebResourceList(), item -> DereferenceUtils.dereferenceWebResource(item, result));
        DereferenceUtils.extractValues(rdf.getAggregationList(), item -> DereferenceUtils.dereferenceAggregation(item, result));
        DereferenceUtils.extractValues(RdfEntityUtils.getProviderProxies(rdf), item -> DereferenceUtils.dereferenceProxy(item, result));
        result.remove(null);
        Consumer<List> cleaner = list -> Optional.ofNullable(list).map(Collection::stream).orElseGet(Stream::empty).map(AboutType::getAbout).forEach(result::remove);
        cleaner.accept(rdf.getAgentList());
        cleaner.accept(rdf.getConceptList());
        cleaner.accept(rdf.getPlaceList());
        cleaner.accept(rdf.getTimeSpanList());
        return result;
    }

    private static <S> void extractValues(List<S> source, Consumer<S> extractor) {
        if (source != null) {
            for (S sourceItem : source) {
                extractor.accept(sourceItem);
            }
        }
    }

    private static <T> void convertValues(List<? extends T> source, Function<T, String> conversion, Map<Class<? extends AboutType>, Set<String>> result, Class<? extends AboutType> classType) {
        if (source != null) {
            for (T sourceItem : source) {
                DereferenceUtils.convertValue(sourceItem, conversion, result, classType);
            }
        }
    }

    private static <T> void convertValue(T source, Function<T, String> conversion, Map<Class<? extends AboutType>, Set<String>> resultMap, Class<? extends AboutType> classType) {
        String target;
        HashSet<String> result = new HashSet<String>();
        if (source != null && StringUtils.isNotBlank((CharSequence)(target = conversion.apply(source)))) {
            result.add(target);
            resultMap.computeIfPresent(classType, (key, value) -> {
                value.addAll(result);
                return value;
            });
            resultMap.putIfAbsent(classType, result);
        }
    }

    private static <T> void convertValue(boolean proceed, T source, Function<T, String> conversion, Map<Class<? extends AboutType>, Set<String>> result, Class<? extends AboutType> classType) {
        if (proceed) {
            DereferenceUtils.convertValue(source, conversion, result, classType);
        }
    }

    private static void dereferenceProxy(ProxyType proxyType, Map<Class<? extends AboutType>, Set<String>> values) {
        DereferenceUtils.convertValues(proxyType.getHasMetList(), RESOURCE_EXTRACTOR, values, ProxyType.class);
        DereferenceUtils.convertValues(proxyType.getHasTypeList(), RESOURCE_OR_LITERAL_EXTRACTOR, values, ProxyType.class);
        DereferenceUtils.convertValues(proxyType.getIncorporateList(), RESOURCE_EXTRACTOR, values, ProxyType.class);
        DereferenceUtils.convertValues(proxyType.getIsDerivativeOfList(), RESOURCE_EXTRACTOR, values, ProxyType.class);
        DereferenceUtils.convertValues(proxyType.getIsRelatedToList(), RESOURCE_OR_LITERAL_EXTRACTOR, values, ProxyType.class);
        DereferenceUtils.convertValues(proxyType.getIsSimilarToList(), RESOURCE_EXTRACTOR, values, ProxyType.class);
        DereferenceUtils.convertValues(proxyType.getIsSuccessorOfList(), RESOURCE_EXTRACTOR, values, ProxyType.class);
        DereferenceUtils.convertValues(proxyType.getRealizeList(), RESOURCE_EXTRACTOR, values, ProxyType.class);
        DereferenceUtils.convertValue(proxyType.getCurrentLocation(), RESOURCE_OR_LITERAL_EXTRACTOR, values, ProxyType.class);
        DereferenceUtils.extractValues(proxyType.getChoiceList(), item -> DereferenceUtils.dereferenceChoice(item, values));
    }

    private static void dereferenceChoice(EuropeanaType.Choice choice, Map<Class<? extends AboutType>, Set<String>> values) {
        DereferenceUtils.convertValue(choice.ifContributor(), choice.getContributor(), RESOURCE_OR_LITERAL_EXTRACTOR, values, ProxyType.class);
        DereferenceUtils.convertValue(choice.ifCoverage(), choice.getCoverage(), RESOURCE_OR_LITERAL_EXTRACTOR, values, ProxyType.class);
        DereferenceUtils.convertValue(choice.ifCreator(), choice.getCreator(), RESOURCE_OR_LITERAL_EXTRACTOR, values, ProxyType.class);
        DereferenceUtils.convertValue(choice.ifCreated(), choice.getCreated(), RESOURCE_OR_LITERAL_EXTRACTOR, values, ProxyType.class);
        DereferenceUtils.convertValue(choice.ifDate(), choice.getDate(), RESOURCE_OR_LITERAL_EXTRACTOR, values, ProxyType.class);
        DereferenceUtils.convertValue(choice.ifExtent(), choice.getExtent(), RESOURCE_OR_LITERAL_EXTRACTOR, values, ProxyType.class);
        DereferenceUtils.convertValue(choice.ifFormat(), choice.getFormat(), RESOURCE_OR_LITERAL_EXTRACTOR, values, ProxyType.class);
        DereferenceUtils.convertValue(choice.ifHasFormat(), choice.getHasFormat(), RESOURCE_OR_LITERAL_EXTRACTOR, values, ProxyType.class);
        DereferenceUtils.convertValue(choice.ifHasVersion(), choice.getHasVersion(), RESOURCE_OR_LITERAL_EXTRACTOR, values, ProxyType.class);
        DereferenceUtils.convertValue(choice.ifIsFormatOf(), choice.getIsFormatOf(), RESOURCE_OR_LITERAL_EXTRACTOR, values, ProxyType.class);
        DereferenceUtils.convertValue(choice.ifIsReferencedBy(), choice.getIsReferencedBy(), RESOURCE_OR_LITERAL_EXTRACTOR, values, ProxyType.class);
        DereferenceUtils.convertValue(choice.ifIsReplacedBy(), choice.getIsReplacedBy(), RESOURCE_OR_LITERAL_EXTRACTOR, values, ProxyType.class);
        DereferenceUtils.convertValue(choice.ifIsRequiredBy(), choice.getIsRequiredBy(), RESOURCE_OR_LITERAL_EXTRACTOR, values, ProxyType.class);
        DereferenceUtils.convertValue(choice.ifIsVersionOf(), choice.getIsVersionOf(), RESOURCE_OR_LITERAL_EXTRACTOR, values, ProxyType.class);
        DereferenceUtils.convertValue(choice.ifMedium(), choice.getMedium(), RESOURCE_OR_LITERAL_EXTRACTOR, values, ProxyType.class);
        DereferenceUtils.convertValue(choice.ifPublisher(), choice.getPublisher(), RESOURCE_OR_LITERAL_EXTRACTOR, values, ProxyType.class);
        DereferenceUtils.convertValue(choice.ifReferences(), choice.getReferences(), RESOURCE_OR_LITERAL_EXTRACTOR, values, ProxyType.class);
        DereferenceUtils.convertValue(choice.ifRelation(), choice.getRelation(), RESOURCE_OR_LITERAL_EXTRACTOR, values, ProxyType.class);
        DereferenceUtils.convertValue(choice.ifReplaces(), choice.getReplaces(), RESOURCE_OR_LITERAL_EXTRACTOR, values, ProxyType.class);
        DereferenceUtils.convertValue(choice.ifSource(), choice.getSource(), RESOURCE_OR_LITERAL_EXTRACTOR, values, ProxyType.class);
        DereferenceUtils.convertValue(choice.ifSpatial(), choice.getSpatial(), RESOURCE_OR_LITERAL_EXTRACTOR, values, ProxyType.class);
        DereferenceUtils.convertValue(choice.ifSubject(), choice.getSubject(), RESOURCE_OR_LITERAL_EXTRACTOR, values, ProxyType.class);
        DereferenceUtils.convertValue(choice.ifTemporal(), choice.getTemporal(), RESOURCE_OR_LITERAL_EXTRACTOR, values, ProxyType.class);
        DereferenceUtils.convertValue(choice.ifIssued(), choice.getIssued(), RESOURCE_OR_LITERAL_EXTRACTOR, values, ProxyType.class);
        DereferenceUtils.convertValue(choice.ifType(), choice.getType(), RESOURCE_OR_LITERAL_EXTRACTOR, values, ProxyType.class);
    }

    private static void dereferenceTimespan(TimeSpanType timespan, Map<Class<? extends AboutType>, Set<String>> result) {
        DereferenceUtils.convertValues(timespan.getIsPartOfList(), RESOURCE_OR_LITERAL_EXTRACTOR, result, TimeSpanType.class);
    }

    private static void dereferenceAgent(AgentType agent, Map<Class<? extends AboutType>, Set<String>> result) {
        DereferenceUtils.convertValues(agent.getProfessionOrOccupationList(), RESOURCE_OR_LITERAL_EXTRACTOR, result, AgentType.class);
        DereferenceUtils.convertValues(agent.getIsPartOfList(), RESOURCE_OR_LITERAL_EXTRACTOR, result, AgentType.class);
    }

    private static void dereferenceConcept(Concept concept, Map<Class<? extends AboutType>, Set<String>> result) {
        DereferenceUtils.extractValues(concept.getChoiceList(), item -> DereferenceUtils.dereferenceConceptChoice(item, result));
    }

    private static void dereferenceConceptChoice(Concept.Choice choice, Map<Class<? extends AboutType>, Set<String>> result) {
        DereferenceUtils.convertValue(choice.ifBroader(), choice.getBroader(), RESOURCE_EXTRACTOR, result, Concept.class);
    }

    private static void dereferencePlace(PlaceType place, Map<Class<? extends AboutType>, Set<String>> result) {
        DereferenceUtils.convertValues(place.getIsPartOfList(), RESOURCE_OR_LITERAL_EXTRACTOR, result, PlaceType.class);
    }

    private static void dereferenceWebResource(WebResourceType wr, Map<Class<? extends AboutType>, Set<String>> result) {
        DereferenceUtils.convertValues(wr.getCreatedList(), RESOURCE_OR_LITERAL_EXTRACTOR, result, WebResourceType.class);
        DereferenceUtils.convertValues(wr.getExtentList(), RESOURCE_OR_LITERAL_EXTRACTOR, result, WebResourceType.class);
        DereferenceUtils.convertValues(wr.getFormatList(), RESOURCE_OR_LITERAL_EXTRACTOR, result, WebResourceType.class);
        DereferenceUtils.convertValues(wr.getIsFormatOfList(), RESOURCE_OR_LITERAL_EXTRACTOR, result, WebResourceType.class);
        DereferenceUtils.convertValues(wr.getIssuedList(), RESOURCE_OR_LITERAL_EXTRACTOR, result, WebResourceType.class);
    }

    private static void dereferenceAggregation(Aggregation aggregation, Map<Class<? extends AboutType>, Set<String>> result) {
        AggregationFieldType.DATA_PROVIDER.extractFields(aggregation).forEach(item -> DereferenceUtils.convertValue(item, RESOURCE_OR_LITERAL_EXTRACTOR, result, Aggregation.class));
        AggregationFieldType.PROVIDER.extractFields(aggregation).forEach(item -> DereferenceUtils.convertValue(item, RESOURCE_OR_LITERAL_EXTRACTOR, result, Aggregation.class));
        AggregationFieldType.INTERMEDIATE_PROVIDER.extractFields(aggregation).forEach(item -> DereferenceUtils.convertValue(item, RESOURCE_OR_LITERAL_EXTRACTOR, result, Aggregation.class));
    }

    private static String extractFromResourceOrLiteral(ResourceOrLiteralType type) {
        if (type.getResource() != null && StringUtils.isNotEmpty((CharSequence)type.getResource().getResource())) {
            return type.getResource().getResource();
        }
        return null;
    }

    private static String extractFromResource(ResourceType type) {
        if (StringUtils.isNotEmpty((CharSequence)type.getResource())) {
            return type.getResource();
        }
        return null;
    }
}

