/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.rest.client.report;

import eu.europeana.enrichment.rest.client.EnrichmentWorker;
import eu.europeana.enrichment.rest.client.report.Type;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.http.HttpStatus;

public final class Report {
    private static final int MAX_COMPARE_STACK_TRACE = 50;
    private HttpStatus status;
    private EnrichmentWorker.Mode mode;
    private Type messageType;
    private String value = "";
    private String message = "";
    private String stackTrace = "";

    private Report() {
    }

    private Report(Report val) {
        this.status = val.status;
        this.mode = val.mode;
        this.messageType = val.messageType;
        this.value = val.value;
        this.message = val.message;
        this.stackTrace = val.stackTrace;
    }

    public HttpStatus getStatus() {
        return this.status;
    }

    public EnrichmentWorker.Mode getMode() {
        return this.mode;
    }

    public Type getMessageType() {
        return this.messageType;
    }

    public String getValue() {
        return this.value;
    }

    public String getMessage() {
        return this.message;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null) {
            if (this.getClass() != o.getClass()) {
                return false;
            }
            Report that = (Report)o;
            return this.status == that.status && this.mode == that.mode && this.messageType == that.messageType && Objects.equals(this.value, that.value) && Objects.equals(this.message, that.message) && Objects.equals(StringUtils.substring((String)this.stackTrace, (int)1, (int)50), StringUtils.substring((String)that.stackTrace, (int)1, (int)50));
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.mode, this.messageType, this.value, this.message, StringUtils.substring((String)this.stackTrace, (int)1, (int)50)});
    }

    public String toString() {
        return "[" + String.valueOf(this.status) + "," + this.mode.name() + "," + this.messageType.name() + "," + this.value + "," + this.message + "," + this.stackTrace + "]\n";
    }

    public static Report buildEnrichmentIgnore() {
        return new Report().withMode(EnrichmentWorker.Mode.ENRICHMENT).withStatus(HttpStatus.OK).withMessageType(Type.IGNORE);
    }

    public static Report buildEnrichmentWarn() {
        return new Report().withMode(EnrichmentWorker.Mode.ENRICHMENT).withMessageType(Type.WARN);
    }

    public static Report buildEnrichmentError() {
        return new Report().withMode(EnrichmentWorker.Mode.ENRICHMENT).withMessageType(Type.ERROR);
    }

    public static Report buildDereferenceIgnore() {
        return new Report().withMode(EnrichmentWorker.Mode.DEREFERENCE).withStatus(HttpStatus.OK).withMessageType(Type.IGNORE);
    }

    public static Report buildDereferenceWarn() {
        return new Report().withMode(EnrichmentWorker.Mode.DEREFERENCE).withMessageType(Type.WARN);
    }

    public static Report buildDereferenceError() {
        return new Report().withMode(EnrichmentWorker.Mode.DEREFERENCE).withMessageType(Type.ERROR);
    }

    public Report withStatus(HttpStatus val) {
        this.status = val;
        return this;
    }

    public Report withMode(EnrichmentWorker.Mode val) {
        this.mode = val;
        return this;
    }

    public Report withMessageType(Type val) {
        this.messageType = val;
        return this;
    }

    public Report withValue(String val) {
        this.value = val;
        return this;
    }

    public Report withMessage(String val) {
        this.message = val;
        return this;
    }

    public Report withException(Throwable val) {
        this.message = String.join((CharSequence)(this.message == null ? "" : this.message), " ", ExceptionUtils.getMessage((Throwable)val)).trim();
        this.stackTrace = ExceptionUtils.getStackTrace((Throwable)val);
        return this;
    }

    public Report build() {
        return new Report(this);
    }
}

