/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.rest.client.enrichment;

import eu.europeana.enrichment.api.internal.AggregationFieldType;
import eu.europeana.enrichment.api.internal.FieldType;
import eu.europeana.enrichment.api.internal.FieldValue;
import eu.europeana.enrichment.api.internal.ProxyFieldType;
import eu.europeana.enrichment.api.internal.RecordParser;
import eu.europeana.enrichment.api.internal.ReferenceTermContext;
import eu.europeana.enrichment.api.internal.SearchTermContext;
import eu.europeana.enrichment.utils.RdfEntityUtils;
import eu.europeana.metis.schema.jibx.AboutType;
import eu.europeana.metis.schema.jibx.AgentType;
import eu.europeana.metis.schema.jibx.Concept;
import eu.europeana.metis.schema.jibx.ExactMatch;
import eu.europeana.metis.schema.jibx.PlaceType;
import eu.europeana.metis.schema.jibx.ProxyType;
import eu.europeana.metis.schema.jibx.RDF;
import eu.europeana.metis.schema.jibx.ResourceType;
import eu.europeana.metis.schema.jibx.TimeSpanType;
import java.lang.runtime.SwitchBootstraps;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetisRecordParser
implements RecordParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetisRecordParser.class);

    public Set<SearchTermContext> parseSearchTerms(RDF rdf) {
        Set<SearchTermContext> resultSearchTermsSet = this.getFieldValueSet((FieldType<T>[])ProxyFieldType.values(), (List)RdfEntityUtils.getProviderProxies(rdf));
        resultSearchTermsSet.addAll(this.getAggregationSearchTerms(rdf));
        return resultSearchTermsSet;
    }

    public Set<SearchTermContext> getAggregationSearchTerms(RDF rdf) {
        return this.getFieldValueSet((FieldType<T>[])AggregationFieldType.values(), rdf.getAggregationList());
    }

    private <T extends AboutType> Set<SearchTermContext> getFieldValueSet(FieldType<T>[] fieldTypes, List<T> aboutTypes) {
        HashMap fieldValueFieldTypesMap = new HashMap();
        for (FieldType fieldType : fieldTypes) {
            aboutTypes.stream().map(arg_0 -> fieldType.extractFieldValuesForEnrichment(arg_0)).flatMap(Collection::stream).forEach(value -> fieldValueFieldTypesMap.computeIfAbsent(value, key -> new HashSet()).add(fieldType));
        }
        return fieldValueFieldTypesMap.entrySet().stream().map(entry -> new SearchTermContext(((FieldValue)entry.getKey()).value(), ((FieldValue)entry.getKey()).language(), (Set)entry.getValue())).collect(Collectors.toSet());
    }

    public Set<ReferenceTermContext> parseReferences(RDF rdf) {
        List<ProxyType> proxies = Optional.ofNullable(rdf.getProxyList()).stream().flatMap(Collection::stream).filter(Objects::nonNull).toList();
        HashMap<String, Set> directReferences = new HashMap<String, Set>();
        for (ProxyFieldType field : ProxyFieldType.values()) {
            Set directLinks = proxies.stream().map(arg_0 -> ((ProxyFieldType)field).extractFieldLinksForEnrichment(arg_0)).flatMap(Collection::stream).collect(Collectors.toSet());
            for (String directLink : directLinks) {
                directReferences.computeIfAbsent(directLink, key -> new HashSet()).add(field);
            }
        }
        HashMap indirectReferences = new HashMap();
        Consumer<AboutType> contextualTypeProcessor = contextualClass -> {
            Set linkTypes = Optional.ofNullable((Set)directReferences.get(contextualClass.getAbout())).orElseGet(Collections::emptySet);
            if (!linkTypes.isEmpty()) {
                for (String sameAsLink : MetisRecordParser.getSameAsLinks(contextualClass)) {
                    indirectReferences.computeIfAbsent(sameAsLink, key -> new HashSet()).addAll(linkTypes);
                }
            }
        };
        Optional.ofNullable(rdf.getAgentList()).orElseGet(Collections::emptyList).forEach(contextualTypeProcessor);
        Optional.ofNullable(rdf.getConceptList()).orElseGet(Collections::emptyList).forEach(contextualTypeProcessor);
        Optional.ofNullable(rdf.getPlaceList()).orElseGet(Collections::emptyList).forEach(contextualTypeProcessor);
        Optional.ofNullable(rdf.getTimeSpanList()).orElseGet(Collections::emptyList).forEach(contextualTypeProcessor);
        Map resultMap = MetisRecordParser.mergeMapInto(directReferences, indirectReferences);
        resultMap.remove(null);
        HashSet<ReferenceTermContext> result = new HashSet<ReferenceTermContext>();
        for (Map.Entry entry : resultMap.entrySet()) {
            try {
                URI uri = new URI((String)entry.getKey());
                if (!uri.isAbsolute()) {
                    throw new MalformedURLException("URL is not absolute");
                }
                ReferenceTermContext value = new ReferenceTermContext(uri.toURL(), entry.getValue());
                result.add(value);
            }
            catch (IllegalArgumentException | MalformedURLException | URISyntaxException e) {
                LOGGER.debug("Invalid enrichment reference found: {}", entry.getKey());
            }
        }
        return result;
    }

    private static Set<String> getSameAsLinks(AboutType contextualClass) {
        AboutType aboutType = contextualClass;
        Objects.requireNonNull(aboutType);
        AboutType aboutType2 = aboutType;
        int n = 0;
        List<ExactMatch> result = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AgentType.class, Concept.class, PlaceType.class, TimeSpanType.class}, (Object)aboutType2, n)) {
            case 0 -> {
                AgentType agentType = (AgentType)aboutType2;
                yield agentType.getSameAList();
            }
            case 1 -> {
                Concept concept = (Concept)aboutType2;
                yield Optional.ofNullable(concept.getChoiceList()).stream().flatMap(Collection::stream).filter(Objects::nonNull).filter(Concept.Choice::ifExactMatch).map(Concept.Choice::getExactMatch).filter(Objects::nonNull).toList();
            }
            case 2 -> {
                PlaceType placeType = (PlaceType)aboutType2;
                yield placeType.getSameAList();
            }
            case 3 -> {
                TimeSpanType timeSpanType = (TimeSpanType)aboutType2;
                yield timeSpanType.getSameAList();
            }
            default -> null;
        };
        return Optional.ofNullable(result).orElseGet(Collections::emptyList).stream().filter(Objects::nonNull).map(ResourceType::getResource).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
    }

    private static <T, S> Map<T, Set<S>> mergeMapInto(Map<T, Set<S>> map1, Map<T, Set<S>> map2) {
        map2.forEach((key, values) -> map1.merge((Object)key, (Set)values, (values1, values2) -> {
            values1.addAll(values2);
            return values1;
        }));
        return map1;
    }
}

