/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.rest.client.enrichment;

import eu.europeana.enrichment.api.external.model.EnrichmentBase;
import eu.europeana.enrichment.api.internal.AbstractReferenceTerm;
import eu.europeana.enrichment.api.internal.AbstractSearchTerm;
import eu.europeana.enrichment.api.internal.EntityResolver;
import eu.europeana.enrichment.api.internal.FieldType;
import eu.europeana.enrichment.api.internal.ProxyFieldType;
import eu.europeana.enrichment.api.internal.RecordParser;
import eu.europeana.enrichment.api.internal.ReferenceTermContext;
import eu.europeana.enrichment.api.internal.SearchTermContext;
import eu.europeana.enrichment.rest.client.enrichment.Enricher;
import eu.europeana.enrichment.rest.client.report.Report;
import eu.europeana.enrichment.utils.EnrichmentUtils;
import eu.europeana.enrichment.utils.EntityMergeEngine;
import eu.europeana.enrichment.utils.EntityType;
import eu.europeana.enrichment.utils.RdfEntityUtils;
import eu.europeana.metis.schema.jibx.AboutType;
import eu.europeana.metis.schema.jibx.ProxyType;
import eu.europeana.metis.schema.jibx.RDF;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

public class EnricherImpl
implements Enricher {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnricherImpl.class);
    private static final List<HttpStatus> WARNING_STATUSES = Arrays.stream(HttpStatus.values()).filter(httpStatus -> httpStatus.value() >= HttpStatus.MULTIPLE_CHOICES.value() && httpStatus.value() < HttpStatus.INTERNAL_SERVER_ERROR.value()).toList();
    private final RecordParser recordParser;
    private final EntityResolver entityResolver;
    private final EntityMergeEngine entityMergeEngine;

    public EnricherImpl(RecordParser recordParser, EntityResolver entityResolver, EntityMergeEngine entityMergeEngine) {
        this.recordParser = recordParser;
        this.entityResolver = entityResolver;
        this.entityMergeEngine = entityMergeEngine;
    }

    private static HttpStatus containsWarningStatus(String message) {
        for (HttpStatus status : WARNING_STATUSES) {
            if (message == null || !message.contains(status.toString())) continue;
            return status;
        }
        return null;
    }

    @Override
    public Set<Report> enrichment(RDF rdf) {
        HashSet<Report> reports = new HashSet<Report>();
        LOGGER.debug("Extracting values and references from RDF for enrichment...");
        Set searchTerms = this.recordParser.parseSearchTerms(rdf);
        Set references = this.recordParser.parseReferences(rdf);
        LOGGER.debug("Using extracted values and references to gather enrichment information...");
        Pair<Map<SearchTermContext, List<EnrichmentBase>>, Set<Report>> enrichedValues = this.enrichValues(searchTerms);
        Pair<Map<ReferenceTermContext, List<EnrichmentBase>>, Set<Report>> enrichedReferences = this.enrichReferences(references);
        reports.addAll((Collection)enrichedValues.getRight());
        reports.addAll((Collection)enrichedReferences.getRight());
        LOGGER.debug("Merging Enrichment Information...");
        if (enrichedValues.getLeft() != null) {
            for (Map.Entry entry : ((Map)enrichedValues.getLeft()).entrySet()) {
                this.entityMergeEngine.mergeSearchEntities(rdf, (List)entry.getValue(), (SearchTermContext)entry.getKey());
            }
        }
        if (enrichedReferences.getLeft() != null) {
            for (Map.Entry entry : ((Map)enrichedReferences.getLeft()).entrySet()) {
                this.entityMergeEngine.mergeReferenceEntities(rdf, (List)entry.getValue(), (ReferenceTermContext)entry.getKey());
            }
        }
        LOGGER.debug("Setting additional data in the RDF...");
        EnrichmentUtils.setAdditionalData(rdf);
        LOGGER.debug("Enrichment completed.");
        return reports;
    }

    @Override
    public Pair<Map<SearchTermContext, List<EnrichmentBase>>, Set<Report>> enrichValues(Set<SearchTermContext> searchTerms) {
        HashSet<Report> reports = new HashSet<Report>();
        if (CollectionUtils.isEmpty(searchTerms)) {
            reports.add(Report.buildEnrichmentIgnore().withMessage("Empty search terms.").withValue(searchTerms.toString()).build());
            return new ImmutablePair(Collections.emptyMap(), reports);
        }
        try {
            Map enrichedValues = this.entityResolver.resolveByText(Set.copyOf(searchTerms));
            return new ImmutablePair((Object)enrichedValues, this.getSearchTermsReport(searchTerms, enrichedValues));
        }
        catch (RuntimeException runtimeException) {
            reports.add(Report.buildEnrichmentError().withMessage("Error while resolving values by text when enriching values").withValue(searchTerms.stream().map(AbstractSearchTerm::getTextValue).sorted(String::compareToIgnoreCase).collect(Collectors.joining(","))).withException(runtimeException).build());
            return new ImmutablePair(null, reports);
        }
    }

    @Override
    public Pair<Map<ReferenceTermContext, List<EnrichmentBase>>, Set<Report>> enrichReferences(Set<ReferenceTermContext> references) {
        HashSet<Report> reports = new HashSet<Report>();
        if (CollectionUtils.isEmpty(references)) {
            reports.add(Report.buildEnrichmentIgnore().withValue(references.toString()).withMessage("Empty search reference.").build());
            return new ImmutablePair(Collections.emptyMap(), reports);
        }
        try {
            Map enrichedReferences = this.entityResolver.resolveByUri(references);
            return new ImmutablePair((Object)enrichedReferences, this.getSearchReferenceReport(references, enrichedReferences));
        }
        catch (RuntimeException runtimeException) {
            String referenceValue = references.stream().map(AbstractReferenceTerm::getReferenceAsString).sorted(String::compareToIgnoreCase).collect(Collectors.joining(","));
            reports.addAll(this.getWarningsOrErrors(runtimeException, referenceValue));
            return new ImmutablePair(null, reports);
        }
    }

    private Set<Report> getWarningsOrErrors(Throwable exception, String referenceValue) {
        HttpStatus warningStatus;
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)exception);
        HashSet<Report> reports = new HashSet<Report>();
        if (rootCause == null) {
            warningStatus = EnricherImpl.containsWarningStatus(exception.getMessage());
        } else {
            warningStatus = EnricherImpl.containsWarningStatus(rootCause.getMessage());
            if (warningStatus != null) {
                exception = rootCause;
            }
        }
        reports.add(warningStatus == null ? Report.buildEnrichmentError().withMessage("Error while resolving values by uri when enriching references").withValue(referenceValue).withException(exception).build() : Report.buildEnrichmentWarn().withStatus(warningStatus).withValue(referenceValue).withException(exception).build());
        return reports;
    }

    @Override
    public void cleanupPreviousEnrichmentEntities(RDF rdf) {
        ProxyType europeanaProxy = RdfEntityUtils.getEuropeanaProxy(rdf);
        Set<String> matchingLinks = Arrays.stream(ProxyFieldType.values()).map(proxyFieldType -> proxyFieldType.extractFieldLinksForEnrichment(europeanaProxy)).flatMap(Collection::stream).filter(EntityResolver.europeanaLinkPattern.asPredicate().or(EntityResolver.semiumLinkPattern.asPredicate())).collect(Collectors.toSet());
        RdfEntityUtils.removeMatchingEntities(rdf, matchingLinks);
    }

    private HashSet<Report> getSearchTermsReport(Set<SearchTermContext> searchTerms, Map<SearchTermContext, List<EnrichmentBase>> enrichedValues) {
        HashSet<Report> reports = new HashSet<Report>();
        for (SearchTermContext searchTerm : searchTerms) {
            if (this.fieldTypeContainsOrganizationType(searchTerm.getFieldTypes()) && enrichedValues.get(searchTerm).isEmpty()) {
                reports.add(Report.buildEnrichmentWarn().withMessage("Could not find an entity for the given search term with type Organization.").withValue(searchTerm.getTextValue()).build());
                continue;
            }
            if (!enrichedValues.get(searchTerm).isEmpty()) continue;
            reports.add(Report.buildEnrichmentIgnore().withMessage("Could not find an entity for the given search term.").withValue(searchTerm.getTextValue()).build());
        }
        return reports;
    }

    private HashSet<Report> getSearchReferenceReport(Set<ReferenceTermContext> references, Map<ReferenceTermContext, List<EnrichmentBase>> enrichedReferences) {
        HashSet<Report> reports = new HashSet<Report>();
        for (ReferenceTermContext reference : references) {
            if (!enrichedReferences.get(reference).isEmpty()) continue;
            reports.add(Report.buildEnrichmentIgnore().withMessage("Could not find an entity for the given search reference.").withValue(reference.getReferenceAsString()).build());
        }
        return reports;
    }

    private boolean fieldTypeContainsOrganizationType(Set<FieldType<? extends AboutType>> fieldTypes) {
        for (FieldType<? extends AboutType> fieldType : fieldTypes) {
            if (!fieldType.getEntityType().equals((Object)EntityType.ORGANIZATION)) continue;
            return true;
        }
        return false;
    }
}

