/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.rest.client.enrichment;

import eu.europeana.enrichment.api.external.impl.ClientEntityResolver;
import eu.europeana.enrichment.api.internal.EntityResolver;
import eu.europeana.enrichment.api.internal.RecordParser;
import eu.europeana.enrichment.rest.client.ConnectionProvider;
import eu.europeana.enrichment.rest.client.enrichment.Enricher;
import eu.europeana.enrichment.rest.client.enrichment.EnricherImpl;
import eu.europeana.enrichment.rest.client.enrichment.MetisRecordParser;
import eu.europeana.enrichment.rest.client.exceptions.EnrichmentException;
import eu.europeana.enrichment.utils.EntityMergeEngine;
import eu.europeana.entity.client.config.EntityClientConfiguration;
import eu.europeana.entity.client.web.EntityClientApi;
import eu.europeana.entity.client.web.EntityClientApiImpl;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class EnricherProvider
extends ConnectionProvider {
    private RecordParser recordParser;
    private EntityResolverCreator entityResolverCreator;
    private String entityManagementUrl;
    private String entityApiUrl;
    private String entityApiKey;

    public void setRecordParser(RecordParser recordParser) {
        this.recordParser = recordParser;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.setEntityResolverCreator(() -> entityResolver);
    }

    public void setEntityResolverCreator(EntityResolverCreator entityResolverCreator) {
        this.entityResolverCreator = entityResolverCreator;
    }

    public void setEnrichmentPropertiesValues(String entityManagementUrl, String entityApiUrl, String entityApiKey) {
        this.entityManagementUrl = entityManagementUrl;
        this.entityApiUrl = entityApiUrl;
        this.entityApiKey = entityApiKey;
    }

    public Enricher create() throws EnrichmentException {
        EntityResolver entityResolver;
        if (this.entityResolverCreator != null) {
            entityResolver = this.entityResolverCreator.createEntityResolver();
            if (entityResolver == null) {
                throw new EnrichmentException("Entity resolver creator returned a null object.", null);
            }
        } else if (StringUtils.isNotBlank((CharSequence)this.entityManagementUrl) && StringUtils.isNotBlank((CharSequence)this.entityApiUrl) && StringUtils.isNotBlank((CharSequence)this.entityApiKey)) {
            Properties properties = new Properties();
            properties.put("entity.management.url", this.entityManagementUrl);
            properties.put("entity.api.url", this.entityApiUrl);
            properties.put("entity.api.key", this.entityApiKey);
            entityResolver = new ClientEntityResolver((EntityClientApi)new EntityClientApiImpl(new EntityClientConfiguration(properties)), this.batchSizeEnrichment);
        } else {
            throw new EnrichmentException("We must have either a non-null entity resolver creator, or a non-blank enrichment URL.", null);
        }
        return new EnricherImpl(this.recordParser == null ? new MetisRecordParser() : this.recordParser, entityResolver, new EntityMergeEngine());
    }

    @FunctionalInterface
    public static interface EntityResolverCreator {
        public EntityResolver createEntityResolver() throws EnrichmentException;
    }
}

