/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.rest.client.dereference;

import eu.europeana.enrichment.api.external.DereferenceResultStatus;
import eu.europeana.enrichment.api.external.model.EnrichmentBase;
import eu.europeana.enrichment.api.external.model.EnrichmentResultBaseWrapper;
import eu.europeana.enrichment.api.external.model.EnrichmentResultList;
import eu.europeana.enrichment.api.internal.EntityResolver;
import eu.europeana.enrichment.api.internal.ReferenceTerm;
import eu.europeana.enrichment.api.internal.ReferenceTermImpl;
import eu.europeana.enrichment.rest.client.dereference.DereferenceClient;
import eu.europeana.enrichment.rest.client.dereference.DereferencedEntities;
import eu.europeana.enrichment.rest.client.dereference.Dereferencer;
import eu.europeana.enrichment.rest.client.exceptions.DereferenceException;
import eu.europeana.enrichment.rest.client.report.Report;
import eu.europeana.enrichment.utils.DereferenceUtils;
import eu.europeana.enrichment.utils.EntityMergeEngine;
import eu.europeana.metis.network.ExternalRequestUtil;
import eu.europeana.metis.schema.jibx.AboutType;
import eu.europeana.metis.schema.jibx.Aggregation;
import eu.europeana.metis.schema.jibx.RDF;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.client.HttpClientErrorException;

public class DereferencerImpl
implements Dereferencer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DereferencerImpl.class);
    private final EntityMergeEngine entityMergeEngine;
    private final EntityResolver entityResolver;
    private final DereferenceClient dereferenceClient;

    public DereferencerImpl(EntityMergeEngine entityMergeEngine, EntityResolver entityResolver, DereferenceClient dereferenceClient) {
        this.entityMergeEngine = entityMergeEngine;
        this.entityResolver = entityResolver;
        this.dereferenceClient = dereferenceClient;
    }

    private static URL checkIfUrlIsValid(HashSet<Report> reports, String id) {
        try {
            URI uri = new URI(id);
            return new URI(uri.toString()).toURL();
        }
        catch (IllegalArgumentException | MalformedURLException | URISyntaxException e) {
            reports.add(Report.buildDereferenceIgnore().withStatus(HttpStatus.OK).withValue(id).withException(e).build());
            LOGGER.debug("Invalid enrichment reference found: {}", (Object)id);
            return null;
        }
    }

    private static void setDereferenceStatusInReport(String resourceId, HashSet<Report> reports, DereferenceResultStatus resultStatus) {
        if (!resultStatus.equals((Object)DereferenceResultStatus.SUCCESS)) {
            String resultMessage = DereferencerImpl.getResultStatusMessage(resultStatus);
            if (resultStatus.equals((Object)DereferenceResultStatus.FAILURE)) {
                reports.add(Report.buildDereferenceError().withValue(resourceId).withMessage(resultMessage).build());
            } else if (resultStatus.equals((Object)DereferenceResultStatus.INVALID_URL) || resultStatus.equals((Object)DereferenceResultStatus.NO_VOCABULARY_MATCHING) || resultStatus.equals((Object)DereferenceResultStatus.ENTITY_FOUND_XML_XSLT_PRODUCE_NO_CONTEXTUAL_CLASS)) {
                reports.add(Report.buildDereferenceIgnore().withStatus(HttpStatus.OK).withValue(resourceId).withMessage(resultMessage).build());
            } else {
                reports.add(Report.buildDereferenceWarn().withStatus(HttpStatus.OK).withValue(resourceId).withMessage(resultMessage).build());
            }
        }
    }

    @NotNull
    private static String getResultStatusMessage(DereferenceResultStatus resultStatus) {
        return switch (resultStatus) {
            case DereferenceResultStatus.ENTITY_FOUND_XML_XSLT_ERROR -> "Entity was found, applying the XSLT results in an XML error".concat("either because the entity is malformed or the XSLT is malformed).");
            case DereferenceResultStatus.ENTITY_FOUND_XML_XSLT_PRODUCE_NO_CONTEXTUAL_CLASS -> "Entity was found, but the XSLT mapping did not produce a contextual class.";
            case DereferenceResultStatus.INVALID_URL -> "A URL to be dereferenced is invalid.";
            case DereferenceResultStatus.NO_VOCABULARY_MATCHING -> "Could not find a vocabulary matching the URL.";
            case DereferenceResultStatus.UNKNOWN_EUROPEANA_ENTITY -> "Dereferencing or Coreferencing: the europeana entity does not exist.";
            case DereferenceResultStatus.NO_ENTITY_FOR_VOCABULARY -> "Could not find an entity for a known vocabulary.";
            case DereferenceResultStatus.FAILURE -> "Dereference or Coreferencing failed.";
            default -> "";
        };
    }

    @Override
    public Set<Report> dereference(RDF rdf) {
        LOGGER.debug(" Extracting fields from RDF for dereferencing...");
        Map<Class<? extends AboutType>, Set<String>> resourceIds = this.extractReferencesForDereferencing(rdf);
        LOGGER.debug("Using extracted fields to gather enrichment-via-dereferencing information...");
        List<DereferencedEntities> dereferenceInformation = this.dereferenceEntities(resourceIds);
        Set<Report> reports = dereferenceInformation.stream().map(DereferencedEntities::getReportMessages).flatMap(Collection::stream).collect(Collectors.toSet());
        LOGGER.debug("Merging Dereference Information...");
        this.entityMergeEngine.mergeReferenceEntitiesFromDereferencedEntities(rdf, dereferenceInformation);
        LOGGER.debug("Dereference completed.");
        return reports;
    }

    @Override
    public List<DereferencedEntities> dereferenceEntities(Map<Class<? extends AboutType>, Set<String>> resourceIds) {
        if (resourceIds.isEmpty()) {
            return List.of(new DereferencedEntities(Collections.emptyMap(), new HashSet<Report>()));
        }
        TreeMap mappedReferenceTerms = new TreeMap(Comparator.comparing(Class::getName));
        TreeMap<Class<? extends AboutType>, DereferencedEntities> dereferencedResultEntities = new TreeMap<Class<? extends AboutType>, DereferencedEntities>(Comparator.comparing(Class::getName));
        resourceIds.forEach((key, value) -> {
            HashSet<Report> reports = new HashSet<Report>();
            Set<ReferenceTerm> referenceTermSet = this.setUpReferenceTermSet((Set<String>)value, reports);
            mappedReferenceTerms.put((Class)key, referenceTermSet);
            DereferencedEntities dereferencedOwnEntities = this.dereferenceOwnEntities(referenceTermSet, reports, (Class<? extends AboutType>)key);
            dereferencedResultEntities.put((Class<? extends AboutType>)key, dereferencedOwnEntities);
        });
        Set foundOwnEntityIds = dereferencedResultEntities.values().stream().map(DereferencedEntities::getReferenceTermListMap).map(Map::values).flatMap(Collection::stream).flatMap(Collection::stream).map(EnrichmentBase::getAbout).collect(Collectors.toSet());
        for (Map.Entry entry : mappedReferenceTerms.entrySet()) {
            Set<ReferenceTerm> notFoundOwnReferenceTerms = ((Set)entry.getValue()).stream().filter(referenceTerm -> !foundOwnEntityIds.contains(referenceTerm.getReference().toString())).collect(Collectors.toSet());
            if (notFoundOwnReferenceTerms.isEmpty()) continue;
            DereferencedEntities dereferencedEntities = entry.getKey().equals(Aggregation.class) ? this.dereferenceAggregation(notFoundOwnReferenceTerms, entry.getKey()) : this.dereferenceExternalEntity(notFoundOwnReferenceTerms, entry.getKey());
            this.updateDereferencedEntitiesMap(dereferencedResultEntities, entry.getKey(), dereferencedEntities);
        }
        return new ArrayList<DereferencedEntities>(dereferencedResultEntities.values());
    }

    private DereferencedEntities dereferenceAggregation(Set<ReferenceTerm> referenceTerms, Class<? extends AboutType> classType) {
        DereferencedEntities result = this.dereferenceEntitiesWithUri(referenceTerms, new HashSet<Report>(), classType);
        Set<ReferenceTerm> remainingReferences = referenceTerms.stream().filter(referenceTerm -> result.getReferenceTermListMap().get(referenceTerm).isEmpty()).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(remainingReferences)) {
            DereferencedEntities aggregationRemainingDereferencingResult = this.dereferenceExternalEntity(remainingReferences, classType);
            result.getReferenceTermListMap().putAll(aggregationRemainingDereferencingResult.getReferenceTermListMap());
            result.getReportMessages().addAll(aggregationRemainingDereferencingResult.getReportMessages());
        }
        return result;
    }

    @Override
    public Map<Class<? extends AboutType>, Set<String>> extractReferencesForDereferencing(RDF rdf) {
        return DereferenceUtils.extractReferencesForDereferencing(rdf);
    }

    @Override
    public DereferencedEntities dereferenceOwnEntities(Set<ReferenceTerm> resourceIds, HashSet<Report> reports, Class<? extends AboutType> classType) {
        if (this.entityResolver == null) {
            return new DereferencedEntities(Collections.emptyMap(), new HashSet<Report>());
        }
        try {
            HashMap<ReferenceTerm, List<EnrichmentBase>> result = new HashMap<ReferenceTerm, List<EnrichmentBase>>();
            Set ownEntities = resourceIds.stream().filter(id -> EntityResolver.europeanaLinkPattern.matcher(id.getReference().toString()).matches()).collect(Collectors.toSet());
            this.entityResolver.resolveById(ownEntities).forEach((key, value) -> result.put((ReferenceTerm)key, List.of(value)));
            ownEntities.stream().filter(id -> result.get(id) == null || ((List)result.get(id)).isEmpty()).forEach(notFoundOwnId -> {
                DereferencerImpl.setDereferenceStatusInReport(notFoundOwnId.getReference().toString(), reports, DereferenceResultStatus.UNKNOWN_EUROPEANA_ENTITY);
                result.putIfAbsent((ReferenceTerm)notFoundOwnId, Collections.emptyList());
            });
            return new DereferencedEntities(result, reports, classType);
        }
        catch (Exception e) {
            return this.handleDereferencingException(resourceIds, reports, e, classType);
        }
    }

    private DereferencedEntities dereferenceEntitiesWithUri(Set<ReferenceTerm> resourceIds, HashSet<Report> reports, Class<? extends AboutType> classType) {
        if (this.entityResolver == null) {
            return new DereferencedEntities(Collections.emptyMap(), new HashSet<Report>());
        }
        try {
            return new DereferencedEntities(new HashMap<ReferenceTerm, List<EnrichmentBase>>(this.entityResolver.resolveByUri(resourceIds)), reports, classType);
        }
        catch (Exception e) {
            return this.handleDereferencingException(resourceIds, reports, e, classType);
        }
    }

    private DereferencedEntities dereferenceExternalEntity(Set<ReferenceTerm> referenceTerms, Class<? extends AboutType> classType) {
        HashSet<Report> reports = new HashSet<Report>();
        if (this.dereferenceClient == null) {
            return new DereferencedEntities(Collections.emptyMap(), reports, classType);
        }
        HashMap<ReferenceTerm, List<EnrichmentBase>> resultMap = new HashMap<ReferenceTerm, List<EnrichmentBase>>();
        for (ReferenceTerm referenceTerm : referenceTerms) {
            EnrichmentResultList result;
            String resourceId = referenceTerm.getReference().toString();
            try {
                LOGGER.debug("Dereference external entity processing {}", (Object)resourceId);
                result = (EnrichmentResultList)ExternalRequestUtil.retryableExternalRequestForNetworkExceptions(() -> this.dereferenceClient.dereference(resourceId));
                DereferenceResultStatus resultStatus = Optional.ofNullable(result).map(EnrichmentResultList::getEnrichmentBaseResultWrapperList).orElseGet(Collections::emptyList).stream().map(EnrichmentResultBaseWrapper::getDereferenceStatus).filter(Objects::nonNull).findFirst().orElse(DereferenceResultStatus.FAILURE);
                DereferencerImpl.setDereferenceStatusInReport(resourceId, reports, resultStatus);
            }
            catch (HttpClientErrorException.BadRequest e) {
                LOGGER.warn("ResourceId {}, failed", (Object)resourceId, (Object)e);
                reports.add(Report.buildDereferenceWarn().withStatus(HttpStatus.BAD_REQUEST).withValue(resourceId).withException(e).build());
                result = null;
            }
            catch (Exception e) {
                DereferenceException dereferenceException = new DereferenceException("Exception occurred while trying to perform dereferencing.", e);
                reports.add(Report.buildDereferenceError().withValue(resourceId).withException(dereferenceException).build());
                result = null;
            }
            resultMap.put(referenceTerm, Optional.ofNullable(result).map(EnrichmentResultList::getEnrichmentBaseResultWrapperList).orElseGet(Collections::emptyList).stream().map(EnrichmentResultBaseWrapper::getEnrichmentBaseList).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList()));
        }
        return new DereferencedEntities(resultMap, reports, classType);
    }

    private Set<ReferenceTerm> setUpReferenceTermSet(Set<String> resourcesIds, HashSet<Report> reports) {
        return resourcesIds.stream().map(id -> DereferencerImpl.checkIfUrlIsValid(reports, id)).filter(Objects::nonNull).map(validateUrl -> new ReferenceTermImpl(validateUrl, new HashSet())).collect(Collectors.toSet());
    }

    private void updateDereferencedEntitiesMap(TreeMap<Class<? extends AboutType>, DereferencedEntities> mapToUpdate, Class<? extends AboutType> classType, DereferencedEntities elementToUpdateWith) {
        DereferencedEntities foundEntities = mapToUpdate.get(classType);
        foundEntities.getReferenceTermListMap().putAll(elementToUpdateWith.getReferenceTermListMap());
        foundEntities.getReportMessages().addAll(elementToUpdateWith.getReportMessages());
    }

    private DereferencedEntities handleDereferencingException(Set<ReferenceTerm> resourceIds, HashSet<Report> reports, Exception exception, Class<? extends AboutType> classType) {
        DereferenceException dereferenceException = new DereferenceException("Exception occurred while trying to perform dereferencing.", exception);
        reports.add(Report.buildDereferenceWarn().withStatus(HttpStatus.OK).withValue(resourceIds.stream().map(resourceId -> resourceId.getReference().toString()).collect(Collectors.joining(","))).withException(dereferenceException).build());
        return new DereferencedEntities(new HashMap<ReferenceTerm, List<EnrichmentBase>>(), reports, classType);
    }
}

