/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.utils;

import eu.europeana.enrichment.api.internal.AggregationFieldType;
import eu.europeana.enrichment.api.internal.FieldType;
import eu.europeana.enrichment.api.internal.ProxyFieldType;
import eu.europeana.enrichment.api.internal.ReferenceTerm;
import eu.europeana.enrichment.api.internal.SearchTerm;
import eu.europeana.enrichment.api.internal.SearchTermContext;
import eu.europeana.metis.schema.jibx.AboutType;
import eu.europeana.metis.schema.jibx.EuropeanaType;
import eu.europeana.metis.schema.jibx.ProxyType;
import eu.europeana.metis.schema.jibx.RDF;
import eu.europeana.metis.schema.jibx.ResourceOrLiteralType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public final class RdfEntityUtils {
    private RdfEntityUtils() {
    }

    public static void appendLinkToEuropeanaProxy(RDF rdf, String link, Set<ProxyFieldType> linkTypes) {
        Map<ProxyFieldType, Set<String>> allProxyLinksPerType = RdfEntityUtils.getAllProxyLinksPerType(rdf);
        ProxyType europeanaProxy = RdfEntityUtils.getEuropeanaProxy(rdf);
        for (ProxyFieldType linkType : linkTypes) {
            boolean alreadyExists = Optional.ofNullable(allProxyLinksPerType.get(linkType)).orElseGet(Collections::emptySet).contains(link);
            if (alreadyExists) continue;
            List choices = Optional.ofNullable(europeanaProxy.getChoiceList()).orElseGet(ArrayList::new);
            choices.add(linkType.createChoice(link));
            europeanaProxy.setChoiceList(choices);
        }
        RdfEntityUtils.replaceProxy(rdf, europeanaProxy);
    }

    public static void replaceValueWithLinkInAggregation(RDF rdf, String link, SearchTermContext searchTermAggregation) {
        List aggregationList = rdf.getAggregationList();
        for (FieldType aggregationFieldType : searchTermAggregation.getFieldTypes()) {
            aggregationList.stream().flatMap(arg_0 -> ((AggregationFieldType)((AggregationFieldType)aggregationFieldType)).extractFields(arg_0)).filter(resourceOrLiteralType -> RdfEntityUtils.resourceOrLiteralAndSearchTermEquality(resourceOrLiteralType, (SearchTerm)searchTermAggregation)).forEach(resourceOrLiteralType -> {
                ResourceOrLiteralType.Resource resource = new ResourceOrLiteralType.Resource();
                resource.setResource(link);
                resourceOrLiteralType.setResource(resource);
                resourceOrLiteralType.setLang(new ResourceOrLiteralType.Lang());
                resourceOrLiteralType.setString("");
            });
        }
    }

    public static void replaceResourceWithLinkInAggregation(RDF rdf, List<AboutType> listOfAboutTypes, ReferenceTerm referenceTerm) {
        if (CollectionUtils.isNotEmpty(listOfAboutTypes)) {
            List aggregationList = rdf.getAggregationList();
            for (AggregationFieldType aggregationFieldType : AggregationFieldType.values()) {
                aggregationList.stream().flatMap(arg_0 -> ((AggregationFieldType)aggregationFieldType).extractFields(arg_0)).filter(resourceOrLiteralType -> RdfEntityUtils.isResourceEqualToUri(resourceOrLiteralType, referenceTerm.getReference().toString())).forEach(resourceOrLiteralType -> {
                    ResourceOrLiteralType.Resource resource = new ResourceOrLiteralType.Resource();
                    resource.setResource(((AboutType)listOfAboutTypes.get(0)).getAbout());
                    resourceOrLiteralType.setResource(resource);
                });
            }
        }
    }

    private static boolean resourceOrLiteralAndSearchTermEquality(ResourceOrLiteralType resourceOrLiteralType, SearchTerm searchTerm) {
        boolean areEqual = false;
        if (resourceOrLiteralType.getString() != null && resourceOrLiteralType.getString().equals(searchTerm.getTextValue())) {
            if ((resourceOrLiteralType.getLang() == null || StringUtils.isBlank((CharSequence)resourceOrLiteralType.getLang().getLang())) && StringUtils.isBlank((CharSequence)searchTerm.getLanguage())) {
                areEqual = true;
            } else if (resourceOrLiteralType.getLang() != null && resourceOrLiteralType.getLang().getLang() != null) {
                areEqual = resourceOrLiteralType.getLang().getLang().equals(searchTerm.getLanguage());
            }
        }
        return areEqual;
    }

    private static boolean isResourceEqualToUri(ResourceOrLiteralType resourceOrLiteralType, String uri) {
        return resourceOrLiteralType.getResource() != null && resourceOrLiteralType.getResource().getResource().equals(uri);
    }

    private static Map<ProxyFieldType, Set<String>> getAllProxyLinksPerType(RDF rdf) {
        List allChoices = Optional.ofNullable(rdf.getProxyList()).stream().flatMap(Collection::stream).filter(Objects::nonNull).map(EuropeanaType::getChoiceList).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
        EnumMap<ProxyFieldType, Set<String>> result = new EnumMap<ProxyFieldType, Set<String>>(ProxyFieldType.class);
        for (ProxyFieldType linkType : ProxyFieldType.values()) {
            Set links = allChoices.stream().map(arg_0 -> ((ProxyFieldType)linkType).getResourceIfRightChoice(arg_0)).filter(Objects::nonNull).collect(Collectors.toSet());
            if (links.isEmpty()) continue;
            result.put(linkType, links);
        }
        return result;
    }

    public static List<ProxyType> getProviderProxies(RDF rdf) {
        return Optional.ofNullable(rdf.getProxyList()).stream().flatMap(Collection::stream).filter(Objects::nonNull).filter(proxy -> !RdfEntityUtils.isEuropeanaProxy(proxy)).collect(Collectors.toList());
    }

    public static boolean isEuropeanaProxy(ProxyType proxy) {
        return proxy.getEuropeanaProxy() != null && proxy.getEuropeanaProxy().isEuropeanaProxy();
    }

    public static ProxyType getEuropeanaProxy(RDF rdf) {
        return Optional.ofNullable(rdf.getProxyList()).stream().flatMap(Collection::stream).filter(Objects::nonNull).filter(RdfEntityUtils::isEuropeanaProxy).findAny().orElseThrow(() -> new IllegalArgumentException("Could not find Europeana proxy."));
    }

    public static void removeMatchingEntities(RDF rdf, Collection<String> links) {
        RdfEntityUtils.removeEntitiesByType(links, () -> ((RDF)rdf).getAgentList(), arg_0 -> ((RDF)rdf).setAgentList(arg_0));
        RdfEntityUtils.removeEntitiesByType(links, () -> ((RDF)rdf).getConceptList(), arg_0 -> ((RDF)rdf).setConceptList(arg_0));
        RdfEntityUtils.removeEntitiesByType(links, () -> ((RDF)rdf).getPlaceList(), arg_0 -> ((RDF)rdf).setPlaceList(arg_0));
        RdfEntityUtils.removeEntitiesByType(links, () -> ((RDF)rdf).getTimeSpanList(), arg_0 -> ((RDF)rdf).setTimeSpanList(arg_0));
        RdfEntityUtils.removeEntitiesByType(links, () -> ((RDF)rdf).getOrganizationList(), arg_0 -> ((RDF)rdf).setOrganizationList(arg_0));
        ProxyType europeanaProxy = RdfEntityUtils.getEuropeanaProxy(rdf);
        for (String europeanaLink : links) {
            Arrays.stream(ProxyFieldType.values()).forEach(proxyFieldType -> proxyFieldType.removeMatchingFields(europeanaProxy, europeanaLink));
        }
    }

    private static <T extends AboutType> void removeEntitiesByType(Collection<String> links, Supplier<List<T>> listGetter, Consumer<List<T>> listSetter) {
        for (String link : links) {
            List list = Optional.ofNullable(listGetter.get()).orElseGet(Collections::emptyList);
            list.removeIf(item -> item.getAbout().equals(link));
            listSetter.accept(list);
        }
    }

    private static void replaceProxy(RDF rdf, ProxyType europeanaProxy) {
        ArrayList<ProxyType> proxyTypeList = new ArrayList<ProxyType>();
        proxyTypeList.add(europeanaProxy);
        for (ProxyType proxyType : rdf.getProxyList()) {
            if (StringUtils.equals((CharSequence)proxyType.getAbout(), (CharSequence)europeanaProxy.getAbout())) continue;
            proxyTypeList.add(proxyType);
        }
        rdf.setProxyList(proxyTypeList);
    }
}

