/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.rest.client.dereference;

import eu.europeana.enrichment.api.external.impl.ClientEntityResolver;
import eu.europeana.enrichment.api.internal.EntityResolver;
import eu.europeana.enrichment.rest.client.ConnectionProvider;
import eu.europeana.enrichment.rest.client.dereference.DereferenceClient;
import eu.europeana.enrichment.rest.client.dereference.Dereferencer;
import eu.europeana.enrichment.rest.client.dereference.DereferencerImpl;
import eu.europeana.enrichment.rest.client.exceptions.DereferenceException;
import eu.europeana.enrichment.utils.EntityMergeEngine;
import eu.europeana.entity.client.config.EntityClientConfiguration;
import eu.europeana.entity.client.web.EntityClientApi;
import eu.europeana.entity.client.web.EntityClientApiImpl;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DereferencerProvider
extends ConnectionProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(DereferencerProvider.class);
    private String dereferenceUrl;
    private String entityManagementUrl;
    private String entityApiUrl;
    private String entityApiKey;

    public void setDereferenceUrl(String dereferenceUrl) {
        this.dereferenceUrl = dereferenceUrl;
    }

    public void setEnrichmentPropertiesValues(String entityManagementUrl, String entityApiUrl, String entityApiKey) {
        this.entityManagementUrl = entityManagementUrl;
        this.entityApiUrl = entityApiUrl;
        this.entityApiKey = entityApiKey;
    }

    public Dereferencer create() throws DereferenceException {
        ClientEntityResolver entityResolver;
        if (StringUtils.isBlank((CharSequence)this.dereferenceUrl) && StringUtils.isBlank((CharSequence)this.entityManagementUrl) && StringUtils.isBlank((CharSequence)this.entityApiUrl) && StringUtils.isBlank((CharSequence)this.entityApiKey)) {
            throw new IllegalStateException("Dereferencing must be enabled.");
        }
        if (this.dereferenceUrl == null) {
            LOGGER.warn("Creating dereferencer for Europeana entities only.");
        } else if (this.entityManagementUrl == null || this.entityApiUrl == null || this.entityApiKey == null) {
            LOGGER.warn("Creating dereferencer for non-Europeana entities only.");
        } else {
            LOGGER.info("Creating dereferencer for both Europeana and non-Europeana entities.");
        }
        DereferenceClient dereferenceClient = StringUtils.isNotBlank((CharSequence)this.dereferenceUrl) ? new DereferenceClient(this.createRestTemplate(), this.dereferenceUrl) : null;
        if (StringUtils.isNotBlank((CharSequence)this.entityManagementUrl) && StringUtils.isNotBlank((CharSequence)this.entityApiUrl) && StringUtils.isNotBlank((CharSequence)this.entityApiKey)) {
            Properties properties = new Properties();
            properties.put("entity.management.url", this.entityManagementUrl);
            properties.put("entity.api.url", this.entityApiUrl);
            properties.put("entity.api.key", this.entityApiKey);
            entityResolver = new ClientEntityResolver((EntityClientApi)new EntityClientApiImpl(new EntityClientConfiguration(properties)), this.batchSizeEnrichment);
        } else {
            entityResolver = null;
        }
        return new DereferencerImpl(new EntityMergeEngine(), (EntityResolver)entityResolver, dereferenceClient);
    }
}

