/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.utils;

import eu.europeana.enrichment.api.external.model.Agent;
import eu.europeana.enrichment.api.external.model.Concept;
import eu.europeana.enrichment.api.external.model.EnrichmentBase;
import eu.europeana.enrichment.api.external.model.Organization;
import eu.europeana.enrichment.api.external.model.Part;
import eu.europeana.enrichment.api.external.model.Place;
import eu.europeana.enrichment.api.external.model.TimeSpan;
import eu.europeana.enrichment.api.internal.AggregationFieldType;
import eu.europeana.enrichment.api.internal.FieldType;
import eu.europeana.enrichment.api.internal.ProxyFieldType;
import eu.europeana.enrichment.api.internal.ReferenceTerm;
import eu.europeana.enrichment.api.internal.ReferenceTermContext;
import eu.europeana.enrichment.api.internal.SearchTermContext;
import eu.europeana.enrichment.rest.client.dereference.DereferencedEntities;
import eu.europeana.enrichment.utils.ItemExtractorUtils;
import eu.europeana.enrichment.utils.RdfEntityUtils;
import eu.europeana.metis.schema.jibx.AboutType;
import eu.europeana.metis.schema.jibx.AgentType;
import eu.europeana.metis.schema.jibx.Aggregation;
import eu.europeana.metis.schema.jibx.Alt;
import eu.europeana.metis.schema.jibx.AltLabel;
import eu.europeana.metis.schema.jibx.Begin;
import eu.europeana.metis.schema.jibx.BiographicalInformation;
import eu.europeana.metis.schema.jibx.BroadMatch;
import eu.europeana.metis.schema.jibx.Broader;
import eu.europeana.metis.schema.jibx.CloseMatch;
import eu.europeana.metis.schema.jibx.Concept;
import eu.europeana.metis.schema.jibx.Date;
import eu.europeana.metis.schema.jibx.DateOfBirth;
import eu.europeana.metis.schema.jibx.DateOfDeath;
import eu.europeana.metis.schema.jibx.DateOfEstablishment;
import eu.europeana.metis.schema.jibx.DateOfTermination;
import eu.europeana.metis.schema.jibx.End;
import eu.europeana.metis.schema.jibx.ExactMatch;
import eu.europeana.metis.schema.jibx.Gender;
import eu.europeana.metis.schema.jibx.HasMet;
import eu.europeana.metis.schema.jibx.HasPart;
import eu.europeana.metis.schema.jibx.HiddenLabel;
import eu.europeana.metis.schema.jibx.Identifier;
import eu.europeana.metis.schema.jibx.InScheme;
import eu.europeana.metis.schema.jibx.IsNextInSequence;
import eu.europeana.metis.schema.jibx.IsPartOf;
import eu.europeana.metis.schema.jibx.IsRelatedTo;
import eu.europeana.metis.schema.jibx.Lat;
import eu.europeana.metis.schema.jibx.NarrowMatch;
import eu.europeana.metis.schema.jibx.Narrower;
import eu.europeana.metis.schema.jibx.Notation;
import eu.europeana.metis.schema.jibx.Note;
import eu.europeana.metis.schema.jibx.PlaceOfBirth;
import eu.europeana.metis.schema.jibx.PlaceOfDeath;
import eu.europeana.metis.schema.jibx.PlaceType;
import eu.europeana.metis.schema.jibx.PrefLabel;
import eu.europeana.metis.schema.jibx.ProfessionOrOccupation;
import eu.europeana.metis.schema.jibx.RDF;
import eu.europeana.metis.schema.jibx.Related;
import eu.europeana.metis.schema.jibx.RelatedMatch;
import eu.europeana.metis.schema.jibx.SameAs;
import eu.europeana.metis.schema.jibx.TimeSpanType;
import eu.europeana.metis.schema.jibx._Long;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class EntityMergeEngine {
    private static PlaceType convertPlace(Place place) {
        PlaceType placeType = new PlaceType();
        ItemExtractorUtils.setAbout((EnrichmentBase)place, (AboutType)placeType);
        if (place.getAlt() != null) {
            Alt alt = new Alt();
            alt.setAlt(Float.valueOf(place.getAlt()));
            placeType.setAlt(alt);
        }
        placeType.setAltLabelList(ItemExtractorUtils.extractLabels(place.getAltLabelList(), AltLabel::new));
        placeType.setHasPartList(ItemExtractorUtils.extractLabelResources(place.getHasPartsList(), HasPart::new));
        if (place.getIsPartOf() != null) {
            placeType.setIsPartOfList(ItemExtractorUtils.extractLabelResources(place.getIsPartOf(), IsPartOf::new));
        }
        if (place.getLat() != null) {
            Lat lat = new Lat();
            lat.setLat(Float.valueOf(place.getLat()));
            placeType.setLat(lat);
        }
        if (place.getLon() != null) {
            _Long longitude = new _Long();
            longitude.setLong(Float.valueOf(place.getLon()));
            placeType.setLong(longitude);
        }
        placeType.setNoteList(ItemExtractorUtils.extractLabels(place.getNotes(), Note::new));
        placeType.setPrefLabelList(ItemExtractorUtils.extractLabels(place.getPrefLabelList(), PrefLabel::new));
        placeType.setSameAList(ItemExtractorUtils.extractResources(place.getSameAs(), SameAs::new));
        return placeType;
    }

    private static AgentType convertAgent(Agent agent) {
        AgentType agentType = new AgentType();
        ItemExtractorUtils.setAbout((EnrichmentBase)agent, (AboutType)agentType);
        agentType.setAltLabelList(ItemExtractorUtils.extractLabels(agent.getAltLabelList(), AltLabel::new));
        agentType.setBegin(ItemExtractorUtils.extractFirstLabel(agent.getBeginList(), Begin::new));
        agentType.setBiographicalInformationList(ItemExtractorUtils.extractLabelResources(agent.getBiographicalInformation(), BiographicalInformation::new));
        agentType.setProfessionOrOccupationList(ItemExtractorUtils.extractLabelResources(agent.getProfessionOrOccupation(), ProfessionOrOccupation::new));
        agentType.setDateList(ItemExtractorUtils.extractLabelResources(agent.getDate(), Date::new));
        agentType.setPlaceOfBirthList(ItemExtractorUtils.extractLabelResources(agent.getPlaceOfBirth(), PlaceOfBirth::new));
        agentType.setPlaceOfDeathList(ItemExtractorUtils.extractLabelResources(agent.getPlaceOfDeath(), PlaceOfDeath::new));
        agentType.setDateOfBirth(ItemExtractorUtils.extractFirstLabel(agent.getDateOfBirth(), DateOfBirth::new));
        agentType.setDateOfDeath(ItemExtractorUtils.extractFirstLabel(agent.getDateOfDeath(), DateOfDeath::new));
        agentType.setDateOfEstablishment(ItemExtractorUtils.extractFirstLabel(agent.getDateOfEstablishment(), DateOfEstablishment::new));
        agentType.setDateOfTermination(ItemExtractorUtils.extractFirstLabel(agent.getDateOfTermination(), DateOfTermination::new));
        agentType.setEnd(ItemExtractorUtils.extractFirstLabel(agent.getEndList(), End::new));
        agentType.setGender(ItemExtractorUtils.extractFirstLabel(agent.getGender(), Gender::new));
        agentType.setHasMetList(ItemExtractorUtils.extractResources(agent.getHasMet(), HasMet::new));
        agentType.setIdentifierList(ItemExtractorUtils.extractLabels(agent.getIdentifier(), Identifier::new));
        agentType.setIsRelatedToList(ItemExtractorUtils.extractLabelResources(agent.getIsRelatedTo(), IsRelatedTo::new));
        agentType.setNoteList(ItemExtractorUtils.extractLabels(agent.getNotes(), Note::new));
        agentType.setPrefLabelList(ItemExtractorUtils.extractLabels(agent.getPrefLabelList(), PrefLabel::new));
        agentType.setProfessionOrOccupationList(ItemExtractorUtils.extractLabelResources(agent.getProfessionOrOccupation(), ProfessionOrOccupation::new));
        agentType.setSameAList(ItemExtractorUtils.extractResources(agent.getSameAs(), SameAs::new));
        return agentType;
    }

    private static eu.europeana.metis.schema.jibx.Concept convertConcept(Concept baseConcept) {
        eu.europeana.metis.schema.jibx.Concept concept = new eu.europeana.metis.schema.jibx.Concept();
        ItemExtractorUtils.setAbout((EnrichmentBase)baseConcept, (AboutType)concept);
        ArrayList<Concept.Choice> choices = new ArrayList<Concept.Choice>();
        List<AltLabel> altLabels = ItemExtractorUtils.extractLabels(baseConcept.getAltLabelList(), AltLabel::new);
        ItemExtractorUtils.toChoices(altLabels, Concept.Choice::setAltLabel, choices);
        List<BroadMatch> broadMatches = ItemExtractorUtils.extractResources(baseConcept.getBroadMatch(), BroadMatch::new);
        ItemExtractorUtils.toChoices(broadMatches, Concept.Choice::setBroadMatch, choices);
        List<Broader> broaders = ItemExtractorUtils.extractResources(baseConcept.getBroader(), Broader::new);
        ItemExtractorUtils.toChoices(broaders, Concept.Choice::setBroader, choices);
        List<CloseMatch> closeMatches = ItemExtractorUtils.extractResources(baseConcept.getCloseMatch(), CloseMatch::new);
        ItemExtractorUtils.toChoices(closeMatches, Concept.Choice::setCloseMatch, choices);
        List<ExactMatch> exactMatches = ItemExtractorUtils.extractResources(baseConcept.getExactMatch(), ExactMatch::new);
        ItemExtractorUtils.toChoices(exactMatches, Concept.Choice::setExactMatch, choices);
        List<InScheme> inSchemes = ItemExtractorUtils.extractResources(baseConcept.getInScheme(), InScheme::new);
        ItemExtractorUtils.toChoices(inSchemes, Concept.Choice::setInScheme, choices);
        List<Narrower> narrowers = ItemExtractorUtils.extractResources(baseConcept.getNarrower(), Narrower::new);
        ItemExtractorUtils.toChoices(narrowers, Concept.Choice::setNarrower, choices);
        List<NarrowMatch> narrowMatches = ItemExtractorUtils.extractResources(baseConcept.getNarrowMatch(), NarrowMatch::new);
        ItemExtractorUtils.toChoices(narrowMatches, Concept.Choice::setNarrowMatch, choices);
        List<Notation> notations = ItemExtractorUtils.extractLabels(baseConcept.getNotation(), Notation::new);
        ItemExtractorUtils.toChoices(notations, Concept.Choice::setNotation, choices);
        List<Note> notes = ItemExtractorUtils.extractLabels(baseConcept.getNotes(), Note::new);
        ItemExtractorUtils.toChoices(notes, Concept.Choice::setNote, choices);
        List<PrefLabel> prefLabels = ItemExtractorUtils.extractLabels(baseConcept.getPrefLabelList(), PrefLabel::new);
        ItemExtractorUtils.toChoices(prefLabels, Concept.Choice::setPrefLabel, choices);
        List<Related> relateds = ItemExtractorUtils.extractResources(baseConcept.getRelated(), Related::new);
        ItemExtractorUtils.toChoices(relateds, Concept.Choice::setRelated, choices);
        List<RelatedMatch> relatedMatches = ItemExtractorUtils.extractResources(baseConcept.getRelatedMatch(), RelatedMatch::new);
        ItemExtractorUtils.toChoices(relatedMatches, Concept.Choice::setRelatedMatch, choices);
        concept.setChoiceList(choices);
        return concept;
    }

    private static TimeSpanType convertTimeSpan(TimeSpan timespan) {
        TimeSpanType timeSpanType = new TimeSpanType();
        ItemExtractorUtils.setAbout((EnrichmentBase)timespan, (AboutType)timeSpanType);
        timeSpanType.setAltLabelList(ItemExtractorUtils.extractLabels(timespan.getAltLabelList(), AltLabel::new));
        timeSpanType.setBegin(ItemExtractorUtils.extractLabel(timespan.getBegin(), Begin::new));
        timeSpanType.setEnd(ItemExtractorUtils.extractLabel(timespan.getEnd(), End::new));
        timeSpanType.setHasPartList(ItemExtractorUtils.extractLabelResources(timespan.getHasPartsList(), HasPart::new));
        if (timespan.getIsNextInSequence() != null) {
            timeSpanType.setIsNextInSequence(ItemExtractorUtils.extractAsResource(timespan.getIsNextInSequence(), IsNextInSequence::new, Part::getResource));
        }
        if (timespan.getIsPartOf() != null) {
            timeSpanType.setIsPartOfList(ItemExtractorUtils.extractLabelResources(timespan.getIsPartOf(), IsPartOf::new));
        }
        timeSpanType.setNoteList(ItemExtractorUtils.extractLabels(timespan.getNotes(), Note::new));
        timeSpanType.setPrefLabelList(ItemExtractorUtils.extractLabels(timespan.getPrefLabelList(), PrefLabel::new));
        timeSpanType.setSameAList(ItemExtractorUtils.extractResources(timespan.getSameAs(), SameAs::new));
        timeSpanType.setHiddenLabelList(ItemExtractorUtils.extractLabels(timespan.getHiddenLabel(), HiddenLabel::new));
        return timeSpanType;
    }

    private static eu.europeana.metis.schema.jibx.Organization convertOrganization(Organization organization) {
        eu.europeana.metis.schema.jibx.Organization organizationType = new eu.europeana.metis.schema.jibx.Organization();
        organizationType.setAbout(organization.getAbout());
        organizationType.setPrefLabelList(ItemExtractorUtils.extractLabels(organization.getPrefLabelList(), PrefLabel::new));
        return organizationType;
    }

    private static <I extends EnrichmentBase, T extends AboutType> T convertAndAddEntity(I inputEntity, Function<I, T> converter, Supplier<List<T>> listGetter, Consumer<List<T>> listSetter) {
        AboutType existingEntity = Optional.ofNullable(listGetter.get()).stream().flatMap(Collection::stream).filter(candidate -> inputEntity.getAbout().equals(candidate.getAbout())).findAny().orElse(null);
        if (existingEntity != null) {
            return (T)existingEntity;
        }
        AboutType convertedEntity = (AboutType)converter.apply(inputEntity);
        if (listGetter.get() == null) {
            listSetter.accept(new ArrayList());
        }
        listGetter.get().add(convertedEntity);
        return (T)convertedEntity;
    }

    private static AboutType convertAndAddEntity(RDF rdf, EnrichmentBase enrichmentBase) {
        PlaceType entity;
        if (enrichmentBase instanceof Place) {
            entity = EntityMergeEngine.convertAndAddEntity((Place)enrichmentBase, EntityMergeEngine::convertPlace, () -> ((RDF)rdf).getPlaceList(), arg_0 -> ((RDF)rdf).setPlaceList(arg_0));
        } else if (enrichmentBase instanceof Agent) {
            entity = EntityMergeEngine.convertAndAddEntity((Agent)enrichmentBase, EntityMergeEngine::convertAgent, () -> ((RDF)rdf).getAgentList(), arg_0 -> ((RDF)rdf).setAgentList(arg_0));
        } else if (enrichmentBase instanceof Concept) {
            entity = EntityMergeEngine.convertAndAddEntity((Concept)enrichmentBase, EntityMergeEngine::convertConcept, () -> ((RDF)rdf).getConceptList(), arg_0 -> ((RDF)rdf).setConceptList(arg_0));
        } else if (enrichmentBase instanceof TimeSpan) {
            entity = EntityMergeEngine.convertAndAddEntity((TimeSpan)enrichmentBase, EntityMergeEngine::convertTimeSpan, () -> ((RDF)rdf).getTimeSpanList(), arg_0 -> ((RDF)rdf).setTimeSpanList(arg_0));
        } else if (enrichmentBase instanceof Organization) {
            entity = EntityMergeEngine.convertAndAddEntity((Organization)enrichmentBase, EntityMergeEngine::convertOrganization, () -> ((RDF)rdf).getOrganizationList(), arg_0 -> ((RDF)rdf).setOrganizationList(arg_0));
        } else {
            throw new IllegalArgumentException("Unknown entity type: " + enrichmentBase.getClass());
        }
        return entity;
    }

    public void mergeSearchEntities(RDF rdf, List<EnrichmentBase> enrichmentBaseList, SearchTermContext searchTermContext) {
        for (EnrichmentBase base : enrichmentBaseList) {
            AboutType aboutType = EntityMergeEngine.convertAndAddEntity(rdf, base);
            if (EntityMergeEngine.isProxyFieldType(searchTermContext.getFieldTypes())) {
                RdfEntityUtils.appendLinkToEuropeanaProxy(rdf, aboutType.getAbout(), searchTermContext.getFieldTypes().stream().map(ProxyFieldType.class::cast).collect(Collectors.toSet()));
                continue;
            }
            RdfEntityUtils.replaceValueWithLinkInAggregation(rdf, aboutType.getAbout(), searchTermContext);
        }
    }

    public void mergeReferenceEntities(RDF rdf, List<EnrichmentBase> enrichmentBaseList, ReferenceTermContext referenceTermContext) {
        for (EnrichmentBase base : enrichmentBaseList) {
            AboutType aboutType = EntityMergeEngine.convertAndAddEntity(rdf, base);
            if (referenceTermContext == null) continue;
            RdfEntityUtils.appendLinkToEuropeanaProxy(rdf, aboutType.getAbout(), referenceTermContext.getProxyFieldTypes().stream().map(ProxyFieldType.class::cast).collect(Collectors.toSet()));
        }
    }

    public void mergeReferenceEntitiesFromDereferencedEntities(RDF rdf, List<DereferencedEntities> dereferencedEntitiesList) {
        for (DereferencedEntities dereferencedEntities : dereferencedEntitiesList) {
            for (Map.Entry<ReferenceTerm, List<EnrichmentBase>> entry : dereferencedEntities.getReferenceTermListMap().entrySet()) {
                List<AboutType> aboutTypeList = entry.getValue().stream().map(base -> EntityMergeEngine.convertAndAddEntity(rdf, base)).collect(Collectors.toList());
                if (!dereferencedEntities.getClassType().equals(Aggregation.class)) continue;
                RdfEntityUtils.replaceResourceWithLinkInAggregation(rdf, aboutTypeList, entry.getKey());
            }
        }
    }

    private static <T extends FieldType<? extends AboutType>> boolean isProxyFieldType(Set<T> set) {
        if (set == null || set.isEmpty()) {
            throw new IllegalArgumentException("Set cannot be empty");
        }
        boolean allProxyFieldTypes = set.stream().allMatch(ProxyFieldType.class::isInstance);
        boolean allAggregationFieldTypes = set.stream().allMatch(AggregationFieldType.class::isInstance);
        if (!allProxyFieldTypes && !allAggregationFieldTypes) {
            throw new IllegalArgumentException("Invalid set");
        }
        return allProxyFieldTypes;
    }
}

