/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.utils;

import eu.europeana.corelib.definitions.jibx.Contributor;
import eu.europeana.corelib.definitions.jibx.Coverage;
import eu.europeana.corelib.definitions.jibx.Created;
import eu.europeana.corelib.definitions.jibx.Creator;
import eu.europeana.corelib.definitions.jibx.Date;
import eu.europeana.corelib.definitions.jibx.EuropeanaType;
import eu.europeana.corelib.definitions.jibx.Format;
import eu.europeana.corelib.definitions.jibx.Issued;
import eu.europeana.corelib.definitions.jibx.Medium;
import eu.europeana.corelib.definitions.jibx.ProxyType;
import eu.europeana.corelib.definitions.jibx.ResourceOrLiteralType;
import eu.europeana.corelib.definitions.jibx.Spatial;
import eu.europeana.corelib.definitions.jibx.Subject;
import eu.europeana.corelib.definitions.jibx.Temporal;
import eu.europeana.corelib.definitions.jibx.Type;
import eu.europeana.enrichment.utils.EntityClass;
import eu.europeana.enrichment.utils.InputValue;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public enum EnrichmentFields {
    DC_CREATOR(EuropeanaType.Choice::ifCreator, EuropeanaType.Choice::getCreator, EuropeanaType.Choice::setCreator, Creator::new, EntityClass.AGENT),
    DC_CONTRIBUTOR(EuropeanaType.Choice::ifContributor, EuropeanaType.Choice::getContributor, EuropeanaType.Choice::setContributor, Contributor::new, EntityClass.AGENT),
    DC_DATE(EuropeanaType.Choice::ifDate, EuropeanaType.Choice::getDate, EuropeanaType.Choice::setDate, Date::new, EntityClass.TIMESPAN),
    DCTERMS_ISSUED(EuropeanaType.Choice::ifIssued, EuropeanaType.Choice::getIssued, EuropeanaType.Choice::setIssued, Issued::new, EntityClass.TIMESPAN),
    DCTERMS_CREATED(EuropeanaType.Choice::ifCreated, EuropeanaType.Choice::getCreated, EuropeanaType.Choice::setCreated, Created::new, EntityClass.TIMESPAN),
    DC_COVERAGE(EuropeanaType.Choice::ifCoverage, EuropeanaType.Choice::getCoverage, EuropeanaType.Choice::setCoverage, Coverage::new, EntityClass.PLACE),
    DCTERMS_TEMPORAL(EuropeanaType.Choice::ifTemporal, EuropeanaType.Choice::getTemporal, EuropeanaType.Choice::setTemporal, Temporal::new, EntityClass.TIMESPAN),
    DC_TYPE(EuropeanaType.Choice::ifType, EuropeanaType.Choice::getType, EuropeanaType.Choice::setType, Type::new, EntityClass.CONCEPT),
    DCTERMS_SPATIAL(EuropeanaType.Choice::ifSpatial, EuropeanaType.Choice::getSpatial, EuropeanaType.Choice::setSpatial, Spatial::new, EntityClass.PLACE),
    DC_SUBJECT(EuropeanaType.Choice::ifSubject, EuropeanaType.Choice::getSubject, EuropeanaType.Choice::setSubject, Subject::new, EntityClass.CONCEPT),
    DCTERMS_MEDIUM(EuropeanaType.Choice::ifMedium, EuropeanaType.Choice::getMedium, EuropeanaType.Choice::setMedium, Medium::new, EntityClass.CONCEPT),
    DC_FORMAT(EuropeanaType.Choice::ifFormat, EuropeanaType.Choice::getFormat, EuropeanaType.Choice::setFormat, Format::new, EntityClass.CONCEPT);

    private final ChoiceContentHandler<?> choiceContentHandler;
    private final EntityClass entityClass;

    private <T extends ResourceOrLiteralType> EnrichmentFields(Predicate<EuropeanaType.Choice> choiceChecker, Function<EuropeanaType.Choice, T> contentGetter, BiConsumer<EuropeanaType.Choice, T> contentSetter, Supplier<T> contentCreator, EntityClass entityClass) {
        this.choiceContentHandler = new ChoiceContentHandler(choiceChecker, contentGetter, contentSetter, contentCreator);
        this.entityClass = entityClass;
    }

    public final List<InputValue> extractFieldValuesForEnrichment(ProxyType proxy) {
        return this.extractFields(proxy).filter(content -> StringUtils.isNotEmpty((CharSequence)content.getString())).map(this::convert).collect(Collectors.toList());
    }

    public final Set<String> extractFieldLinksForEnrichment(ProxyType proxy) {
        return this.extractFields(proxy).map(ResourceOrLiteralType::getResource).filter(Objects::nonNull).map(ResourceOrLiteralType.Resource::getResource).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
    }

    private Stream<? extends ResourceOrLiteralType> extractFields(ProxyType proxy) {
        return Optional.ofNullable(proxy.getChoiceList()).map(Collection::stream).orElseGet(Stream::empty).filter(((ChoiceContentHandler)this.choiceContentHandler).choiceChecker).map(((ChoiceContentHandler)this.choiceContentHandler).contentGetter).filter(Objects::nonNull);
    }

    private InputValue convert(ResourceOrLiteralType content) {
        String language = content.getLang() == null ? null : content.getLang().getLang();
        return new InputValue(this.name(), content.getString(), language, new EntityClass[]{this.entityClass});
    }

    public final EuropeanaType.Choice createChoice(String about) {
        return this.choiceContentHandler.createChoice(about);
    }

    public final String getResourceIfRightChoice(EuropeanaType.Choice choice) {
        return ((ChoiceContentHandler)this.choiceContentHandler).choiceChecker.test(choice) ? (String)Optional.of(((ChoiceContentHandler)this.choiceContentHandler).contentGetter.apply(choice)).map(ResourceOrLiteralType::getResource).map(ResourceOrLiteralType.Resource::getResource).orElse(null) : null;
    }

    private static final class ChoiceContentHandler<T extends ResourceOrLiteralType> {
        private final Predicate<EuropeanaType.Choice> choiceChecker;
        private final Function<EuropeanaType.Choice, T> contentGetter;
        private final BiConsumer<EuropeanaType.Choice, T> contentSetter;
        private final Supplier<T> contentCreator;

        private ChoiceContentHandler(Predicate<EuropeanaType.Choice> choiceChecker, Function<EuropeanaType.Choice, T> contentGetter, BiConsumer<EuropeanaType.Choice, T> contentSetter, Supplier<T> contentCreator) {
            this.choiceChecker = choiceChecker;
            this.contentGetter = contentGetter;
            this.contentSetter = contentSetter;
            this.contentCreator = contentCreator;
        }

        final EuropeanaType.Choice createChoice(String about) {
            EuropeanaType.Choice choice = new EuropeanaType.Choice();
            ResourceOrLiteralType content = (ResourceOrLiteralType)this.contentCreator.get();
            ResourceOrLiteralType.Resource resource = new ResourceOrLiteralType.Resource();
            resource.setResource(about);
            content.setResource(resource);
            content.setString("");
            this.contentSetter.accept(choice, (EuropeanaType.Choice)content);
            return choice;
        }
    }
}

