/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.rest.client;

import eu.europeana.corelib.definitions.jibx.RDF;
import eu.europeana.enrichment.api.external.model.EnrichmentBase;
import eu.europeana.enrichment.api.external.model.EnrichmentBaseWrapper;
import eu.europeana.enrichment.api.external.model.EnrichmentResultList;
import eu.europeana.enrichment.rest.client.DereferenceClient;
import eu.europeana.enrichment.rest.client.DereferenceOrEnrichException;
import eu.europeana.enrichment.rest.client.EnrichmentClient;
import eu.europeana.enrichment.rest.client.EnrichmentWorker;
import eu.europeana.enrichment.utils.DereferenceUtils;
import eu.europeana.enrichment.utils.EnrichmentFields;
import eu.europeana.enrichment.utils.EnrichmentUtils;
import eu.europeana.enrichment.utils.EntityMergeEngine;
import eu.europeana.enrichment.utils.InputValue;
import eu.europeana.enrichment.utils.RdfConversionUtils;
import eu.europeana.metis.utils.ExternalRequestUtil;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.jibx.runtime.JiBXException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;

public class EnrichmentWorkerImpl
implements EnrichmentWorker {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnrichmentWorkerImpl.class);
    private static final int EXTERNAL_CALL_MAX_RETRIES = 30;
    private static final int EXTERNAL_CALL_PERIOD_BETWEEN_RETRIES_IN_MILLIS = 1000;
    private static final Map<Class<?>, String> mapWithRetrieableExceptions;
    private final EnrichmentClient enrichmentClient;
    private final DereferenceClient dereferenceClient;
    private final EntityMergeEngine entityMergeEngine;
    private Set<EnrichmentWorker.Mode> supportedModes;

    EnrichmentWorkerImpl(DereferenceClient dereferenceClient, EnrichmentClient enrichmentClient, EntityMergeEngine entityMergeEngine) {
        this.dereferenceClient = dereferenceClient;
        this.enrichmentClient = enrichmentClient;
        this.entityMergeEngine = entityMergeEngine;
        this.supportedModes = EnumSet.noneOf(EnrichmentWorker.Mode.class);
        if (dereferenceClient != null) {
            this.supportedModes.add(EnrichmentWorker.Mode.DEREFERENCE_ONLY);
        }
        if (enrichmentClient != null) {
            this.supportedModes.add(EnrichmentWorker.Mode.ENRICHMENT_ONLY);
        }
        if (enrichmentClient != null && dereferenceClient != null) {
            this.supportedModes.add(EnrichmentWorker.Mode.DEREFERENCE_AND_ENRICHMENT);
        }
    }

    @Override
    public Set<EnrichmentWorker.Mode> getSupportedModes() {
        return Collections.unmodifiableSet(this.supportedModes);
    }

    @Override
    public byte[] process(InputStream inputStream) throws DereferenceOrEnrichException {
        return this.process(inputStream, EnrichmentWorker.Mode.DEREFERENCE_AND_ENRICHMENT);
    }

    @Override
    public byte[] process(InputStream inputStream, EnrichmentWorker.Mode mode) throws DereferenceOrEnrichException {
        if (inputStream == null) {
            throw new IllegalArgumentException("The input stream cannot be null.");
        }
        try {
            RDF inputRdf = this.convertInputStreamToRdf(inputStream);
            RDF resultRdf = this.process(inputRdf, mode);
            return this.convertRdfToBytes(resultRdf);
        }
        catch (JiBXException e) {
            throw new DereferenceOrEnrichException("Something went wrong with converting to or from the RDF format.", e);
        }
    }

    @Override
    public String process(String inputString) throws DereferenceOrEnrichException {
        return this.process(inputString, EnrichmentWorker.Mode.DEREFERENCE_AND_ENRICHMENT);
    }

    @Override
    public String process(String inputString, EnrichmentWorker.Mode mode) throws DereferenceOrEnrichException {
        if (inputString == null) {
            throw new IllegalArgumentException("Input RDF string cannot be null.");
        }
        try {
            RDF inputRdf = this.convertStringToRdf(inputString);
            RDF resultRdf = this.process(inputRdf, mode);
            return this.convertRdfToString(resultRdf);
        }
        catch (UnsupportedEncodingException | JiBXException e) {
            throw new DereferenceOrEnrichException("Something went wrong with converting to or from the RDF format.", e);
        }
    }

    @Override
    public RDF process(RDF inputRdf) throws DereferenceOrEnrichException {
        return this.process(inputRdf, EnrichmentWorker.Mode.DEREFERENCE_AND_ENRICHMENT);
    }

    @Override
    public RDF process(RDF rdf, EnrichmentWorker.Mode mode) throws DereferenceOrEnrichException {
        if (rdf == null) {
            throw new IllegalArgumentException("Input RDF cannot be null.");
        }
        if (mode == null) {
            throw new IllegalArgumentException("Mode cannot be null.");
        }
        if (!this.getSupportedModes().contains((Object)mode)) {
            throw new IllegalArgumentException("The requested mode '" + mode.name() + "' is not supported by this instance.");
        }
        LOGGER.info("Received RDF for enrichment/dereferencing. Mode: {}", (Object)mode);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Processing RDF:\n{}", (Object)this.convertRdfToStringForLogging(rdf));
        }
        if (EnrichmentWorker.Mode.DEREFERENCE_AND_ENRICHMENT == mode || EnrichmentWorker.Mode.DEREFERENCE_ONLY == mode) {
            LOGGER.debug("Performing dereferencing...");
            this.performDereferencing(rdf);
            LOGGER.debug("Dereferencing completed.");
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("RDF after dereferencing:\n{}", (Object)this.convertRdfToStringForLogging(rdf));
            }
        }
        if (EnrichmentWorker.Mode.DEREFERENCE_AND_ENRICHMENT == mode || EnrichmentWorker.Mode.ENRICHMENT_ONLY == mode) {
            LOGGER.debug("Performing enrichment...");
            this.performEnrichment(rdf);
            LOGGER.debug("Enrichment completed.");
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("RDF after enrichment:\n{}", (Object)this.convertRdfToStringForLogging(rdf));
            }
        }
        LOGGER.debug("Processing complete.");
        return rdf;
    }

    private String convertRdfToStringForLogging(RDF rdf) {
        try {
            return this.convertRdfToString(rdf);
        }
        catch (UnsupportedEncodingException | JiBXException e) {
            LOGGER.warn("Exception occurred while rendering an RDF document as a String.", e);
            return "[COULD NOT RENDER RDF]";
        }
    }

    private void performEnrichment(RDF rdf) throws DereferenceOrEnrichException {
        LOGGER.debug("Extracting values and references from RDF for enrichment...");
        List<InputValue> valuesForEnrichment = this.extractValuesForEnrichment(rdf);
        Map<String, Set<EnrichmentFields>> referencesForEnrichment = this.extractReferencesForEnrichment(rdf);
        LOGGER.debug("Using extracted values and references to gather enrichment information...");
        EnrichmentResultList valueEnrichmentInformation = this.enrichValues(valuesForEnrichment);
        List<EnrichmentBaseWrapper> referenceEnrichmentInformation = this.enrichReferences(referencesForEnrichment.keySet());
        LOGGER.debug("Merging Enrichment Information...");
        if (valueEnrichmentInformation != null && CollectionUtils.isNotEmpty((Collection)valueEnrichmentInformation.getEnrichmentBaseWrapperList())) {
            this.entityMergeEngine.mergeEntities(rdf, valueEnrichmentInformation.getEnrichmentBaseWrapperList());
        }
        if (!referenceEnrichmentInformation.isEmpty()) {
            List<EnrichmentBase> entities = referenceEnrichmentInformation.stream().map(EnrichmentBaseWrapper::getEnrichmentBase).collect(Collectors.toList());
            this.entityMergeEngine.mergeEntities(rdf, entities, referencesForEnrichment);
        }
        LOGGER.debug("Setting additional data in the RDF...");
        EnrichmentUtils.setAdditionalData(rdf);
        LOGGER.debug("Enrichment completed.");
    }

    private EnrichmentResultList enrichValues(List<InputValue> valuesForEnrichment) throws DereferenceOrEnrichException {
        try {
            return CollectionUtils.isEmpty(valuesForEnrichment) ? null : (EnrichmentResultList)ExternalRequestUtil.retryableExternalRequest(() -> this.enrichmentClient.enrich(valuesForEnrichment), mapWithRetrieableExceptions, (int)30, (int)1000);
        }
        catch (Exception e) {
            throw new DereferenceOrEnrichException("Exception occurred while trying to perform enrichment.", e);
        }
    }

    private List<EnrichmentBaseWrapper> enrichReferences(Set<String> referencesForEnrichment) throws DereferenceOrEnrichException {
        try {
            return CollectionUtils.isEmpty(referencesForEnrichment) ? Collections.emptyList() : (List)ExternalRequestUtil.retryableExternalRequest(() -> this.enrichmentClient.getByUri(referencesForEnrichment), mapWithRetrieableExceptions, (int)30, (int)1000);
        }
        catch (Exception e) {
            throw new DereferenceOrEnrichException("Exception occurred while trying to perform enrichment.", e);
        }
    }

    private void performDereferencing(RDF rdf) throws DereferenceOrEnrichException {
        LOGGER.debug(" Extracting fields from RDF for dereferencing...");
        Set<String> resourceIds = this.extractReferencesForDereferencing(rdf);
        LOGGER.debug("Using extracted fields to gather enrichment-via-dereferencing information...");
        List<EnrichmentBaseWrapper> dereferenceInformation = this.dereferenceFields(resourceIds);
        LOGGER.debug("Merging Dereference Information...");
        this.entityMergeEngine.mergeEntities(rdf, dereferenceInformation);
        LOGGER.debug("Dereference completed.");
    }

    private List<EnrichmentBaseWrapper> dereferenceFields(Set<String> resourceIds) throws DereferenceOrEnrichException {
        if (resourceIds.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<EnrichmentBaseWrapper> result = new ArrayList<EnrichmentBaseWrapper>(this.dereferenceOwnEntities(resourceIds));
        Set foundOwnEntityIds = result.stream().map(EnrichmentBaseWrapper::getEnrichmentBase).map(EnrichmentBase::getAbout).collect(Collectors.toSet());
        for (String resourceId : resourceIds) {
            if (foundOwnEntityIds.contains(resourceId)) continue;
            result.addAll(this.dereferenceExternalEntity(resourceId));
        }
        return result;
    }

    private List<EnrichmentBaseWrapper> dereferenceOwnEntities(Set<String> resourceIds) throws DereferenceOrEnrichException {
        try {
            return (List)ExternalRequestUtil.retryableExternalRequest(() -> this.enrichmentClient.getById(resourceIds), mapWithRetrieableExceptions, (int)30, (int)1000);
        }
        catch (Exception e) {
            throw new DereferenceOrEnrichException("Exception occurred while trying to perform dereferencing.", e);
        }
    }

    private List<EnrichmentBaseWrapper> dereferenceExternalEntity(String resourceId) throws DereferenceOrEnrichException {
        EnrichmentResultList result;
        try {
            LOGGER.debug("== Processing {}", (Object)resourceId);
            result = (EnrichmentResultList)ExternalRequestUtil.retryableExternalRequest(() -> this.dereferenceClient.dereference(resourceId), mapWithRetrieableExceptions, (int)30, (int)1000);
        }
        catch (HttpClientErrorException.BadRequest e) {
            LOGGER.warn("ResourceId {}, failed", (Object)resourceId, (Object)e);
            result = null;
        }
        catch (Exception e) {
            throw new DereferenceOrEnrichException("Exception occurred while trying to perform dereferencing.", e);
        }
        return Optional.ofNullable(result).map(EnrichmentResultList::getEnrichmentBaseWrapperList).orElseGet(Collections::emptyList);
    }

    List<InputValue> extractValuesForEnrichment(RDF rdf) {
        return EnrichmentUtils.extractValuesForEnrichmentFromRDF(rdf);
    }

    Map<String, Set<EnrichmentFields>> extractReferencesForEnrichment(RDF rdf) {
        return EnrichmentUtils.extractReferencesForEnrichmentFromRDF(rdf);
    }

    Set<String> extractReferencesForDereferencing(RDF rdf) {
        return DereferenceUtils.extractReferencesForDereferencing(rdf);
    }

    String convertRdfToString(RDF rdf) throws UnsupportedEncodingException, JiBXException {
        return RdfConversionUtils.convertRdfToString(rdf);
    }

    byte[] convertRdfToBytes(RDF rdf) throws JiBXException {
        return RdfConversionUtils.convertRdfToBytes(rdf);
    }

    RDF convertStringToRdf(String xml) throws JiBXException {
        return RdfConversionUtils.convertStringToRdf(xml);
    }

    RDF convertInputStreamToRdf(InputStream xml) throws JiBXException {
        return RdfConversionUtils.convertInputStreamToRdf(xml);
    }

    static {
        HashMap<Class, String> retriableExceptionMap = new HashMap<Class, String>();
        retriableExceptionMap.put(UnknownHostException.class, "");
        retriableExceptionMap.put(HttpServerErrorException.class, "");
        mapWithRetrieableExceptions = Collections.unmodifiableMap(retriableExceptionMap);
    }
}

