/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.rest.client;

import eu.europeana.enrichment.rest.client.DereferenceClient;
import eu.europeana.enrichment.rest.client.EnrichmentClient;
import eu.europeana.enrichment.rest.client.EnrichmentWorker;
import eu.europeana.enrichment.rest.client.EnrichmentWorkerImpl;
import eu.europeana.enrichment.utils.EntityMergeEngine;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

public class EnrichmentWorkerBuilder {
    public static final int DEFAULT_CONNECT_TIMEOUT = 10000;
    public static final int DEFAULT_RESPONSE_TIMEOUT = 60000;
    public static final int DEFAULT_BATCH_SIZE_ENRICHMENT = 20;
    private String dereferenceUrl = null;
    private String enrichmentUrl = null;
    private int connectTimeout = 10000;
    private int responseTimeout = 60000;
    private int batchSizeEnrichment = 20;

    public EnrichmentWorkerBuilder setDereferenceUrl(String dereferenceUrl) {
        this.dereferenceUrl = dereferenceUrl;
        return this;
    }

    public EnrichmentWorkerBuilder setEnrichmentUrl(String enrichmentUrl) {
        this.enrichmentUrl = enrichmentUrl;
        return this;
    }

    public EnrichmentWorkerBuilder setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public EnrichmentWorkerBuilder setResponseTimeout(int responseTimeout) {
        this.responseTimeout = responseTimeout;
        return this;
    }

    public EnrichmentWorkerBuilder setBatchSizeEnrichment(int batchSizeEnrichment) {
        if (batchSizeEnrichment < 1) {
            throw new IllegalArgumentException("Batch size cannot be 0 or negative.");
        }
        this.batchSizeEnrichment = batchSizeEnrichment;
        return this;
    }

    public EnrichmentWorker build() {
        if (StringUtils.isBlank((CharSequence)this.dereferenceUrl) && StringUtils.isBlank((CharSequence)this.enrichmentUrl)) {
            throw new IllegalStateException("Either dereferencing or enrichment (or both) must be enabled.");
        }
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory();
        requestFactory.setConnectTimeout(Math.max(this.connectTimeout, 0));
        requestFactory.setReadTimeout(Math.max(this.responseTimeout, 0));
        DereferenceClient dereferenceClient = StringUtils.isNotBlank((CharSequence)this.dereferenceUrl) ? new DereferenceClient(new RestTemplate((ClientHttpRequestFactory)requestFactory), this.dereferenceUrl) : null;
        EnrichmentClient enrichmentClient = StringUtils.isNotBlank((CharSequence)this.enrichmentUrl) ? new EnrichmentClient(new RestTemplate((ClientHttpRequestFactory)requestFactory), this.enrichmentUrl, this.batchSizeEnrichment) : null;
        return new EnrichmentWorkerImpl(dereferenceClient, enrichmentClient, new EntityMergeEngine());
    }
}

