/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.rest.client;

import eu.europeana.enrichment.api.exceptions.UnknownException;
import eu.europeana.enrichment.api.external.model.EnrichmentResultList;
import eu.europeana.enrichment.rest.client.TemporaryResponseConverter;
import eu.europeana.metis.dereference.Vocabulary;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class DereferenceClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(DereferenceClient.class);
    private final String hostUrl;
    private final RestTemplate restTemplate;

    DereferenceClient(RestTemplate restTemplate, String hostUrl) {
        this.restTemplate = restTemplate;
        this.hostUrl = hostUrl;
    }

    public List<Vocabulary> getAllVocabularies() {
        return (List)this.restTemplate.getForObject(this.hostUrl + "/vocabularies", List.class, new Object[0]);
    }

    public EnrichmentResultList dereference(String resourceId) {
        URI dereferenceUrl;
        String resourceString;
        try {
            resourceString = URLEncoder.encode(resourceId, StandardCharsets.UTF_8.name()).replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
        if (!resourceString.startsWith("http") && !resourceString.startsWith("https")) {
            return null;
        }
        String dereferenceUrlString = this.hostUrl + "/dereference" + "?uri=" + resourceString;
        try {
            dereferenceUrl = new URI(this.hostUrl + "/dereference" + "?uri=" + resourceString);
        }
        catch (URISyntaxException e) {
            LOGGER.warn("URL [" + dereferenceUrlString + "] is not valid.", (Throwable)e);
            return null;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_XML));
        HttpEntity entity = new HttpEntity((Object)"parameters", (MultiValueMap)headers);
        ResponseEntity result = this.restTemplate.exchange(dereferenceUrl, HttpMethod.GET, entity, byte[].class);
        try {
            return TemporaryResponseConverter.convert((ResponseEntity<byte[]>)result);
        }
        catch (JAXBException e) {
            LOGGER.warn("URL [{}] could not be deserialized.", (Object)dereferenceUrlString, (Object)e);
            throw new UnknownException("Dereference client call failed.", (Throwable)e);
        }
    }
}

