/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.utils;

import eu.europeana.corelib.definitions.jibx.EuropeanaType;
import eu.europeana.corelib.definitions.jibx.ProxyType;
import eu.europeana.corelib.definitions.jibx.RDF;
import eu.europeana.enrichment.utils.EnrichmentFields;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public final class RdfProxyUtils {
    private RdfProxyUtils() {
    }

    public static void appendLinkToEuropeanaProxy(RDF rdf, String link, Set<EnrichmentFields> linkTypes) {
        Map<EnrichmentFields, Set<String>> allProxyLinksPerType = RdfProxyUtils.getAllProxyLinksPerType(rdf);
        ProxyType europeanaProxy = RdfProxyUtils.getEuropeanaProxy(rdf);
        for (EnrichmentFields linkType : linkTypes) {
            boolean alreadyExists = Optional.ofNullable(allProxyLinksPerType.get((Object)linkType)).orElseGet(Collections::emptySet).contains(link);
            if (alreadyExists) continue;
            List choices = Optional.ofNullable(europeanaProxy.getChoiceList()).orElseGet(ArrayList::new);
            choices.add(linkType.createChoice(link));
            europeanaProxy.setChoiceList(choices);
        }
        RdfProxyUtils.replaceProxy(rdf, europeanaProxy);
    }

    private static Map<EnrichmentFields, Set<String>> getAllProxyLinksPerType(RDF rdf) {
        List allChoices = Optional.ofNullable(rdf.getProxyList()).map(Collection::stream).orElseGet(Stream::empty).filter(Objects::nonNull).map(EuropeanaType::getChoiceList).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
        EnumMap<EnrichmentFields, Set<String>> result = new EnumMap<EnrichmentFields, Set<String>>(EnrichmentFields.class);
        for (EnrichmentFields linkType : EnrichmentFields.values()) {
            Set links = allChoices.stream().map(linkType::getResourceIfRightChoice).filter(Objects::nonNull).collect(Collectors.toSet());
            if (links.isEmpty()) continue;
            result.put(linkType, links);
        }
        return result;
    }

    public static ProxyType getProviderProxy(RDF rdf) {
        for (ProxyType proxyType : rdf.getProxyList()) {
            if (proxyType.getEuropeanaProxy() != null && proxyType.getEuropeanaProxy().isEuropeanaProxy()) continue;
            return proxyType;
        }
        throw new IllegalArgumentException("Could not find provider proxy.");
    }

    private static ProxyType getEuropeanaProxy(RDF rdf) {
        for (ProxyType proxyType : rdf.getProxyList()) {
            if (proxyType.getEuropeanaProxy() == null || !proxyType.getEuropeanaProxy().isEuropeanaProxy()) continue;
            return proxyType;
        }
        throw new IllegalArgumentException("Could not find Europeana proxy.");
    }

    private static void replaceProxy(RDF rdf, ProxyType europeanaProxy) {
        ArrayList<ProxyType> proxyTypeList = new ArrayList<ProxyType>();
        proxyTypeList.add(europeanaProxy);
        for (ProxyType proxyType : rdf.getProxyList()) {
            if (StringUtils.equals((CharSequence)proxyType.getAbout(), (CharSequence)europeanaProxy.getAbout())) continue;
            proxyTypeList.add(proxyType);
        }
        rdf.setProxyList(proxyTypeList);
    }
}

