/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.utils;

import eu.europeana.corelib.definitions.jibx.AboutType;
import eu.europeana.corelib.definitions.jibx.AgentType;
import eu.europeana.corelib.definitions.jibx.Aggregation;
import eu.europeana.corelib.definitions.jibx.Completeness;
import eu.europeana.corelib.definitions.jibx.Concept;
import eu.europeana.corelib.definitions.jibx.EuropeanaAggregationType;
import eu.europeana.corelib.definitions.jibx.EuropeanaType;
import eu.europeana.corelib.definitions.jibx.LiteralType;
import eu.europeana.corelib.definitions.jibx.PlaceType;
import eu.europeana.corelib.definitions.jibx.ProxyType;
import eu.europeana.corelib.definitions.jibx.RDF;
import eu.europeana.corelib.definitions.jibx.ResourceOrLiteralType;
import eu.europeana.corelib.definitions.jibx.ResourceType;
import eu.europeana.corelib.definitions.jibx.TimeSpanType;
import eu.europeana.corelib.definitions.jibx.Year;
import eu.europeana.enrichment.utils.EnrichmentFields;
import eu.europeana.enrichment.utils.InputValue;
import eu.europeana.enrichment.utils.RdfProxyUtils;
import eu.europeana.enrichment.utils.YearParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public final class EnrichmentUtils {
    private static final int MIN_WORD_LENGTH = 3;
    private static final int POINT_DIVIDER_FOR_TAGS = 1;
    private static final int POINT_DIVIDER_FOR_TEXTS = 5;
    private static final int POINTS_UPPER_CAP = 5;

    private EnrichmentUtils() {
    }

    public static List<InputValue> extractValuesForEnrichmentFromRDF(RDF rdf) {
        ProxyType providerProxy = RdfProxyUtils.getProviderProxy(rdf);
        ArrayList<InputValue> valuesForEnrichment = new ArrayList<InputValue>();
        for (EnrichmentFields field : EnrichmentFields.values()) {
            List<InputValue> values = field.extractFieldValuesForEnrichment(providerProxy);
            valuesForEnrichment.addAll(values);
        }
        return valuesForEnrichment;
    }

    public static Map<String, Set<EnrichmentFields>> extractReferencesForEnrichmentFromRDF(RDF rdf) {
        List proxies = Optional.ofNullable(rdf.getProxyList()).map(Collection::stream).orElseGet(Stream::empty).filter(Objects::nonNull).collect(Collectors.toList());
        HashMap<String, Set> directReferences = new HashMap<String, Set>();
        for (EnrichmentFields field : EnrichmentFields.values()) {
            Set directLinks = proxies.stream().map(field::extractFieldLinksForEnrichment).flatMap(Collection::stream).collect(Collectors.toSet());
            for (String directLink : directLinks) {
                directReferences.computeIfAbsent(directLink, key -> EnumSet.noneOf(EnrichmentFields.class)).add(field);
            }
        }
        HashMap indirectReferences = new HashMap();
        Consumer<AboutType> contextualTypeProcessor = contextualClass -> {
            Set linkTypes = (Set)directReferences.get(contextualClass.getAbout());
            if (linkTypes != null) {
                for (String sameAsLink : EnrichmentUtils.getSameAsLinks(contextualClass)) {
                    indirectReferences.computeIfAbsent(sameAsLink, key -> EnumSet.noneOf(EnrichmentFields.class)).addAll(linkTypes);
                }
            }
        };
        Optional.ofNullable(rdf.getAgentList()).orElseGet(Collections::emptyList).forEach(contextualTypeProcessor);
        Optional.ofNullable(rdf.getConceptList()).orElseGet(Collections::emptyList).forEach(contextualTypeProcessor);
        Optional.ofNullable(rdf.getPlaceList()).orElseGet(Collections::emptyList).forEach(contextualTypeProcessor);
        Optional.ofNullable(rdf.getTimeSpanList()).orElseGet(Collections::emptyList).forEach(contextualTypeProcessor);
        Map<String, Set<EnrichmentFields>> result = EnrichmentUtils.mergeMapInto(directReferences, indirectReferences);
        result.remove(null);
        return result;
    }

    private static <T, S> Map<T, Set<S>> mergeMapInto(Map<T, Set<S>> map1, Map<T, Set<S>> map2) {
        map2.forEach((key, values) -> map1.merge((Object)key, (Set)values, (values1, values2) -> {
            values1.addAll(values2);
            return values1;
        }));
        return map1;
    }

    private static Set<String> getSameAsLinks(AboutType contextualClass) {
        List<Object> result = contextualClass instanceof AgentType ? ((AgentType)contextualClass).getSameAList() : (contextualClass instanceof Concept ? ((Concept)contextualClass).getChoiceList().stream().filter(Objects::nonNull).filter(Concept.Choice::ifExactMatch).map(Concept.Choice::getExactMatch).filter(Objects::nonNull).collect(Collectors.toList()) : (contextualClass instanceof PlaceType ? ((PlaceType)contextualClass).getSameAList() : (contextualClass instanceof TimeSpanType ? ((TimeSpanType)contextualClass).getSameAList() : null)));
        return Optional.ofNullable(result).orElse(Collections.emptyList()).stream().filter(Objects::nonNull).map(ResourceType::getResource).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
    }

    public static void setAdditionalData(RDF rdf) {
        ProxyType providerProxy = rdf.getProxyList().stream().filter(proxy -> !EnrichmentUtils.isEuropeanaProxy(proxy)).findAny().orElse(null);
        ProxyType europeanaProxy = rdf.getProxyList().stream().filter(EnrichmentUtils::isEuropeanaProxy).findAny().orElse(null);
        if (providerProxy == null || europeanaProxy == null) {
            return;
        }
        EuropeanaAggregationType europeanaAggregation = rdf.getEuropeanaAggregationList().stream().findAny().orElse(null);
        if (europeanaAggregation != null) {
            Completeness completeness = new Completeness();
            completeness.setString(Integer.toString(EnrichmentUtils.computeEuropeanaCompleteness(providerProxy, (Aggregation)rdf.getAggregationList().get(0))));
            europeanaAggregation.setCompleteness(completeness);
        }
        List<String> dateStrings = providerProxy.getChoiceList().stream().map(EnrichmentUtils::getDateFromChoice).filter(Objects::nonNull).collect(Collectors.toList());
        List yearList = new YearParser().parse(dateStrings).stream().map(EnrichmentUtils::createYear).collect(Collectors.toList());
        europeanaProxy.setYearList(yearList);
    }

    private static Year createYear(Integer year) {
        Year result = new Year();
        result.setString(year.toString());
        return result;
    }

    private static String getDateFromChoice(EuropeanaType.Choice choice) {
        Object result = choice.ifDate() ? choice.getDate() : (choice.ifTemporal() ? choice.getTemporal() : (choice.ifCreated() ? choice.getCreated() : (choice.ifIssued() ? choice.getIssued() : null)));
        return result == null ? null : result.getString();
    }

    private static boolean isEuropeanaProxy(ProxyType proxy) {
        return proxy.getEuropeanaProxy() != null && proxy.getEuropeanaProxy().isEuropeanaProxy();
    }

    private static int computeEuropeanaCompleteness(ProxyType providerProxy, Aggregation aggregation) {
        ArrayList<String> tags = new ArrayList<String>();
        ArrayList<String> descriptions = new ArrayList<String>();
        ArrayList<String> titles = new ArrayList<String>();
        List choices = providerProxy.getChoiceList();
        if (choices != null) {
            Map<Class<?>, String> uniqueResourceOrLiteralTypeClassesMap = EnrichmentUtils.createCollectionsForResourceOrLiteralType(choices, descriptions, titles);
            EnrichmentUtils.addResourceOrLiteralTypeFromMapsToList(uniqueResourceOrLiteralTypeClassesMap, tags);
        }
        String thumbnailUrl = Optional.ofNullable(aggregation.getObject()).map(ResourceType::getResource).orElse(null);
        return EnrichmentUtils.completenessCalculation(thumbnailUrl, titles, descriptions, tags);
    }

    private static Map<Class<?>, String> createCollectionsForResourceOrLiteralType(List<EuropeanaType.Choice> choices, List<String> descriptions, List<String> titles) {
        HashMap hashMap = new HashMap();
        for (EuropeanaType.Choice choice : choices) {
            EnrichmentUtils.addFirstTypeOccurrenceOfChoiceToMap(() -> ((EuropeanaType.Choice)choice).ifAlternative(), () -> ((EuropeanaType.Choice)choice).getAlternative(), hashMap);
            EnrichmentUtils.addFirstTypeOccurrenceOfChoiceToMap(() -> ((EuropeanaType.Choice)choice).ifIdentifier(), () -> ((EuropeanaType.Choice)choice).getIdentifier(), hashMap);
            EnrichmentUtils.addFirstTypeOccurrenceOfChoiceToMap(() -> ((EuropeanaType.Choice)choice).ifLanguage(), () -> ((EuropeanaType.Choice)choice).getLanguage(), hashMap);
            EnrichmentUtils.addFirstTypeOccurrenceOfChoiceToMap(() -> ((EuropeanaType.Choice)choice).ifCoverage(), () -> ((EuropeanaType.Choice)choice).getCoverage(), hashMap);
            EnrichmentUtils.addFirstTypeOccurrenceOfChoiceToMap(() -> ((EuropeanaType.Choice)choice).ifContributor(), () -> ((EuropeanaType.Choice)choice).getContributor(), hashMap);
            EnrichmentUtils.addFirstTypeOccurrenceOfChoiceToMap(() -> ((EuropeanaType.Choice)choice).ifCreator(), () -> ((EuropeanaType.Choice)choice).getCreator(), hashMap);
            EnrichmentUtils.addFirstTypeOccurrenceOfChoiceToMap(() -> ((EuropeanaType.Choice)choice).ifDate(), () -> ((EuropeanaType.Choice)choice).getDate(), hashMap);
            EnrichmentUtils.addFirstTypeOccurrenceOfChoiceToMap(() -> ((EuropeanaType.Choice)choice).ifFormat(), () -> ((EuropeanaType.Choice)choice).getFormat(), hashMap);
            EnrichmentUtils.addFirstTypeOccurrenceOfChoiceToMap(() -> ((EuropeanaType.Choice)choice).ifPublisher(), () -> ((EuropeanaType.Choice)choice).getPublisher(), hashMap);
            EnrichmentUtils.addFirstTypeOccurrenceOfChoiceToMap(() -> ((EuropeanaType.Choice)choice).ifRelation(), () -> ((EuropeanaType.Choice)choice).getRelation(), hashMap);
            EnrichmentUtils.addFirstTypeOccurrenceOfChoiceToMap(() -> ((EuropeanaType.Choice)choice).ifRights(), () -> ((EuropeanaType.Choice)choice).getRights(), hashMap);
            EnrichmentUtils.addFirstTypeOccurrenceOfChoiceToMap(() -> ((EuropeanaType.Choice)choice).ifSource(), () -> ((EuropeanaType.Choice)choice).getSource(), hashMap);
            EnrichmentUtils.addFirstTypeOccurrenceOfChoiceToMap(() -> ((EuropeanaType.Choice)choice).ifCreated(), () -> ((EuropeanaType.Choice)choice).getCreated(), hashMap);
            EnrichmentUtils.addFirstTypeOccurrenceOfChoiceToMap(() -> ((EuropeanaType.Choice)choice).ifConformsTo(), () -> ((EuropeanaType.Choice)choice).getConformsTo(), hashMap);
            EnrichmentUtils.addFirstTypeOccurrenceOfChoiceToMap(() -> ((EuropeanaType.Choice)choice).ifExtent(), () -> ((EuropeanaType.Choice)choice).getExtent(), hashMap);
            EnrichmentUtils.addFirstTypeOccurrenceOfChoiceToMap(() -> ((EuropeanaType.Choice)choice).ifHasFormat(), () -> ((EuropeanaType.Choice)choice).getHasFormat(), hashMap);
            EnrichmentUtils.addFirstTypeOccurrenceOfChoiceToMap(() -> ((EuropeanaType.Choice)choice).ifHasPart(), () -> ((EuropeanaType.Choice)choice).getHasPart(), hashMap);
            EnrichmentUtils.addFirstTypeOccurrenceOfChoiceToMap(() -> ((EuropeanaType.Choice)choice).ifHasVersion(), () -> ((EuropeanaType.Choice)choice).getHasVersion(), hashMap);
            EnrichmentUtils.addFirstTypeOccurrenceOfChoiceToMap(() -> ((EuropeanaType.Choice)choice).ifIsFormatOf(), () -> ((EuropeanaType.Choice)choice).getIsFormatOf(), hashMap);
            EnrichmentUtils.addFirstTypeOccurrenceOfChoiceToMap(() -> ((EuropeanaType.Choice)choice).ifIsPartOf(), () -> ((EuropeanaType.Choice)choice).getIsPartOf(), hashMap);
            EnrichmentUtils.addFirstTypeOccurrenceOfChoiceToMap(() -> ((EuropeanaType.Choice)choice).ifIsReferencedBy(), () -> ((EuropeanaType.Choice)choice).getIsReferencedBy(), hashMap);
            EnrichmentUtils.addFirstTypeOccurrenceOfChoiceToMap(() -> ((EuropeanaType.Choice)choice).ifIsReplacedBy(), () -> ((EuropeanaType.Choice)choice).getIsReplacedBy(), hashMap);
            EnrichmentUtils.addFirstTypeOccurrenceOfChoiceToMap(() -> ((EuropeanaType.Choice)choice).ifIsRequiredBy(), () -> ((EuropeanaType.Choice)choice).getIsRequiredBy(), hashMap);
            EnrichmentUtils.addFirstTypeOccurrenceOfChoiceToMap(() -> ((EuropeanaType.Choice)choice).ifIssued(), () -> ((EuropeanaType.Choice)choice).getIssued(), hashMap);
            EnrichmentUtils.addFirstTypeOccurrenceOfChoiceToMap(() -> ((EuropeanaType.Choice)choice).ifIsVersionOf(), () -> ((EuropeanaType.Choice)choice).getIsVersionOf(), hashMap);
            EnrichmentUtils.addFirstTypeOccurrenceOfChoiceToMap(() -> ((EuropeanaType.Choice)choice).ifMedium(), () -> ((EuropeanaType.Choice)choice).getMedium(), hashMap);
            EnrichmentUtils.addFirstTypeOccurrenceOfChoiceToMap(() -> ((EuropeanaType.Choice)choice).ifProvenance(), () -> ((EuropeanaType.Choice)choice).getProvenance(), hashMap);
            EnrichmentUtils.addFirstTypeOccurrenceOfChoiceToMap(() -> ((EuropeanaType.Choice)choice).ifReferences(), () -> ((EuropeanaType.Choice)choice).getReferences(), hashMap);
            EnrichmentUtils.addFirstTypeOccurrenceOfChoiceToMap(() -> ((EuropeanaType.Choice)choice).ifReplaces(), () -> ((EuropeanaType.Choice)choice).getReplaces(), hashMap);
            EnrichmentUtils.addFirstTypeOccurrenceOfChoiceToMap(() -> ((EuropeanaType.Choice)choice).ifRequires(), () -> ((EuropeanaType.Choice)choice).getRequires(), hashMap);
            EnrichmentUtils.addFirstTypeOccurrenceOfChoiceToMap(() -> ((EuropeanaType.Choice)choice).ifSpatial(), () -> ((EuropeanaType.Choice)choice).getSpatial(), hashMap);
            EnrichmentUtils.addFirstTypeOccurrenceOfChoiceToMap(() -> ((EuropeanaType.Choice)choice).ifTableOfContents(), () -> ((EuropeanaType.Choice)choice).getTableOfContents(), hashMap);
            EnrichmentUtils.addFirstTypeOccurrenceOfChoiceToMap(() -> ((EuropeanaType.Choice)choice).ifTemporal(), () -> ((EuropeanaType.Choice)choice).getTemporal(), hashMap);
            EnrichmentUtils.addFirstTypeOccurrenceOfChoiceToMap(() -> ((EuropeanaType.Choice)choice).ifSubject(), () -> ((EuropeanaType.Choice)choice).getSubject(), hashMap);
            EnrichmentUtils.addFirstTypeOccurrenceOfChoiceToMap(() -> ((EuropeanaType.Choice)choice).ifSpatial(), () -> ((EuropeanaType.Choice)choice).getSpatial(), hashMap);
            EnrichmentUtils.addChoiceToList(() -> ((EuropeanaType.Choice)choice).ifTitle(), () -> ((EuropeanaType.Choice)choice).getTitle(), titles);
            EnrichmentUtils.addChoiceToList(() -> ((EuropeanaType.Choice)choice).ifDescription(), () -> ((EuropeanaType.Choice)choice).getDescription(), descriptions);
        }
        return hashMap;
    }

    private static <R> void addFirstTypeOccurrenceOfChoiceToMap(BooleanSupplier booleanSupplier, Supplier<R> supplier, Map<Class<?>, String> map) {
        if (booleanSupplier.getAsBoolean()) {
            R result = supplier.get();
            String value = result instanceof LiteralType ? EnrichmentUtils.getLiteralValue((LiteralType)result) : EnrichmentUtils.getResourceorLiteralValue((ResourceOrLiteralType)result);
            map.putIfAbsent(result.getClass(), value);
        }
    }

    private static <R> void addChoiceToList(BooleanSupplier booleanSupplier, Supplier<R> supplier, List<String> list) {
        if (booleanSupplier.getAsBoolean()) {
            R result = supplier.get();
            String value = result instanceof LiteralType ? EnrichmentUtils.getLiteralValue((LiteralType)result) : EnrichmentUtils.getResourceorLiteralValue((ResourceOrLiteralType)result);
            list.add(value);
        }
    }

    private static void addResourceOrLiteralTypeFromMapsToList(Map<Class<?>, String> uniqueResourceOrLiteralTypeClassesMap, List<String> tags) {
        uniqueResourceOrLiteralTypeClassesMap.values().stream().filter(StringUtils::isNotBlank).forEach(tags::add);
    }

    private static <T extends ResourceOrLiteralType> String getResourceorLiteralValue(T resourceOrLiteralType) {
        return Optional.ofNullable(resourceOrLiteralType).map(ResourceOrLiteralType::getString).map(StringUtils::trimToNull).orElseGet(() -> Optional.ofNullable(resourceOrLiteralType).map(ResourceOrLiteralType::getResource).map(ResourceOrLiteralType.Resource::getResource).orElse(null));
    }

    private static <T extends LiteralType> String getLiteralValue(T literalType) {
        return Optional.ofNullable(literalType).map(LiteralType::getString).map(StringUtils::trimToNull).orElse(null);
    }

    private static int completenessCalculation(String thumbnailUrl, List<String> titles, List<String> descriptions, List<String> tags) {
        if (StringUtils.isEmpty((CharSequence)thumbnailUrl) || EnrichmentUtils.isListFullOfEmptyValues(titles) && EnrichmentUtils.isListFullOfEmptyValues(descriptions)) {
            return 0;
        }
        ArrayList<String> text = new ArrayList<String>(descriptions);
        text.addAll(titles);
        int pointsForTags = EnrichmentUtils.computePoints(tags, 1);
        int pointsForText = EnrichmentUtils.computePoints(text, 5);
        return pointsForText + pointsForTags;
    }

    private static int computePoints(Collection<String> fields, int wordsPerPoint) {
        Collection<String> words = EnrichmentUtils.extractWordsFromFields(fields);
        int points = words.size() / wordsPerPoint;
        return Math.min(5, points);
    }

    private static Collection<String> extractWordsFromFields(Collection<String> fields) {
        return fields.stream().filter(StringUtils::isNotEmpty).map(EnrichmentUtils::extractWordsFromField).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static List<String> extractWordsFromField(String field) {
        return Arrays.stream(field.split("\\W")).filter(word -> StringUtils.isNotEmpty((CharSequence)word) && word.length() >= 3).map(word -> word.toLowerCase(Locale.US)).collect(Collectors.toList());
    }

    private static boolean isListFullOfEmptyValues(List<String> descriptions) {
        return descriptions.stream().allMatch(StringUtils::isBlank);
    }
}

