/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.rest.client;

import eu.europeana.enrichment.api.exceptions.UnknownException;
import eu.europeana.enrichment.api.external.InputValueList;
import eu.europeana.enrichment.api.external.model.EnrichmentBase;
import eu.europeana.enrichment.api.external.model.EnrichmentResultList;
import eu.europeana.enrichment.rest.client.TemporaryResponseConverter;
import eu.europeana.enrichment.utils.InputValue;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class EnrichmentClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnrichmentClient.class);
    private final String endpoint;
    private RestTemplate template = new RestTemplate();

    public EnrichmentClient(String endpoint) {
        this.endpoint = endpoint;
    }

    public EnrichmentResultList enrich(List<InputValue> values) {
        InputValueList inList = new InputValueList();
        inList.setInputValues(values);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_XML));
        HttpEntity request = new HttpEntity((Object)inList, (MultiValueMap)headers);
        String url = this.endpoint + "/enrich";
        try {
            return TemporaryResponseConverter.convert((ResponseEntity<byte[]>)this.template.exchange(url, HttpMethod.POST, request, byte[].class, new Object[0]));
        }
        catch (JAXBException | RestClientException e) {
            LOGGER.warn("Enrichment client POST call failed: {}.", (Object)url, (Object)e);
            throw new UnknownException("Enrichment client call failed.", e);
        }
    }

    public EnrichmentBase getByUri(String uri) {
        String encodedUri;
        try {
            encodedUri = URLEncoder.encode(uri, StandardCharsets.UTF_8.name()).replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)(this.endpoint + "/getByUri")).queryParam("uri", new Object[]{encodedUri});
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_XML);
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_XML));
        HttpEntity request = new HttpEntity((MultiValueMap)headers);
        URI fullUri = builder.build(true).toUri();
        try {
            return TemporaryResponseConverter.convert((ResponseEntity<byte[]>)this.template.exchange(fullUri, HttpMethod.GET, request, byte[].class), EnrichmentBase.class, () -> null);
        }
        catch (JAXBException | RestClientException e) {
            LOGGER.warn("Enrichment client GET call failed: {}.", (Object)fullUri, (Object)e);
            throw new UnknownException("Enrichment client call failed.", e);
        }
    }

    public EnrichmentResultList getByUri(Collection<String> uriList) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_XML));
        HttpEntity request = new HttpEntity(new ArrayList<String>(uriList), (MultiValueMap)headers);
        String url = this.endpoint + "/getByUri";
        try {
            return TemporaryResponseConverter.convert((ResponseEntity<byte[]>)this.template.exchange(url, HttpMethod.POST, request, byte[].class, new Object[0]));
        }
        catch (JAXBException | RestClientException e) {
            LOGGER.warn("Enrichment client POST call failed: {}.", (Object)url, (Object)e);
            throw new UnknownException("Enrichment client call failed.", e);
        }
    }

    public EnrichmentResultList getById(Collection<String> uriList) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_XML));
        HttpEntity request = new HttpEntity(new ArrayList<String>(uriList), (MultiValueMap)headers);
        String url = this.endpoint + "/getById";
        try {
            return TemporaryResponseConverter.convert((ResponseEntity<byte[]>)this.template.exchange(url, HttpMethod.POST, request, byte[].class, new Object[0]));
        }
        catch (JAXBException | RestClientException e) {
            LOGGER.warn("Enrichment client POST call failed: {}.", (Object)url, (Object)e);
            throw new UnknownException("Enrichment client call failed.", e);
        }
    }

    void setRestTemplate(RestTemplate template) {
        this.template = template;
    }
}

