/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.utils;

import eu.europeana.corelib.definitions.jibx.AboutType;
import eu.europeana.corelib.definitions.jibx.Concept;
import eu.europeana.corelib.definitions.jibx.LiteralType;
import eu.europeana.corelib.definitions.jibx.ResourceOrLiteralType;
import eu.europeana.corelib.definitions.jibx.ResourceType;
import eu.europeana.enrichment.api.external.model.EnrichmentBase;
import eu.europeana.enrichment.api.external.model.Label;
import eu.europeana.enrichment.api.external.model.LabelResource;
import eu.europeana.enrichment.api.external.model.Part;
import eu.europeana.enrichment.api.external.model.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class ItemExtractorUtils {
    private ItemExtractorUtils() {
    }

    static void setAbout(EnrichmentBase source, AboutType destination) {
        destination.setAbout(source.getAbout());
    }

    static <T extends AboutType> boolean isEntityAlreadyInList(EnrichmentBase enrichmentBase, List<T> destination) {
        return destination.stream().map(AboutType::getAbout).anyMatch(enrichmentBase.getAbout()::equals);
    }

    static <S, T> List<T> extractItems(List<S> sourceList, Function<S, T> converter) {
        List<Object> result = sourceList == null ? new ArrayList() : sourceList.stream().filter(Objects::nonNull).map(converter).collect(Collectors.toList());
        return result;
    }

    static <T extends LiteralType> List<T> extractLabels(List<Label> sourceList, Supplier<T> newInstanceProvider) {
        return ItemExtractorUtils.extractItems(sourceList, label -> ItemExtractorUtils.extractLabel(label, newInstanceProvider));
    }

    static <T extends ResourceOrLiteralType> List<T> extractLabelsToResourceOrLiteralList(List<Label> sourceList, Supplier<T> newInstanceProvider) {
        return ItemExtractorUtils.extractItems(sourceList, label -> ItemExtractorUtils.extractLabelToResourceOrLiteral(label, newInstanceProvider));
    }

    static <T extends ResourceOrLiteralType> List<T> extractParts(List<Part> sourceList, Supplier<T> newInstanceProvider) {
        return ItemExtractorUtils.extractItems(sourceList, part -> ItemExtractorUtils.extractPart(part, newInstanceProvider));
    }

    static <S, T extends ResourceType> List<T> extractAsResources(List<S> sourceList, Supplier<T> newInstanceProvider, Function<S, String> resourceProvider) {
        return ItemExtractorUtils.extractItems(sourceList, item -> ItemExtractorUtils.extractAsResource(item, newInstanceProvider, resourceProvider));
    }

    static <T extends ResourceType> List<T> extractResources(List<Resource> sourceList, Supplier<T> newInstanceProvider) {
        return ItemExtractorUtils.extractAsResources(sourceList, newInstanceProvider, Resource::getResource);
    }

    static <T extends ResourceOrLiteralType> List<T> extractLabelResources(List<LabelResource> sourceList, Supplier<T> newInstanceProvider) {
        return ItemExtractorUtils.extractItems(sourceList, labelResource -> ItemExtractorUtils.extractLabelResource(labelResource, newInstanceProvider));
    }

    static <T extends LiteralType> T extractFirstLabel(List<Label> sourceList, Supplier<T> newInstanceProvider) {
        Label firstLabel = sourceList == null ? null : (Label)sourceList.stream().filter(Objects::nonNull).findFirst().orElse(null);
        return firstLabel == null ? null : (T)ItemExtractorUtils.extractLabel(firstLabel, newInstanceProvider);
    }

    static <T extends LiteralType> T extractLabel(Label label, Supplier<T> newInstanceProvider) {
        LiteralType result = (LiteralType)newInstanceProvider.get();
        if (label.getLang() != null) {
            LiteralType.Lang lang = new LiteralType.Lang();
            lang.setLang(label.getLang());
            result.setLang(lang);
        }
        result.setString(label.getValue() == null ? "" : label.getValue());
        return (T)result;
    }

    static <T extends ResourceOrLiteralType> T extractLabelToResourceOrLiteral(Label label, Supplier<T> newInstanceProvider) {
        ResourceOrLiteralType result = (ResourceOrLiteralType)newInstanceProvider.get();
        if (label.getLang() != null) {
            ResourceOrLiteralType.Lang lang = new ResourceOrLiteralType.Lang();
            lang.setLang(label.getLang());
            result.setLang(lang);
        }
        result.setString(label.getValue() == null ? "" : label.getValue());
        return (T)result;
    }

    static <T extends ResourceOrLiteralType> T extractLabelResource(LabelResource labelResource, Supplier<T> newInstanceProvider) {
        ResourceOrLiteralType result = (ResourceOrLiteralType)newInstanceProvider.get();
        if (labelResource.getLang() != null) {
            ResourceOrLiteralType.Lang lang = new ResourceOrLiteralType.Lang();
            lang.setLang(labelResource.getLang());
            result.setLang(lang);
        }
        if (labelResource.getResource() != null) {
            ResourceOrLiteralType.Resource resrc = new ResourceOrLiteralType.Resource();
            resrc.setResource(labelResource.getResource());
            result.setResource(resrc);
        }
        result.setString(labelResource.getValue() == null ? "" : labelResource.getValue());
        return (T)result;
    }

    static <T extends ResourceOrLiteralType> T extractPart(Part part, Supplier<T> newInstanceProvider) {
        ResourceOrLiteralType result = (ResourceOrLiteralType)newInstanceProvider.get();
        if (part.getResource() != null) {
            ResourceOrLiteralType.Resource resrc = new ResourceOrLiteralType.Resource();
            resrc.setResource(part.getResource());
            result.setResource(resrc);
        }
        result.setString("");
        return (T)result;
    }

    static <S, T extends ResourceType> T extractAsResource(S input, Supplier<T> newInstanceProvider, Function<S, String> resourceProvider) {
        ResourceType result = (ResourceType)newInstanceProvider.get();
        String inputString = resourceProvider.apply(input);
        result.setResource(inputString == null ? "" : inputString);
        return (T)result;
    }

    static <T> void toChoices(List<T> inputList, BiConsumer<Concept.Choice, T> propertySetter, List<Concept.Choice> destination) {
        for (T input : inputList) {
            Concept.Choice choice = new Concept.Choice();
            propertySetter.accept(choice, (Concept.Choice)input);
            destination.add(choice);
        }
    }
}

