/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.utils;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YearParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(YearParser.class);
    private static final String BC_LIST_FILE = "bcList";
    private static final String AD_LIST_FILE = "adList";
    protected static final String REGEX_YEAR_GROUP_NAME = "year";
    private static final String REGEX_SPACE_SEGMENT = "\\s*";
    private static final String REGEX_YEAR_SEGMENT = "\\s*(?<year>\\d+)\\s*";
    private static final String YEAR_WITHOUT_ERA_REGEX = "\\s*(?<year>-?\\d+)\\s*";
    private static final Pattern YEAR_WITHOUT_ERA_PATTERN = Pattern.compile("\\s*(?<year>-?\\d+)\\s*");
    private static List<Pattern> bcPatterns = null;
    private static List<Pattern> adPatterns = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Pattern> getBcPatterns() {
        Class<YearParser> clazz = YearParser.class;
        synchronized (YearParser.class) {
            if (bcPatterns == null) {
                bcPatterns = YearParser.createEraPatterns(BC_LIST_FILE);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return Collections.unmodifiableList(bcPatterns);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Pattern> getAdPatterns() {
        Class<YearParser> clazz = YearParser.class;
        synchronized (YearParser.class) {
            if (adPatterns == null) {
                adPatterns = YearParser.createEraPatterns(AD_LIST_FILE);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return Collections.unmodifiableList(adPatterns);
        }
    }

    private static List<Pattern> createEraPatterns(String filePath) {
        List readLines;
        try {
            readLines = IOUtils.readLines((InputStream)YearParser.class.getClassLoader().getResourceAsStream(filePath), (String)StandardCharsets.UTF_8.name());
        }
        catch (IOException e) {
            LOGGER.error("Problem reading file '" + filePath + "'", (Throwable)e);
            return Collections.emptyList();
        }
        Set eraLines = readLines.stream().map(String::trim).filter(line -> !line.isEmpty()).collect(Collectors.toSet());
        return eraLines.stream().flatMap(YearParser::composeEraRegexPatterns).map(regex -> Pattern.compile(regex, 2)).collect(Collectors.toList());
    }

    private static Stream<String> composeEraRegexPatterns(String input) {
        String quote = Pattern.quote(input);
        return Stream.of(REGEX_SPACE_SEGMENT + quote + REGEX_YEAR_SEGMENT, REGEX_YEAR_SEGMENT + quote + REGEX_SPACE_SEGMENT);
    }

    public Set<Integer> parse(List<String> input) {
        return input.stream().map(this::parse).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public Integer parse(String input) {
        Integer year = this.parseYearFromPattern(input, YEAR_WITHOUT_ERA_PATTERN);
        if (year == null) {
            year = this.parseYearFromPatterns(input, this.getAdPatterns());
        }
        if (year == null) {
            year = this.parseYearFromPatterns(input, this.getBcPatterns());
            year = year == null ? null : Integer.valueOf(-year.intValue());
        }
        return year;
    }

    private Integer parseYearFromPatterns(String input, List<Pattern> patterns) {
        return patterns.stream().map(pattern -> this.parseYearFromPattern(input, (Pattern)pattern)).filter(Objects::nonNull).findAny().orElse(null);
    }

    private Integer parseYearFromPattern(String input, Pattern pattern) {
        Matcher matcher = pattern.matcher(input);
        if (!matcher.matches()) {
            return null;
        }
        String yearString = matcher.group(REGEX_YEAR_GROUP_NAME);
        try {
            return Integer.valueOf(yearString);
        }
        catch (NumberFormatException e) {
            LOGGER.error("Problem when parsing string '" + yearString + "'.", (Throwable)e);
            return null;
        }
    }
}

