/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.utils;

import eu.europeana.corelib.definitions.jibx.RDF;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RdfConversionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(RdfConversionUtils.class);
    private static final int IDENTATION_SPACE = 2;
    private static final String UTF8 = StandardCharsets.UTF_8.name();
    private static IBindingFactory rdfBindingFactory;

    private RdfConversionUtils() {
    }

    private static IBindingFactory getRdfBindingFactory() {
        if (rdfBindingFactory != null) {
            return rdfBindingFactory;
        }
        throw new IllegalStateException("No binding factory available.");
    }

    public static String convertRdfToString(RDF rdf) throws JiBXException, UnsupportedEncodingException {
        IMarshallingContext context = RdfConversionUtils.getRdfBindingFactory().createMarshallingContext();
        context.setIndent(2);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        context.marshalDocument((Object)rdf, UTF8, null, (OutputStream)out);
        return out.toString(UTF8);
    }

    public static RDF convertStringToRdf(String xml) throws JiBXException {
        IUnmarshallingContext context = RdfConversionUtils.getRdfBindingFactory().createUnmarshallingContext();
        return (RDF)context.unmarshalDocument(IOUtils.toInputStream((String)xml, (Charset)StandardCharsets.UTF_8), UTF8);
    }

    static {
        try {
            rdfBindingFactory = BindingDirectory.getFactory(RDF.class);
        }
        catch (JiBXException e) {
            LOGGER.error("Unable to create binding factory", (Throwable)e);
        }
    }
}

