/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.rest.client;

import eu.europeana.corelib.definitions.jibx.RDF;
import eu.europeana.enrichment.api.external.model.EnrichmentBaseWrapper;
import eu.europeana.enrichment.api.external.model.EnrichmentResultList;
import eu.europeana.enrichment.rest.client.DereferenceClient;
import eu.europeana.enrichment.rest.client.DereferenceOrEnrichException;
import eu.europeana.enrichment.rest.client.EnrichmentClient;
import eu.europeana.enrichment.utils.DereferenceUtils;
import eu.europeana.enrichment.utils.EnrichmentUtils;
import eu.europeana.enrichment.utils.EntityMergeEngine;
import eu.europeana.enrichment.utils.InputValue;
import eu.europeana.enrichment.utils.RdfConversionUtils;
import eu.europeana.metis.utils.ExternalRequestUtil;
import java.io.UnsupportedEncodingException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.ObjIntConsumer;
import org.apache.commons.collections.CollectionUtils;
import org.jibx.runtime.JiBXException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.client.HttpServerErrorException;

public class EnrichmentWorker {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnrichmentWorker.class);
    private static final int EXTERNAL_CALL_MAX_RETRIES = 30;
    private static final int EXTERNAL_CALL_PERIOD_BETWEEN_RETRIES_IN_MILLIS = 1000;
    private static final Map<Class<?>, String> mapWithRetrieableExceptions;
    private final EnrichmentClient enrichmentClient;
    private final DereferenceClient dereferenceClient;
    private final EntityMergeEngine entityMergeEngine;

    public EnrichmentWorker(String dereferenceUrl, String enrichmentUrl) {
        this(new DereferenceClient(dereferenceUrl), new EnrichmentClient(enrichmentUrl), new EntityMergeEngine());
    }

    EnrichmentWorker(DereferenceClient dereferenceClient, EnrichmentClient enrichmentClient, EntityMergeEngine entityMergeEngine) {
        this.dereferenceClient = dereferenceClient;
        this.enrichmentClient = enrichmentClient;
        this.entityMergeEngine = entityMergeEngine;
    }

    public String process(String inputString) throws DereferenceOrEnrichException, JiBXException, UnsupportedEncodingException {
        if (inputString == null) {
            throw new IllegalArgumentException("Input RDF string cannot be null.");
        }
        RDF inputRdf = this.convertStringToRdf(inputString);
        RDF resultRdf = this.process(inputRdf, Mode.DEREFERENCE_AND_ENRICHMENT);
        return this.convertRdfToString(resultRdf);
    }

    public RDF process(RDF inputRdf) throws DereferenceOrEnrichException {
        return this.process(inputRdf, Mode.DEREFERENCE_AND_ENRICHMENT);
    }

    public RDF process(RDF rdf, Mode mode) throws DereferenceOrEnrichException {
        if (rdf == null) {
            throw new IllegalArgumentException("Input RDF cannot be null.");
        }
        if (mode == null) {
            throw new IllegalArgumentException("Mode cannot be null.");
        }
        LOGGER.info("Received RDF for enrichment/dereferencing. Mode: {}", (Object)mode);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Processing RDF:\n{}", (Object)this.convertRdfToStringForLogging(rdf));
        }
        if (Mode.DEREFERENCE_AND_ENRICHMENT == mode || Mode.DEREFERENCE_ONLY == mode) {
            LOGGER.debug("Performing dereferencing...");
            this.performDereferencing(rdf);
            LOGGER.debug("Dereferencing completed.");
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("RDF after dereferencing:\n{}", (Object)this.convertRdfToStringForLogging(rdf));
            }
        }
        if (Mode.DEREFERENCE_AND_ENRICHMENT == mode || Mode.ENRICHMENT_ONLY == mode) {
            LOGGER.debug("Performing enrichment...");
            this.performEnrichment(rdf);
            LOGGER.debug("Enrichment completed.");
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("RDF after enrichment:\n{}", (Object)this.convertRdfToStringForLogging(rdf));
            }
        }
        LOGGER.debug("Processing complete.");
        return rdf;
    }

    private String convertRdfToStringForLogging(RDF rdf) {
        try {
            return this.convertRdfToString(rdf);
        }
        catch (UnsupportedEncodingException | JiBXException e) {
            LOGGER.warn("Exception occurred while rendering an RDF document as a String.", e);
            return "[COULD NOT RENDER RDF]";
        }
    }

    private void performEnrichment(RDF rdf) throws DereferenceOrEnrichException {
        LOGGER.debug("Extracting fields from RDF for enrichment...");
        List<InputValue> fieldsForEnrichment = this.extractFieldsForEnrichment(rdf);
        if (LOGGER.isDebugEnabled()) {
            this.logExtractionResult(fieldsForEnrichment, EnrichmentWorker::logInputValueWithCounter);
        }
        LOGGER.debug("Using extracted fields to gather enrichment information...");
        EnrichmentResultList enrichmentInformation = this.enrichFields(fieldsForEnrichment);
        if (LOGGER.isDebugEnabled()) {
            this.logDereferencingOrEnrichmentResult(Collections.singletonList(enrichmentInformation));
        }
        LOGGER.debug("Merging Enrichment Information...");
        if (enrichmentInformation != null && CollectionUtils.isNotEmpty((Collection)enrichmentInformation.getEnrichmentBaseWrapperList())) {
            this.entityMergeEngine.mergeEntities(rdf, enrichmentInformation.getEnrichmentBaseWrapperList());
        }
        LOGGER.debug("Setting additional data in the RDF...");
        EnrichmentUtils.setAdditionalData(rdf);
        LOGGER.debug("Enrichment completed.");
    }

    private EnrichmentResultList enrichFields(List<InputValue> fieldsForEnrichment) throws DereferenceOrEnrichException {
        try {
            return CollectionUtils.isEmpty(fieldsForEnrichment) ? null : (EnrichmentResultList)ExternalRequestUtil.retryableExternalRequest(() -> this.enrichmentClient.enrich(fieldsForEnrichment), mapWithRetrieableExceptions, (int)30, (int)1000);
        }
        catch (Exception e) {
            throw new DereferenceOrEnrichException("Exception occurred while trying to perform enrichment.", e);
        }
    }

    private void performDereferencing(RDF rdf) throws DereferenceOrEnrichException {
        LOGGER.debug(" Extracting fields from RDF for dereferencing...");
        Set<String> resourceIds = this.extractValuesForDereferencing(rdf);
        if (LOGGER.isDebugEnabled()) {
            this.logExtractionResult(resourceIds, EnrichmentWorker::logStringWithCounter);
        }
        LOGGER.debug("Using extracted fields to gather enrichment-via-dereferencing information...");
        List<EnrichmentResultList> dereferenceInformation = this.dereferenceFields(resourceIds);
        if (LOGGER.isDebugEnabled()) {
            this.logDereferencingOrEnrichmentResult(dereferenceInformation);
        }
        LOGGER.debug("Merging Dereference Information...");
        for (EnrichmentResultList dereferenceResultList : dereferenceInformation) {
            if (dereferenceResultList == null || dereferenceResultList.getEnrichmentBaseWrapperList() == null || dereferenceResultList.getEnrichmentBaseWrapperList().isEmpty()) continue;
            this.entityMergeEngine.mergeEntities(rdf, dereferenceResultList.getEnrichmentBaseWrapperList());
        }
        LOGGER.debug("Dereference completed.");
    }

    private List<EnrichmentResultList> dereferenceFields(Set<String> resourceIds) throws DereferenceOrEnrichException {
        ArrayList<EnrichmentResultList> dereferenceInformation = new ArrayList<EnrichmentResultList>();
        try {
            for (String resourceId : resourceIds) {
                if (resourceId == null) continue;
                LOGGER.debug("== Processing {}", (Object)resourceId);
                EnrichmentResultList result = (EnrichmentResultList)ExternalRequestUtil.retryableExternalRequest(() -> this.dereferenceClient.dereference(resourceId), mapWithRetrieableExceptions, (int)30, (int)1000);
                if (result == null || result.getEnrichmentBaseWrapperList() == null || result.getEnrichmentBaseWrapperList().isEmpty()) {
                    LOGGER.debug("==== Null or empty value received for reference {}", (Object)resourceId);
                    continue;
                }
                dereferenceInformation.add(result);
            }
        }
        catch (Exception e) {
            throw new DereferenceOrEnrichException("Exception occurred while trying to perform dereferencing.", e);
        }
        return dereferenceInformation;
    }

    private static void logStringWithCounter(String field, int count) {
        LOGGER.debug("== {}: {}", (Object)count, (Object)field);
    }

    private static void logInputValueWithCounter(InputValue inputValue, int count) {
        LOGGER.debug("== {}: {} {} {} {}.", new Object[]{count, inputValue.getLanguage(), inputValue.getOriginalField(), inputValue.getValue(), inputValue.getVocabularies()});
    }

    private <T> void logExtractionResult(Collection<T> resultList, ObjIntConsumer<T> logger) {
        int count = 0;
        if (resultList != null) {
            LOGGER.debug("Extracted following fields:");
            for (T result : resultList) {
                if (result == null) continue;
                logger.accept(result, ++count);
            }
        }
        if (count == 0) {
            LOGGER.debug("No fields to process.");
        }
    }

    private void logDereferencingOrEnrichmentResult(List<EnrichmentResultList> resultList) {
        int count = 0;
        if (resultList != null) {
            LOGGER.debug("Following information found:");
            for (EnrichmentResultList result : resultList) {
                if (result == null) continue;
                for (EnrichmentBaseWrapper enrichmentBaseWrapper : result.getEnrichmentBaseWrapperList()) {
                    if (enrichmentBaseWrapper == null) continue;
                    LOGGER.debug("== {}: About: {} AltLabelList: {} Notes: {} PrefLabelListL {}", new Object[]{++count, enrichmentBaseWrapper.getEnrichmentBase().getAbout(), enrichmentBaseWrapper.getEnrichmentBase().getAltLabelList(), enrichmentBaseWrapper.getEnrichmentBase().getNotes(), enrichmentBaseWrapper.getEnrichmentBase().getPrefLabelList()});
                }
            }
        }
        if (count == 0) {
            LOGGER.debug("No information found. Nothing to merge.");
        }
    }

    List<InputValue> extractFieldsForEnrichment(RDF rdf) {
        return EnrichmentUtils.extractFieldsForEnrichmentFromRDF(rdf);
    }

    Set<String> extractValuesForDereferencing(RDF rdf) {
        return DereferenceUtils.extractValuesForDereferencing(rdf);
    }

    String convertRdfToString(RDF rdf) throws UnsupportedEncodingException, JiBXException {
        return RdfConversionUtils.convertRdfToString(rdf);
    }

    RDF convertStringToRdf(String xml) throws JiBXException {
        return RdfConversionUtils.convertStringToRdf(xml);
    }

    static {
        HashMap<Class, String> retriableExceptionMap = new HashMap<Class, String>();
        retriableExceptionMap.put(UnknownHostException.class, "");
        retriableExceptionMap.put(HttpServerErrorException.class, "");
        mapWithRetrieableExceptions = Collections.unmodifiableMap(retriableExceptionMap);
    }

    public static enum Mode {
        ENRICHMENT_ONLY,
        DEREFERENCE_ONLY,
        DEREFERENCE_AND_ENRICHMENT;

    }
}

