/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.utils;

import eu.europeana.corelib.definitions.jibx.AboutType;
import eu.europeana.corelib.definitions.jibx.ProxyType;
import eu.europeana.corelib.definitions.jibx.RDF;
import eu.europeana.enrichment.utils.EnrichmentFields;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public final class RdfProxyUtils {
    private RdfProxyUtils() {
    }

    public static void appendToProxy(RDF rdf, AboutType about, String fieldName) {
        ProxyType europeanaProxy = RdfProxyUtils.getEuropeanaProxy(rdf);
        RdfProxyUtils.appendToProxy(europeanaProxy, EnrichmentFields.valueOf(fieldName), about.getAbout());
        RdfProxyUtils.replaceProxy(rdf, europeanaProxy);
    }

    private static void appendToProxy(ProxyType europeanaProxy, EnrichmentFields enrichmentFields, String about) {
        List choices = europeanaProxy.getChoiceList();
        choices.add(enrichmentFields.createChoice(about));
        europeanaProxy.setChoiceList(choices);
    }

    public static ProxyType getProviderProxy(RDF rdf) {
        for (ProxyType proxyType : rdf.getProxyList()) {
            if (proxyType.getEuropeanaProxy() != null && proxyType.getEuropeanaProxy().isEuropeanaProxy()) continue;
            return proxyType;
        }
        throw new IllegalArgumentException("Could not find provider proxy.");
    }

    private static ProxyType getEuropeanaProxy(RDF rdf) {
        for (ProxyType proxyType : rdf.getProxyList()) {
            if (proxyType.getEuropeanaProxy() == null || !proxyType.getEuropeanaProxy().isEuropeanaProxy()) continue;
            return proxyType;
        }
        throw new IllegalArgumentException("Could not find Europeana proxy.");
    }

    private static void replaceProxy(RDF rdf, ProxyType europeanaProxy) {
        ArrayList<ProxyType> proxyTypeList = new ArrayList<ProxyType>();
        proxyTypeList.add(europeanaProxy);
        for (ProxyType proxyType : rdf.getProxyList()) {
            if (StringUtils.equals((CharSequence)proxyType.getAbout(), (CharSequence)europeanaProxy.getAbout())) continue;
            proxyTypeList.add(proxyType);
        }
        rdf.setProxyList(proxyTypeList);
    }
}

