/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.utils;

import eu.europeana.corelib.definitions.jibx.AgentType;
import eu.europeana.corelib.definitions.jibx.Concept;
import eu.europeana.corelib.definitions.jibx.EuropeanaType;
import eu.europeana.corelib.definitions.jibx.PlaceType;
import eu.europeana.corelib.definitions.jibx.ProxyType;
import eu.europeana.corelib.definitions.jibx.RDF;
import eu.europeana.corelib.definitions.jibx.ResourceOrLiteralType;
import eu.europeana.corelib.definitions.jibx.ResourceType;
import eu.europeana.corelib.definitions.jibx.TimeSpanType;
import eu.europeana.corelib.definitions.jibx.WebResourceType;
import eu.europeana.enrichment.utils.RdfProxyUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;

public final class DereferenceUtils {
    private static final Function<ResourceType, String> RESOURCE_EXTRACTOR = DereferenceUtils::extractFromResource;
    private static final Function<ResourceOrLiteralType, String> RESOURCE_OR_LITERAL_EXTRACTOR = DereferenceUtils::extractFromResourceOrLiteral;

    private DereferenceUtils() {
    }

    public static Set<String> extractValuesForDereferencing(RDF rdf) {
        HashSet<String> result = new HashSet<String>();
        DereferenceUtils.extractValues(rdf.getAgentList(), item -> DereferenceUtils.dereferenceAgent(item, result));
        DereferenceUtils.extractValues(rdf.getConceptList(), concept -> {
            result.add(concept.getAbout());
            DereferenceUtils.extractValues(concept.getChoiceList(), item -> DereferenceUtils.dereferenceConceptChoice(item, result));
        });
        DereferenceUtils.extractValues(rdf.getPlaceList(), item -> DereferenceUtils.dereferencePlace(item, result));
        DereferenceUtils.extractValues(rdf.getTimeSpanList(), item -> DereferenceUtils.dereferenceTimespan(item, result));
        DereferenceUtils.extractValues(rdf.getWebResourceList(), item -> DereferenceUtils.dereferenceWebResource(item, result));
        DereferenceUtils.extractValues(Collections.singletonList(RdfProxyUtils.getProviderProxy(rdf)), item -> DereferenceUtils.dereferenceProxy(item, result));
        return result;
    }

    private static <S> void extractValues(List<S> source, Consumer<S> extractor) {
        if (source != null) {
            for (S sourceItem : source) {
                extractor.accept(sourceItem);
            }
        }
    }

    private static <T> void convertValues(List<? extends T> source, Function<T, String> conversion, Set<String> result) {
        if (source != null) {
            for (T sourceItem : source) {
                DereferenceUtils.convertValue(sourceItem, conversion, result);
            }
        }
    }

    private static <T> void convertValue(T source, Function<T, String> conversion, Set<String> result) {
        String target;
        if (source != null && StringUtils.isNotEmpty((CharSequence)(target = conversion.apply(source)))) {
            result.add(target);
        }
    }

    private static <T> void convertValue(boolean proceed, T source, Function<T, String> conversion, Set<String> result) {
        if (proceed) {
            DereferenceUtils.convertValue(source, conversion, result);
        }
    }

    private static void dereferenceProxy(ProxyType proxyType, Set<String> values) {
        DereferenceUtils.convertValues(proxyType.getHasMetList(), RESOURCE_EXTRACTOR, values);
        DereferenceUtils.convertValues(proxyType.getHasTypeList(), RESOURCE_OR_LITERAL_EXTRACTOR, values);
        DereferenceUtils.convertValues(proxyType.getIncorporateList(), RESOURCE_EXTRACTOR, values);
        DereferenceUtils.convertValues(proxyType.getIsDerivativeOfList(), RESOURCE_EXTRACTOR, values);
        DereferenceUtils.convertValues(proxyType.getIsRelatedToList(), RESOURCE_OR_LITERAL_EXTRACTOR, values);
        DereferenceUtils.convertValues(proxyType.getIsSimilarToList(), RESOURCE_EXTRACTOR, values);
        DereferenceUtils.convertValues(proxyType.getIsSuccessorOfList(), RESOURCE_EXTRACTOR, values);
        DereferenceUtils.convertValues(proxyType.getRealizeList(), RESOURCE_EXTRACTOR, values);
        DereferenceUtils.convertValue(proxyType.getCurrentLocation(), RESOURCE_OR_LITERAL_EXTRACTOR, values);
        DereferenceUtils.extractValues(proxyType.getChoiceList(), item -> DereferenceUtils.dereferenceChoice(item, values));
    }

    private static void dereferenceChoice(EuropeanaType.Choice choice, Set<String> values) {
        DereferenceUtils.convertValue(choice.ifContributor(), choice.getContributor(), RESOURCE_OR_LITERAL_EXTRACTOR, values);
        DereferenceUtils.convertValue(choice.ifCoverage(), choice.getCoverage(), RESOURCE_OR_LITERAL_EXTRACTOR, values);
        DereferenceUtils.convertValue(choice.ifCreator(), choice.getCreator(), RESOURCE_OR_LITERAL_EXTRACTOR, values);
        DereferenceUtils.convertValue(choice.ifCreated(), choice.getCreated(), RESOURCE_OR_LITERAL_EXTRACTOR, values);
        DereferenceUtils.convertValue(choice.ifDate(), choice.getDate(), RESOURCE_OR_LITERAL_EXTRACTOR, values);
        DereferenceUtils.convertValue(choice.ifExtent(), choice.getExtent(), RESOURCE_OR_LITERAL_EXTRACTOR, values);
        DereferenceUtils.convertValue(choice.ifFormat(), choice.getFormat(), RESOURCE_OR_LITERAL_EXTRACTOR, values);
        DereferenceUtils.convertValue(choice.ifHasFormat(), choice.getHasFormat(), RESOURCE_OR_LITERAL_EXTRACTOR, values);
        DereferenceUtils.convertValue(choice.ifHasVersion(), choice.getHasVersion(), RESOURCE_OR_LITERAL_EXTRACTOR, values);
        DereferenceUtils.convertValue(choice.ifIsFormatOf(), choice.getIsFormatOf(), RESOURCE_OR_LITERAL_EXTRACTOR, values);
        DereferenceUtils.convertValue(choice.ifIsReferencedBy(), choice.getIsReferencedBy(), RESOURCE_OR_LITERAL_EXTRACTOR, values);
        DereferenceUtils.convertValue(choice.ifIsReplacedBy(), choice.getIsReplacedBy(), RESOURCE_OR_LITERAL_EXTRACTOR, values);
        DereferenceUtils.convertValue(choice.ifIsRequiredBy(), choice.getIsRequiredBy(), RESOURCE_OR_LITERAL_EXTRACTOR, values);
        DereferenceUtils.convertValue(choice.ifIsVersionOf(), choice.getIsVersionOf(), RESOURCE_OR_LITERAL_EXTRACTOR, values);
        DereferenceUtils.convertValue(choice.ifMedium(), choice.getMedium(), RESOURCE_OR_LITERAL_EXTRACTOR, values);
        DereferenceUtils.convertValue(choice.ifPublisher(), choice.getPublisher(), RESOURCE_OR_LITERAL_EXTRACTOR, values);
        DereferenceUtils.convertValue(choice.ifReferences(), choice.getReferences(), RESOURCE_OR_LITERAL_EXTRACTOR, values);
        DereferenceUtils.convertValue(choice.ifRelation(), choice.getRelation(), RESOURCE_OR_LITERAL_EXTRACTOR, values);
        DereferenceUtils.convertValue(choice.ifReplaces(), choice.getReplaces(), RESOURCE_OR_LITERAL_EXTRACTOR, values);
        DereferenceUtils.convertValue(choice.ifSource(), choice.getSource(), RESOURCE_OR_LITERAL_EXTRACTOR, values);
        DereferenceUtils.convertValue(choice.ifSpatial(), choice.getSpatial(), RESOURCE_OR_LITERAL_EXTRACTOR, values);
        DereferenceUtils.convertValue(choice.ifSubject(), choice.getSubject(), RESOURCE_OR_LITERAL_EXTRACTOR, values);
        DereferenceUtils.convertValue(choice.ifTemporal(), choice.getTemporal(), RESOURCE_OR_LITERAL_EXTRACTOR, values);
        DereferenceUtils.convertValue(choice.ifIssued(), choice.getIssued(), RESOURCE_OR_LITERAL_EXTRACTOR, values);
        DereferenceUtils.convertValue(choice.ifType(), choice.getType(), RESOURCE_OR_LITERAL_EXTRACTOR, values);
    }

    private static void dereferenceTimespan(TimeSpanType timespan, Set<String> result) {
        result.add(timespan.getAbout());
        DereferenceUtils.convertValues(timespan.getHasPartList(), RESOURCE_OR_LITERAL_EXTRACTOR, result);
        DereferenceUtils.convertValues(timespan.getIsPartOfList(), RESOURCE_OR_LITERAL_EXTRACTOR, result);
        DereferenceUtils.convertValues(timespan.getSameAList(), RESOURCE_EXTRACTOR, result);
    }

    private static void dereferenceAgent(AgentType agent, Set<String> result) {
        result.add(agent.getAbout());
        DereferenceUtils.convertValues(agent.getHasMetList(), RESOURCE_EXTRACTOR, result);
        DereferenceUtils.convertValues(agent.getIsRelatedToList(), RESOURCE_OR_LITERAL_EXTRACTOR, result);
    }

    private static void dereferenceConceptChoice(Concept.Choice choice, Set<String> result) {
        DereferenceUtils.convertValue(choice.ifBroadMatch(), choice.getBroadMatch(), RESOURCE_EXTRACTOR, result);
        DereferenceUtils.convertValue(choice.ifCloseMatch(), choice.getCloseMatch(), RESOURCE_EXTRACTOR, result);
        DereferenceUtils.convertValue(choice.ifExactMatch(), choice.getExactMatch(), RESOURCE_EXTRACTOR, result);
        DereferenceUtils.convertValue(choice.ifNarrowMatch(), choice.getNarrowMatch(), RESOURCE_EXTRACTOR, result);
        DereferenceUtils.convertValue(choice.ifRelated(), choice.getRelated(), RESOURCE_EXTRACTOR, result);
        DereferenceUtils.convertValue(choice.ifRelatedMatch(), choice.getRelatedMatch(), RESOURCE_EXTRACTOR, result);
    }

    private static void dereferencePlace(PlaceType place, Set<String> result) {
        result.add(place.getAbout());
        DereferenceUtils.convertValues(place.getIsPartOfList(), RESOURCE_OR_LITERAL_EXTRACTOR, result);
        DereferenceUtils.convertValues(place.getSameAList(), RESOURCE_EXTRACTOR, result);
        DereferenceUtils.convertValues(place.getHasPartList(), RESOURCE_OR_LITERAL_EXTRACTOR, result);
    }

    private static void dereferenceWebResource(WebResourceType wr, Set<String> result) {
        DereferenceUtils.convertValues(wr.getCreatedList(), RESOURCE_OR_LITERAL_EXTRACTOR, result);
        DereferenceUtils.convertValues(wr.getExtentList(), RESOURCE_OR_LITERAL_EXTRACTOR, result);
        DereferenceUtils.convertValues(wr.getFormatList(), RESOURCE_OR_LITERAL_EXTRACTOR, result);
        DereferenceUtils.convertValues(wr.getIsFormatOfList(), RESOURCE_OR_LITERAL_EXTRACTOR, result);
        DereferenceUtils.convertValues(wr.getIssuedList(), RESOURCE_OR_LITERAL_EXTRACTOR, result);
    }

    private static String extractFromResourceOrLiteral(ResourceOrLiteralType type) {
        if (type.getResource() != null && StringUtils.isNotEmpty((CharSequence)type.getResource().getResource())) {
            return type.getResource().getResource();
        }
        return null;
    }

    private static String extractFromResource(ResourceType type) {
        if (StringUtils.isNotEmpty((CharSequence)type.getResource())) {
            return type.getResource();
        }
        return null;
    }
}

