/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.rest.client;

import eu.europeana.enrichment.api.exceptions.UnknownException;
import eu.europeana.enrichment.api.external.InputValueList;
import eu.europeana.enrichment.api.external.model.EnrichmentBase;
import eu.europeana.enrichment.api.external.model.EnrichmentResultList;
import eu.europeana.enrichment.utils.InputValue;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class EnrichmentClient {
    private final String endpoint;
    private RestTemplate template = new RestTemplate();

    public EnrichmentClient(String endpoint) {
        this.endpoint = endpoint;
    }

    public EnrichmentResultList enrich(List<InputValue> values) {
        InputValueList inList = new InputValueList();
        inList.setInputValues(values);
        try {
            return (EnrichmentResultList)this.template.postForObject(this.endpoint + "/enrich", (Object)inList, EnrichmentResultList.class, new Object[0]);
        }
        catch (RestClientException e) {
            throw new UnknownException("Enrichment client call failed.", (Throwable)e);
        }
    }

    public EnrichmentBase getByUri(String uri) {
        String encodedUri;
        try {
            encodedUri = URLEncoder.encode(uri, StandardCharsets.UTF_8.name()).replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)(this.endpoint + "/getByUri")).queryParam("uri", new Object[]{encodedUri});
        HttpHeaders headers = new HttpHeaders();
        headers.set("Content-Type", "application/xml");
        HttpEntity request = new HttpEntity((MultiValueMap)headers);
        ResponseEntity response = this.template.exchange(builder.build(true).toUri(), HttpMethod.GET, request, EnrichmentBase.class);
        return (EnrichmentBase)response.getBody();
    }

    void setRestTemplate(RestTemplate template) {
        this.template = template;
    }
}

