/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.dereference.service.utils;

import eu.europeana.metis.dereference.Vocabulary;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VocabularyCandidates {
    private static final Logger LOGGER = LoggerFactory.getLogger(VocabularyCandidates.class);
    private final String resourceId;
    private final List<Vocabulary> candidates;

    VocabularyCandidates(String resourceId, List<Vocabulary> candidates) {
        this.resourceId = resourceId;
        this.candidates = new ArrayList<Vocabulary>(candidates);
    }

    public static VocabularyCandidates findVocabulariesForUrl(String resourceId, Function<String, List<Vocabulary>> searchInPersistence) throws URISyntaxException {
        String searchString = new URI(resourceId.replace(" ", "%20")).getHost();
        List<Vocabulary> searchedVocabularies = searchInPersistence.apply(searchString);
        List<Object> candidates = searchedVocabularies == null ? Collections.emptyList() : searchedVocabularies.stream().filter(vocabulary -> VocabularyCandidates.vocabularyMatchesUri(resourceId, vocabulary)).collect(Collectors.toList());
        if (candidates.isEmpty()) {
            LOGGER.info("No vocabularies found for uri {}", (Object)resourceId);
        }
        return new VocabularyCandidates(resourceId, candidates);
    }

    private static boolean vocabularyMatchesUri(String resourceId, Vocabulary vocabulary) {
        if (vocabulary.getRules() == null || vocabulary.getRules().isEmpty()) {
            return resourceId.startsWith(vocabulary.getUri());
        }
        return vocabulary.getRules().stream().anyMatch(rule -> resourceId.startsWith(vocabulary.getUri() + rule));
    }

    public Vocabulary findVocabularyWithoutTypeRules() {
        return this.candidates.stream().filter(vocabulary -> VocabularyCandidates.vocabularyMatchesType(vocabulary, "")).findAny().orElse(null);
    }

    public Vocabulary findVocabularyForType(String incomingDataXml) {
        Vocabulary result = this.candidates.stream().filter(vocabulary -> VocabularyCandidates.vocabularyMatchesType(vocabulary, incomingDataXml)).findAny().orElse(null);
        if (result == null) {
            LOGGER.info("No vocabularies found for resource {}", (Object)this.resourceId);
        }
        return result;
    }

    private static boolean vocabularyMatchesType(Vocabulary vocabulary, String incomingDataXml) {
        Set typeRules = vocabulary.getTypeRules();
        return typeRules == null || typeRules.isEmpty() || typeRules.stream().anyMatch(typeRule -> StringUtils.contains((String)incomingDataXml, (String)typeRule));
    }

    public Set<String> getCandidateSuffixes() {
        return this.candidates.stream().map(vocabulary -> vocabulary.getSuffix() == null ? "" : vocabulary.getSuffix()).collect(Collectors.toSet());
    }

    public boolean isEmpty() {
        return this.candidates.isEmpty();
    }

    List<Vocabulary> getCandidates() {
        return Collections.unmodifiableList(this.candidates);
    }
}

