/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.dereference.service.utils;

import eu.europeana.metis.dereference.OriginalEntity;
import eu.europeana.metis.dereference.service.dao.EntityDao;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RdfRetriever {
    private static final int MAX_NUMBER_OF_REDIRECTS = 5;
    private static final Logger LOGGER = LoggerFactory.getLogger(RdfRetriever.class);
    private final EntityDao entityDao;

    public RdfRetriever(EntityDao entityDao) {
        this.entityDao = entityDao;
    }

    public String retrieve(String resourceId, Set<String> possibleSuffixes) {
        OriginalEntity originalEntity = this.entityDao.get(resourceId);
        if (originalEntity == null) {
            originalEntity = this.retrieveFromSource(resourceId, possibleSuffixes);
            this.entityDao.save(originalEntity);
        }
        return originalEntity.getXml();
    }

    private OriginalEntity retrieveFromSource(String resourceId, Set<String> possibleSuffixes) {
        String suffix;
        if (resourceId == null) {
            throw new IllegalArgumentException("Parameter resourceId cannot be null.");
        }
        String content = null;
        Iterator<String> iterator = possibleSuffixes.iterator();
        while (iterator.hasNext() && (content = RdfRetriever.retrieveFromSource(resourceId, suffix = iterator.next())) == null) {
        }
        OriginalEntity originalEntity = new OriginalEntity();
        originalEntity.setURI(resourceId);
        originalEntity.setXml(content);
        return originalEntity;
    }

    private static String retrieveFromSource(String resourceId, String suffix) {
        try {
            return RdfRetriever.retrieveFromSource(resourceId, resourceId + suffix, 5);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to retrieve: {} with message: {}", (Object)resourceId, (Object)e.getMessage());
            LOGGER.debug("Problem retrieving resource.", (Throwable)e);
            return null;
        }
    }

    private static String retrieveFromSource(String resourceId, String url, int redirectsLeft) throws IOException {
        Object result;
        HttpURLConnection urlConnection = (HttpURLConnection)new URL(url).openConnection();
        urlConnection.setRequestProperty("accept", "application/rdf+xml");
        String resultString = IOUtils.toString((InputStream)urlConnection.getInputStream(), (Charset)StandardCharsets.UTF_8);
        int responseCode = urlConnection.getResponseCode();
        String contentType = urlConnection.getContentType();
        if (responseCode != 200) {
            LOGGER.info("Status code {} for url {} for resource {}.", new Object[]{responseCode, url, resourceId});
        }
        if (responseCode == 302 || responseCode == 301 || responseCode == 303) {
            String location = urlConnection.getHeaderField("Location");
            result = redirectsLeft > 0 && location != null ? RdfRetriever.retrieveFromSource(resourceId, location, redirectsLeft - 1) : null;
        } else {
            result = contentType != null && contentType.startsWith("text/html") ? null : (resultString != null && resultString.contains("<html>") ? null : resultString);
        }
        return result;
    }
}

