/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.dereference.service.utils;

import eu.europeana.metis.dereference.Vocabulary;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.regex.Pattern;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncomingRecordToEdmConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(IncomingRecordToEdmConverter.class);
    private static final String EMPTY_XML_REGEX = "\\A(<\\?.*?\\?>|<!--.*?-->|\\s)*\\Z";
    private static final Pattern EMPTY_XML_CHECKER = Pattern.compile("\\A(<\\?.*?\\?>|<!--.*?-->|\\s)*\\Z", 32);
    private static final String TARGET_ID_PARAMETER_NAME = "targetId";
    private final Templates template;

    public IncomingRecordToEdmConverter(Vocabulary vocabulary) throws TransformerException {
        StreamSource xsltSource = new StreamSource(new StringReader(vocabulary.getXslt()));
        this.template = TransformerFactory.newInstance().newTemplates(xsltSource);
    }

    public String convert(String record, String recordId) {
        try {
            StreamSource source = new StreamSource(new StringReader(record));
            StringWriter stringWriter = new StringWriter();
            Transformer transformer = this.template.newTransformer();
            transformer.setParameter(TARGET_ID_PARAMETER_NAME, recordId);
            transformer.transform(source, new StreamResult(stringWriter));
            String result = stringWriter.toString();
            boolean isEmpty = IncomingRecordToEdmConverter.isEmptyXml(result);
            if (isEmpty) {
                LOGGER.info("Could not transform entity {} as it results is an empty XML.", (Object)recordId);
            }
            return isEmpty ? null : result;
        }
        catch (TransformerException e) {
            LOGGER.warn("Error transforming entity: {} with message: {}", (Object)recordId, (Object)e.getMessage());
            LOGGER.debug("Transformation issue: ", (Throwable)e);
            return null;
        }
    }

    static boolean isEmptyXml(String file) {
        return EMPTY_XML_CHECKER.matcher(file).matches();
    }
}

